/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.nio;

import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelPipeline;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.DatagramChannel;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.DatagramChannelFactory;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.InternetProtocolFamily;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.nio.NioDatagramChannel;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.nio.NioDatagramPipelineSink;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.nio.NioDatagramWorker;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.nio.NioDatagramWorkerPool;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.nio.SelectorUtil;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.socket.nio.WorkerPool;
import com.alibaba.schedulerx.shade.org.jboss.netty.util.ExternalResourceReleasable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NioDatagramChannelFactory
implements DatagramChannelFactory {
    private final NioDatagramPipelineSink sink;
    private final WorkerPool<NioDatagramWorker> workerPool;
    private final InternetProtocolFamily family;
    private boolean releasePool;

    public NioDatagramChannelFactory() {
        this((InternetProtocolFamily)null);
    }

    public NioDatagramChannelFactory(InternetProtocolFamily family) {
        this.workerPool = new NioDatagramWorkerPool(Executors.newCachedThreadPool(), SelectorUtil.DEFAULT_IO_THREADS);
        this.family = family;
        this.sink = new NioDatagramPipelineSink(this.workerPool);
        this.releasePool = true;
    }

    public NioDatagramChannelFactory(Executor workerExecutor) {
        this(workerExecutor, SelectorUtil.DEFAULT_IO_THREADS);
    }

    public NioDatagramChannelFactory(Executor workerExecutor, int workerCount) {
        this(new NioDatagramWorkerPool(workerExecutor, workerCount));
    }

    public NioDatagramChannelFactory(WorkerPool<NioDatagramWorker> workerPool) {
        this(workerPool, null);
    }

    public NioDatagramChannelFactory(Executor workerExecutor, InternetProtocolFamily family) {
        this(workerExecutor, SelectorUtil.DEFAULT_IO_THREADS, family);
    }

    public NioDatagramChannelFactory(Executor workerExecutor, int workerCount, InternetProtocolFamily family) {
        this(new NioDatagramWorkerPool(workerExecutor, workerCount), family);
    }

    public NioDatagramChannelFactory(WorkerPool<NioDatagramWorker> workerPool, InternetProtocolFamily family) {
        this.workerPool = workerPool;
        this.family = family;
        this.sink = new NioDatagramPipelineSink(workerPool);
    }

    @Override
    public DatagramChannel newChannel(ChannelPipeline pipeline) {
        return new NioDatagramChannel(this, pipeline, this.sink, this.sink.nextWorker(), this.family);
    }

    @Override
    public void shutdown() {
        this.workerPool.shutdown();
        if (this.releasePool) {
            this.releasePool();
        }
    }

    @Override
    public void releaseExternalResources() {
        this.workerPool.shutdown();
        this.releasePool();
    }

    private void releasePool() {
        if (this.workerPool instanceof ExternalResourceReleasable) {
            ((ExternalResourceReleasable)((Object)this.workerPool)).releaseExternalResources();
        }
    }
}

