/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.spdy;

import com.alibaba.schedulerx.shade.org.jboss.netty.buffer.ChannelBuffer;
import com.alibaba.schedulerx.shade.org.jboss.netty.buffer.ChannelBuffers;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.spdy.SpdyCodecUtil;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.spdy.SpdyHeaderBlockRawEncoder;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.spdy.SpdyHeadersFrame;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.spdy.SpdyVersion;
import java.util.zip.Deflater;

class SpdyHeaderBlockZlibEncoder
extends SpdyHeaderBlockRawEncoder {
    private final Deflater compressor;
    private boolean finished;

    SpdyHeaderBlockZlibEncoder(SpdyVersion spdyVersion, int compressionLevel) {
        super(spdyVersion);
        if (compressionLevel < 0 || compressionLevel > 9) {
            throw new IllegalArgumentException("compressionLevel: " + compressionLevel + " (expected: 0-9)");
        }
        this.compressor = new Deflater(compressionLevel);
        this.compressor.setDictionary(SpdyCodecUtil.SPDY_DICT);
    }

    private int setInput(ChannelBuffer decompressed) {
        int len2 = decompressed.readableBytes();
        if (decompressed.hasArray()) {
            this.compressor.setInput(decompressed.array(), decompressed.arrayOffset() + decompressed.readerIndex(), len2);
        } else {
            byte[] in = new byte[len2];
            decompressed.getBytes(decompressed.readerIndex(), in);
            this.compressor.setInput(in, 0, in.length);
        }
        return len2;
    }

    private void encode(ChannelBuffer compressed) {
        while (this.compressInto(compressed)) {
            compressed.ensureWritableBytes(compressed.capacity() << 1);
        }
    }

    private boolean compressInto(ChannelBuffer compressed) {
        byte[] out = compressed.array();
        int off = compressed.arrayOffset() + compressed.writerIndex();
        int toWrite = compressed.writableBytes();
        int numBytes = this.compressor.deflate(out, off, toWrite, 2);
        compressed.writerIndex(compressed.writerIndex() + numBytes);
        return numBytes == toWrite;
    }

    public synchronized ChannelBuffer encode(SpdyHeadersFrame frame) throws Exception {
        if (frame == null) {
            throw new IllegalArgumentException("frame");
        }
        if (this.finished) {
            return ChannelBuffers.EMPTY_BUFFER;
        }
        ChannelBuffer decompressed = super.encode(frame);
        if (decompressed.readableBytes() == 0) {
            return ChannelBuffers.EMPTY_BUFFER;
        }
        ChannelBuffer compressed = ChannelBuffers.dynamicBuffer(decompressed.readableBytes());
        int len2 = this.setInput(decompressed);
        this.encode(compressed);
        decompressed.skipBytes(len2);
        return compressed;
    }

    public synchronized void end() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.compressor.end();
        super.end();
    }
}

