/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.spdy;

import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelEvent;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelHandlerContext;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelPipeline;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelUpstreamHandler;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.spdy.SpdyFrameCodec;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.spdy.SpdyHttpDecoder;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.spdy.SpdyHttpEncoder;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.spdy.SpdyHttpResponseStreamIdHandler;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.spdy.SpdySessionHandler;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.codec.spdy.SpdyVersion;
import com.alibaba.schedulerx.shade.org.jboss.netty.handler.ssl.SslHandler;
import javax.net.ssl.SSLEngine;

public abstract class SpdyOrHttpChooser
implements ChannelUpstreamHandler {
    private final int maxSpdyContentLength;
    private final int maxHttpContentLength;

    protected SpdyOrHttpChooser(int maxSpdyContentLength, int maxHttpContentLength) {
        this.maxSpdyContentLength = maxSpdyContentLength;
        this.maxHttpContentLength = maxHttpContentLength;
    }

    protected abstract SelectedProtocol getProtocol(SSLEngine var1);

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        SslHandler handler = ctx.getPipeline().get(SslHandler.class);
        if (handler == null) {
            throw new IllegalStateException("SslHandler is needed for SPDY");
        }
        ChannelPipeline pipeline = ctx.getPipeline();
        SelectedProtocol protocol = this.getProtocol(handler.getEngine());
        switch (protocol) {
            case None: {
                return;
            }
            case SpdyVersion3_1: {
                this.addSpdyHandlers(ctx, SpdyVersion.SPDY_3_1);
                break;
            }
            case HttpVersion1_0: 
            case HttpVersion1_1: {
                this.addHttpHandlers(ctx);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown SelectedProtocol");
            }
        }
        pipeline.remove(this);
        ctx.sendUpstream(e);
    }

    protected void addSpdyHandlers(ChannelHandlerContext ctx, SpdyVersion version) {
        ChannelPipeline pipeline = ctx.getPipeline();
        pipeline.addLast("spdyFrameCodec", new SpdyFrameCodec(version));
        pipeline.addLast("spdySessionHandler", new SpdySessionHandler(version, true));
        pipeline.addLast("spdyHttpEncoder", new SpdyHttpEncoder(version));
        pipeline.addLast("spdyHttpDecoder", new SpdyHttpDecoder(version, this.maxSpdyContentLength));
        pipeline.addLast("spdyStreamIdHandler", new SpdyHttpResponseStreamIdHandler());
        pipeline.addLast("httpRequestHandler", this.createHttpRequestHandlerForSpdy());
    }

    protected void addHttpHandlers(ChannelHandlerContext ctx) {
        ChannelPipeline pipeline = ctx.getPipeline();
        pipeline.addLast("httpRequestDecoder", new HttpRequestDecoder());
        pipeline.addLast("httpResponseEncoder", new HttpResponseEncoder());
        pipeline.addLast("httpChunkAggregator", new HttpChunkAggregator(this.maxHttpContentLength));
        pipeline.addLast("httpRequestHandler", this.createHttpRequestHandlerForHttp());
    }

    protected abstract ChannelUpstreamHandler createHttpRequestHandlerForHttp();

    protected ChannelUpstreamHandler createHttpRequestHandlerForSpdy() {
        return this.createHttpRequestHandlerForHttp();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SelectedProtocol {
        SpdyVersion3_1,
        HttpVersion1_1,
        HttpVersion1_0,
        None;

    }
}

