/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.actor;

import akka.actor.UntypedActor;
import com.alibaba.schedulerx.common.domain.LogReadResult;
import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.common.util.ExceptionUtil;
import com.alibaba.schedulerx.protocol.Server;
import com.alibaba.schedulerx.shade.com.google.common.collect.Lists;
import com.alibaba.schedulerx.shade.org.apache.commons.configuration.Configuration;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.log.appender.LogConfig;
import com.alibaba.schedulerx.worker.logcollector.LogCollectorFactory;
import java.util.ArrayList;

public class LogActor
extends UntypedActor {
    private static final Logger LOGGER = LogFactory.getLogger(LogActor.class);

    @Override
    public void onReceive(Object obj) throws Throwable {
        if (obj instanceof Server.ServerTailLogRequest) {
            this.handleTailLog((Server.ServerTailLogRequest)obj);
        } else if (obj instanceof Server.ServerReadLogRequest) {
            this.handleReadLog((Server.ServerReadLogRequest)obj);
        } else if (obj instanceof Server.ServerReadLogCharsRequest) {
            this.handleReadLogChars((Server.ServerReadLogCharsRequest)obj);
        } else if (obj instanceof Server.ServerPushLogConfigRequest) {
            this.handlePushLogConfig((Server.ServerPushLogConfigRequest)obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTailLog(Server.ServerTailLogRequest request) {
        Server.ServerTailLogResponse response = null;
        try {
            ArrayList<String> lines2 = Lists.newArrayList("not support");
            response = Server.ServerTailLogResponse.newBuilder().setSuccess(true).addAllLine(lines2).build();
            this.getSender().tell(response, this.getSelf());
        }
        catch (Throwable e) {
            try {
                LOGGER.error("", e);
                response = Server.ServerTailLogResponse.newBuilder().setSuccess(false).setMessage(ExceptionUtil.getMessage(e)).build();
                this.getSender().tell(response, this.getSelf());
            }
            catch (Throwable throwable) {
                this.getSender().tell(response, this.getSelf());
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleReadLog(Server.ServerReadLogRequest request) {
        Server.ServerReadLogResponse response = null;
        try {
            ArrayList<String> lines2 = Lists.newArrayList("not support");
            response = Server.ServerReadLogResponse.newBuilder().setSuccess(true).addAllLine(lines2).setOffset(request.getOffset() + (long)lines2.size()).setIsEnd(lines2.isEmpty()).build();
            this.getSender().tell(response, this.getSelf());
        }
        catch (Throwable e) {
            try {
                LOGGER.error("", e);
                response = Server.ServerReadLogResponse.newBuilder().setSuccess(false).setMessage(ExceptionUtil.getMessage(e)).build();
                this.getSender().tell(response, this.getSelf());
            }
            catch (Throwable throwable) {
                this.getSender().tell(response, this.getSelf());
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleReadLogChars(Server.ServerReadLogCharsRequest request) {
        Server.ServerReadLogCharsResponse response = null;
        try {
            LogReadResult logResult = new LogReadResult(true, "not support", 0L);
            response = Server.ServerReadLogCharsResponse.newBuilder().setSuccess(true).setLog(logResult.getLog()).setOffset(logResult.getOffset()).setIsEnd(logResult.isEnd()).build();
            this.getSender().tell(response, this.getSelf());
        }
        catch (Throwable e) {
            try {
                LOGGER.error("", e);
                response = Server.ServerReadLogCharsResponse.newBuilder().setSuccess(false).setMessage(ExceptionUtil.getMessage(e)).build();
                this.getSender().tell(response, this.getSelf());
            }
            catch (Throwable throwable) {
                this.getSender().tell(response, this.getSelf());
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePushLogConfig(Server.ServerPushLogConfigRequest request) {
        Server.ServerPushLogConfigResponse response = null;
        try {
            LogConfig.INSTANCE.setEnable(request.getEnable());
            Configuration conf = ConfigUtil.getWorkerConfig();
            if (request.hasType()) {
                LogConfig.INSTANCE.setType(request.getType());
                conf.setProperty("log.collector.type", request.getType());
                if (request.getType().equals("sls") && request.hasSlsAk() && request.hasSlsSk()) {
                    conf.setProperty("sls.aksk.encoded", true);
                    conf.setProperty("sls.ak", request.getSlsAk());
                    conf.setProperty("sls.sk", request.getSlsSk());
                }
            }
            if (request.hasConfig()) {
                LogConfig.INSTANCE.setConfig(request.getConfig());
                conf.setProperty("log.service.config", request.getConfig());
            }
            if (request.hasLevel()) {
                LogConfig.INSTANCE.setLevel(request.getLevel());
            }
            LogCollectorFactory.refresh();
            response = Server.ServerPushLogConfigResponse.newBuilder().setSuccess(false).build();
            this.getSender().tell(response, this.getSelf());
        }
        catch (Exception e) {
            try {
                LOGGER.error("", e);
                response = Server.ServerPushLogConfigResponse.newBuilder().setSuccess(false).setMessage(ExceptionUtil.getMessage(e)).build();
                this.getSender().tell(response, this.getSelf());
            }
            catch (Throwable throwable) {
                this.getSender().tell(response, this.getSelf());
                throw throwable;
            }
        }
    }
}

