/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.container;

import com.alibaba.schedulerx.common.util.IdUtil;
import com.alibaba.schedulerx.shade.com.google.common.collect.Maps;
import com.alibaba.schedulerx.shade.org.apache.commons.collections.CollectionUtils;
import com.alibaba.schedulerx.worker.container.Container;
import com.alibaba.schedulerx.worker.container.ShutdownMode;
import com.alibaba.schedulerx.worker.container.ThreadContainer;
import com.alibaba.schedulerx.worker.domain.JobContext;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;

public abstract class ContainerPool {
    private Map<String, Container> containerMap = Maps.newConcurrentMap();
    private Map<Long, String> instanceMasterActorPathMap = Maps.newConcurrentMap();
    protected Map<Long, Set<Future>> futureMap = Maps.newConcurrentMap();
    protected Map<String, AtomicLong> groupCountMap = Maps.newConcurrentMap();

    public Map<String, Container> getContainerMap() {
        return this.containerMap;
    }

    public void setContainerMap(Map<String, Container> containerMap) {
        this.containerMap = containerMap;
    }

    public Container get(String uniqueId) {
        return this.containerMap.get(uniqueId);
    }

    public void put(String uniqueId, Container container) {
        this.containerMap.put(uniqueId, container);
        if (container instanceof ThreadContainer) {
            String masterActorPath = ((ThreadContainer)container).getContext().getInstanceMasterActorPath();
            long jobInstanceId = ((ThreadContainer)container).getContext().getJobInstanceId();
            this.instanceMasterActorPathMap.put(jobInstanceId, masterActorPath);
        }
    }

    public Map<Long, String> getInstanceMasterActorPathMap() {
        return this.instanceMasterActorPathMap;
    }

    public void remove(String uniqueId) {
        Future future2;
        Container container = this.containerMap.remove(uniqueId);
        long jobInstanceId = IdUtil.parse(uniqueId, IdUtil.IdType.JOB_INSTANCE_ID);
        Set<Future> futureSet = this.futureMap.get(jobInstanceId);
        if (CollectionUtils.isNotEmpty(futureSet) && container instanceof ThreadContainer && (future2 = ((ThreadContainer)container).getFuture()) != null) {
            futureSet.remove(future2);
        }
    }

    public boolean contain(String uniqueId) {
        return this.containerMap.containsKey(uniqueId);
    }

    public abstract void submit(long var1, long var3, long var5, Container var7, int var8);

    public boolean destroyByInstance(long jobInstanceId, boolean mayInterruptIfRunning) {
        this.instanceMasterActorPathMap.remove(jobInstanceId);
        return true;
    }

    public abstract void setContext(JobContext var1);

    public abstract JobContext getContext();

    public abstract void removeContext();

    public abstract AtomicLong getInstanceLock(long var1, Long var3);

    public abstract void releaseInstanceLock(long var1);

    public abstract void shutdown(ShutdownMode var1) throws InterruptedException;

    public abstract String genThreadName(Long var1, Long var2, Long var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void record(Long jobId, String groupId) {
        AtomicLong count2 = this.groupCountMap.get(groupId);
        if (count2 == null) {
            Class<ContainerPool> clazz = ContainerPool.class;
            // MONITORENTER : com.alibaba.schedulerx.worker.container.ContainerPool.class
            count2 = this.groupCountMap.get(groupId);
            if (count2 == null) {
                count2 = new AtomicLong(0L);
                this.groupCountMap.put(groupId, count2);
            }
            // MONITOREXIT : clazz
        }
        count2.incrementAndGet();
    }

    public long getCount(String groupId) {
        AtomicLong count2 = this.groupCountMap.get(groupId);
        return count2 != null ? count2.get() : 0L;
    }
}

