/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.log;

import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.log.factory.Log4j2LoggerFactory;
import com.alibaba.schedulerx.worker.log.factory.Log4jLoggerFactory;
import com.alibaba.schedulerx.worker.log.factory.LogbackLoggerFactory;
import com.alibaba.schedulerx.worker.log.factory.NopLoggerFactory;
import com.alibaba.schedulerx.worker.log.factory.SchedulerxLoggerFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LogFactory {
    private static SchedulerxLoggerFactory LOGGER_FACTORY;
    private static Map<String, Logger> loggerCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger(String name) {
        Logger logger = loggerCache.get(name);
        if (logger == null) {
            SchedulerxLoggerFactory schedulerxLoggerFactory = LOGGER_FACTORY;
            synchronized (schedulerxLoggerFactory) {
                logger = loggerCache.get(name);
                if (logger == null) {
                    logger = LOGGER_FACTORY.getLogger(name);
                    loggerCache.put(name, logger);
                }
            }
        }
        return logger;
    }

    public static Logger getLogger(Class clazz) {
        return LogFactory.getLogger(clazz.getName());
    }

    private static void println(String msg) {
        System.out.println(msg);
    }

    static {
        try {
            LOGGER_FACTORY = new LogbackLoggerFactory();
            LogFactory.println("Schedulerx init JM logger with LogbackLoggerFactory success, " + LogFactory.class.getClassLoader());
        }
        catch (Throwable e1) {
            try {
                LOGGER_FACTORY = new Log4j2LoggerFactory();
                LogFactory.println("Schedulerx init JM logger with Log4j2LoggerFactory success, " + LogFactory.class.getClassLoader());
            }
            catch (Throwable e2) {
                try {
                    LOGGER_FACTORY = new Log4jLoggerFactory();
                    LogFactory.println("Schedulerx init JM logger with Log4jLoggerFactory success, " + LogFactory.class.getClassLoader());
                }
                catch (Throwable e3) {
                    LOGGER_FACTORY = new NopLoggerFactory();
                    LogFactory.println("Schedulerx init JM logger with NopLoggerFactory, pay attention. " + LogFactory.class.getClassLoader());
                }
            }
        }
        loggerCache = new ConcurrentHashMap<String, Logger>();
    }
}

