/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.logcollector;

import com.alibaba.schedulerx.common.domain.SlsInfo;
import com.alibaba.schedulerx.common.domain.StreamType;
import com.alibaba.schedulerx.common.util.Base64Util;
import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.common.util.ExceptionUtil;
import com.alibaba.schedulerx.common.util.JsonUtil;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer.Callback;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer.LogProducer;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer.Producer;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer.ProducerConfig;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer.ProjectConfig;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer.Result;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.LogItem;
import com.alibaba.schedulerx.shade.org.apache.commons.configuration.Configuration;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;
import com.alibaba.schedulerx.worker.SchedulerxWorker;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.log.appender.LogConfig;
import com.alibaba.schedulerx.worker.logcollector.LogCollector;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;

public class SlsLogCollector
extends LogCollector {
    private static final Logger LOGGER = LogFactory.getLogger(SlsLogCollector.class);
    private String project;
    private String logStore;
    private String endpoint;
    private String accessKeyId;
    private String accessKeySecret;
    private Producer producer;
    private ProducerConfig producerConfig = new ProducerConfig();

    public SlsLogCollector() {
        this.producerConfig.setMaxBlockMs(0L);
        this.producerConfig.setTotalSizeInBytes(0x1400000);
        ProjectConfig projectConfig = this.buildProjectConfig();
        if (projectConfig != null) {
            this.producer = new LogProducer(this.producerConfig);
            this.producer.putProjectConfig(projectConfig);
        }
    }

    @Override
    public void collect(long appGroupId, String key, String line, Throwable t, StreamType streamType, boolean isEnd) {
        try {
            ProjectConfig projectConfig;
            if (StringUtils.isEmpty(line)) {
                return;
            }
            if (this.producer == null && (projectConfig = this.buildProjectConfig()) != null) {
                this.producer = new LogProducer(this.producerConfig);
                this.producer.putProjectConfig(projectConfig);
            }
            if (this.producer == null) {
                return;
            }
            if (!LogConfig.INSTANCE.isEnable()) {
                return;
            }
            this.producer.send(this.project, this.logStore, this.createTopic(appGroupId), SchedulerxWorker.WORKER_ADDR, SlsLogCollector.generateLogItems(key, line, t, streamType), new Callback(){

                @Override
                public void onCompletion(Result result2) {
                    if (result2.isSuccessful()) {
                        LOGGER.debug("");
                    } else {
                        LOGGER.error("send sls log failed, " + result2);
                    }
                }
            });
        }
        catch (Exception e) {
            LOGGER.warn("SlS log send failed. message:{}, logContent:{}", e.getMessage(), line);
        }
    }

    private String createTopic(long appGroupId) {
        return "group-" + appGroupId;
    }

    private ProjectConfig buildProjectConfig() {
        Configuration conf = ConfigUtil.getWorkerConfig();
        String logServiceType = conf.getString("log.collector.type", "default");
        if (logServiceType.equalsIgnoreCase("sls")) {
            Object logConfig = null;
            Object[] logConfigList = conf.getStringArray("log.service.config");
            if (logConfigList.length > 1) {
                logConfig = StringUtils.join(logConfigList, ",");
            } else if (logConfigList.length == 1) {
                logConfig = logConfigList[0];
            }
            if (StringUtils.isNotEmpty((String)logConfig) && !((String)logConfig).equalsIgnoreCase("null")) {
                SlsInfo slsInfo = JsonUtil.fromJson((String)logConfig, SlsInfo.class);
                this.endpoint = slsInfo.getEndpoint();
                this.project = slsInfo.getProject();
                this.logStore = slsInfo.getLogstore();
                if (conf.getBoolean("sls.aksk.encoded", false)) {
                    String encodedAccessKeyId = conf.getString("sls.ak");
                    this.accessKeyId = Base64Util.decode(encodedAccessKeyId);
                    String encodedAccessKeySecret = conf.getString("sls.sk");
                    this.accessKeySecret = Base64Util.decode(encodedAccessKeySecret);
                } else {
                    this.accessKeyId = conf.getString("sls.ak");
                    this.accessKeySecret = conf.getString("sls.sk");
                }
                if (this.project != null && this.logStore != null && this.endpoint != null && this.accessKeyId != null && this.accessKeySecret != null) {
                    LogConfig.INSTANCE.setEnable(true);
                    return new ProjectConfig(this.project, this.endpoint, this.accessKeyId, this.accessKeySecret);
                }
            }
        }
        return null;
    }

    private static List<LogItem> generateLogItems(String key, String line, Throwable t, StreamType streamType) {
        ArrayList<LogItem> logItems = new ArrayList<LogItem>();
        LogItem item = new LogItem();
        logItems.add(item);
        item.SetTime((int)(System.currentTimeMillis() / 1000L));
        DateTime dateTime = new DateTime(System.currentTimeMillis());
        item.PushBack("executionId", key);
        item.PushBack("time", dateTime.toString("yyyy-MM-dd HH:mm:ss"));
        item.PushBack("level", StreamType.STD_ERR.equals((Object)streamType) ? "ERROR" : "INFO");
        item.PushBack("message", line);
        if (t != null) {
            item.PushBack("throwable", ExceptionUtil.getTrace(t));
        }
        item.PushBack("thread", Thread.currentThread().getName());
        item.PushBack("group", "schedulerx-framework");
        item.PushBack("log", line);
        return logItems;
    }
}

