/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.master;

import akka.actor.ActorContext;
import com.alibaba.schedulerx.common.domain.JobInstanceInfo;
import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.master.GridTaskMaster;
import com.alibaba.schedulerx.worker.master.persistence.H2FilePersistence;
import com.alibaba.schedulerx.worker.util.SystemManagementUtil;
import java.io.IOException;

public class BatchTaskMaster
extends GridTaskMaster {
    private static final Logger LOGGER = LogFactory.getLogger(BatchTaskMaster.class);

    public BatchTaskMaster(JobInstanceInfo jobInstanceInfo, ActorContext actorContext) throws Exception {
        super(jobInstanceInfo, actorContext);
        this.taskPersistence = H2FilePersistence.getInstance();
        this.taskPersistence.initTable();
    }

    @Override
    protected void doMetricsCheck() throws IOException {
        float maxDiskPercent;
        float usedDiskPercent = SystemManagementUtil.getUserDiskSpacePercent();
        if (usedDiskPercent > (maxDiskPercent = ConfigUtil.getWorkerConfig().getFloat("map.disk.percent.max", 0.9f))) {
            throw new IOException("disk usage:" + usedDiskPercent * 100.0f + ",beyond " + maxDiskPercent * 100.0f + "%!");
        }
    }
}

