/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.master;

import akka.actor.ActorContext;
import akka.actor.ActorSelection;
import akka.dispatch.OnFailure;
import akka.dispatch.OnSuccess;
import akka.pattern.Patterns;
import akka.util.Timeout;
import com.alibaba.schedulerx.common.domain.InstanceStatus;
import com.alibaba.schedulerx.common.domain.JobInstanceInfo;
import com.alibaba.schedulerx.common.domain.MapTaskProgress;
import com.alibaba.schedulerx.common.domain.MapTaskXAttrs;
import com.alibaba.schedulerx.common.domain.Metrics;
import com.alibaba.schedulerx.common.domain.TaskDispatchMode;
import com.alibaba.schedulerx.common.domain.TaskProgressCounter;
import com.alibaba.schedulerx.common.domain.TaskStatus;
import com.alibaba.schedulerx.common.domain.TimeType;
import com.alibaba.schedulerx.common.domain.WorkerProgressCounter;
import com.alibaba.schedulerx.common.domain.enums.RouteStrategyEnum;
import com.alibaba.schedulerx.common.monitor.MetricsCollector;
import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.common.util.ExceptionUtil;
import com.alibaba.schedulerx.common.util.HessianUtil;
import com.alibaba.schedulerx.common.util.IdUtil;
import com.alibaba.schedulerx.common.util.JobUtil;
import com.alibaba.schedulerx.common.util.JsonUtil;
import com.alibaba.schedulerx.protocol.Worker;
import com.alibaba.schedulerx.protocol.utils.FutureUtils;
import com.alibaba.schedulerx.shade.com.google.common.collect.Lists;
import com.alibaba.schedulerx.shade.com.google.common.collect.Maps;
import com.alibaba.schedulerx.shade.com.google.protobuf.ByteString;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.math.NumberUtils;
import com.alibaba.schedulerx.shade.scala.concurrent.ExecutionContext;
import com.alibaba.schedulerx.shade.scala.concurrent.Future;
import com.alibaba.schedulerx.shade.scala.concurrent.duration.Duration;
import com.alibaba.schedulerx.worker.SchedulerxWorker;
import com.alibaba.schedulerx.worker.actor.FutureExecutorPool;
import com.alibaba.schedulerx.worker.batch.ReqQueue;
import com.alibaba.schedulerx.worker.batch.TMStatusReqHandler;
import com.alibaba.schedulerx.worker.batch.TaskDispatchReqHandler;
import com.alibaba.schedulerx.worker.domain.JavaProcessorProfile;
import com.alibaba.schedulerx.worker.domain.JobContext;
import com.alibaba.schedulerx.worker.domain.TaskInfo;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.logcollector.LogCollector;
import com.alibaba.schedulerx.worker.logcollector.LogCollectorFactory;
import com.alibaba.schedulerx.worker.master.TaskMaster;
import com.alibaba.schedulerx.worker.master.persistence.TaskPersistence;
import com.alibaba.schedulerx.worker.metrics.WorkerLoadRegister;
import com.alibaba.schedulerx.worker.processor.JobProcessor;
import com.alibaba.schedulerx.worker.processor.JobProcessorEx;
import com.alibaba.schedulerx.worker.processor.MapJobProcessor;
import com.alibaba.schedulerx.worker.processor.MapReduceJobProcessor;
import com.alibaba.schedulerx.worker.processor.ProcessResult;
import com.alibaba.schedulerx.worker.route.Router;
import com.alibaba.schedulerx.worker.route.RouterFactory;
import com.alibaba.schedulerx.worker.util.ActorPathUtil;
import com.alibaba.schedulerx.worker.util.JobProcessorUtil;
import com.alibaba.schedulerx.worker.util.WorkerConfigUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.util.CollectionUtils;

public abstract class MapTaskMaster
extends TaskMaster {
    private static final Logger LOGGER = LogFactory.getLogger(MapTaskMaster.class);
    private volatile int index = 0;
    protected volatile int pageSize = ConfigUtil.getWorkerConfig().getInt("map.master.page.size", 100);
    protected volatile int queueSize = ConfigUtil.getWorkerConfig().getInt("map.master.queue.size", 10000);
    private volatile int dispatcherSize = ConfigUtil.getWorkerConfig().getInt("map.master.dispatcher.size", 5);
    protected ReqQueue<Worker.ContainerReportTaskStatusRequest> taskStatusReqQueue;
    protected TMStatusReqHandler<Worker.ContainerReportTaskStatusRequest> taskStatusReqBatchHandler;
    protected ReqQueue<Worker.MasterStartContainerRequest> taskBlockingQueue;
    protected TaskDispatchReqHandler<Worker.MasterStartContainerRequest> taskDispatchReqHandler;
    private volatile String rootTaskResult;
    protected TaskPersistence taskPersistence;
    protected Map<String, TaskProgressCounter> taskProgressMap = Maps.newConcurrentMap();
    protected Map<String, WorkerProgressCounter> workerProgressMap = Maps.newConcurrentMap();
    private Map<Long, String> taskResultMap = Maps.newHashMap();
    private Map<Long, TaskStatus> taskStatusMap = Maps.newHashMap();
    protected MapTaskXAttrs xAttrs = null;
    protected volatile AtomicInteger taskCounter = new AtomicInteger(0);
    protected ExecutionContext futureExecutor;
    private LogCollector logCollector = LogCollectorFactory.get();
    protected volatile boolean startStatusCheck = true;
    protected volatile boolean needReduce;
    protected Router router;

    public MapTaskMaster(JobInstanceInfo jobInstanceInfo, ActorContext actorContext) throws Exception {
        super(jobInstanceInfo, actorContext);
        this.futureExecutor = FutureExecutorPool.INSTANCE.get("MapTaskMaster");
        boolean random = ConfigUtil.getWorkerConfig().getBoolean("map.master.dispatch.random", false);
        List<String> allWorkers = jobInstanceInfo.getAllWorkers();
        if (CollectionUtils.isEmpty(allWorkers)) {
            throw new IllegalArgumentException("workers can't be empty! ");
        }
        if (random && !CollectionUtils.isEmpty(allWorkers)) {
            this.index = new Random().nextInt(allWorkers.size());
        }
    }

    @Override
    protected void init() {
        this.startStatusCheck = true;
        if (this.INITED) {
            return;
        }
        super.init();
        if (this.isWorkerLoadRouter()) {
            this.router = RouterFactory.getRouter(this.jobInstanceInfo.getAppGroupId(), this.jobInstanceInfo.getJobId(), RouteStrategyEnum.WORKER_LOAD.getValue(), this.jobInstanceInfo.getRouteStrategyContent());
            if (this.router != null && this.router instanceof WorkerLoadRegister) {
                ((WorkerLoadRegister)((Object)this.router)).clear();
            }
        }
        final String jobIdAndInstanceId = this.jobInstanceInfo.getJobId() + "_" + this.jobInstanceInfo.getJobInstanceId();
        LOGGER.info("jobInstanceId={}, map master config, pageSize:{}, queueSize:{}, dispatcherSize:{}, workerSize:{}", jobIdAndInstanceId, this.pageSize, this.queueSize, this.dispatcherSize, this.jobInstanceInfo.getAllWorkers().size());
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (!MapTaskMaster.this.isFinished()) {
                    try {
                        long startTime = System.currentTimeMillis();
                        List<TaskInfo> taskInfos = MapTaskMaster.this.taskPersistence.pull(MapTaskMaster.this.jobInstanceInfo.getJobInstanceId(), MapTaskMaster.this.pageSize);
                        LOGGER.debug("jobInstanceId={}, pull cost={}ms", MapTaskMaster.this.jobInstanceInfo.getJobInstanceId(), System.currentTimeMillis() - startTime);
                        if (taskInfos.isEmpty()) {
                            LOGGER.debug("pull task empty of jobInstanceId={}, sleep 10000 ms ...", MapTaskMaster.this.jobInstanceInfo.getJobInstanceId());
                            Thread.sleep(10000L);
                            continue;
                        }
                        LOGGER.info("jobInstanceId={}, failover retry dispatch taskList, size:{} , cost={}ms", MapTaskMaster.this.jobInstanceInfo.getJobInstanceId(), taskInfos.size(), System.currentTimeMillis() - startTime);
                        for (TaskInfo taskInfo : taskInfos) {
                            ByteString taskBody = null;
                            if (taskInfo.getTaskBody() != null) {
                                taskBody = ByteString.copyFrom(taskInfo.getTaskBody());
                            }
                            Worker.MasterStartContainerRequest.Builder builder = MapTaskMaster.this.convert2StartContainerRequestBuilder(MapTaskMaster.this.jobInstanceInfo, taskInfo.getTaskId(), taskInfo.getTaskName(), taskBody, true);
                            MapTaskMaster.this.taskBlockingQueue.submitRequest(builder.build());
                        }
                    }
                    catch (TimeoutException te) {
                        LOGGER.error("pull task timeout, uniqueId:{}", jobIdAndInstanceId, te);
                        MapTaskMaster.this.logCollector.collect(MapTaskMaster.this.jobInstanceInfo.getAppGroupId(), jobIdAndInstanceId, "map task pull fail:", te);
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    catch (Throwable e) {
                        MapTaskMaster.this.updateNewInstanceStatus(MapTaskMaster.this.getSerialNum(), InstanceStatus.FAILED, ExceptionUtil.getMessage(e));
                        MapTaskMaster.this.logCollector.collect(MapTaskMaster.this.jobInstanceInfo.getAppGroupId(), jobIdAndInstanceId, "map task pull fail:", e);
                        LOGGER.error("pull task error, uniqueId:{}", jobIdAndInstanceId, e);
                    }
                }
            }
        }, "Schedulerx-MapTaskMaster-pull-thread-" + jobIdAndInstanceId).start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                int checkInterval = ConfigUtil.getWorkerConfig().getInt("map.master.status.check.interval", 3000);
                while (!MapTaskMaster.this.isFinished()) {
                    try {
                        Thread.sleep(checkInterval);
                        if (!MapTaskMaster.this.isStartStatusCheck()) continue;
                        InstanceStatus newStatus = MapTaskMaster.this.taskPersistence.checkInstanceStatus(MapTaskMaster.this.jobInstanceInfo.getJobInstanceId());
                        if (newStatus.isFinish() && MapTaskMaster.this.taskDispatchReqHandler.isActive()) {
                            Thread.sleep(checkInterval);
                            continue;
                        }
                        String result2 = MapTaskMaster.this.getRootTaskResult();
                        if (newStatus.equals(InstanceStatus.SUCCESS)) {
                            int failCnt = 0;
                            int successCnt = 0;
                            int totalCnt = 0;
                            for (TaskProgressCounter taskProgressCounter : MapTaskMaster.this.taskProgressMap.values()) {
                                failCnt += taskProgressCounter.getFailed();
                                successCnt += taskProgressCounter.getSuccess();
                                totalCnt += taskProgressCounter.getTotal();
                            }
                            if (successCnt + failCnt < totalCnt) {
                                newStatus = InstanceStatus.FAILED;
                                LOGGER.warn("jobInstanceId={} turn into finish status, but count isn't correct, successCnt:{}, failCnt:{}, totalCnt:{}", MapTaskMaster.this.jobInstanceInfo.getJobInstanceId(), successCnt, failCnt, totalCnt);
                                result2 = "Turn into finish status, but count is wrong, sucCnt:" + successCnt + ", failCnt:" + failCnt + ", totalCnt:" + totalCnt + "; Basically, the reason is that some workers are shutdown.";
                            } else {
                                newStatus = failCnt > 0 ? InstanceStatus.FAILED : InstanceStatus.SUCCESS;
                            }
                        }
                        MapTaskMaster.this.updateNewInstanceStatus(MapTaskMaster.this.getSerialNum(), MapTaskMaster.this.jobInstanceInfo.getJobInstanceId(), newStatus, result2);
                    }
                    catch (Throwable e) {
                        LOGGER.error("status check error, uniqueId:{}", jobIdAndInstanceId, e);
                    }
                }
            }
        }, "Schedulerx-MapTaskMaster-status-check-thread-" + jobIdAndInstanceId).start();
        if (!JobUtil.isSecondTypeJob(TimeType.parseValue(this.jobInstanceInfo.getTimeType()))) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    while (!MapTaskMaster.this.isFinished()) {
                        Worker.WorkerReportJobInstanceProgressRequest request = Worker.WorkerReportJobInstanceProgressRequest.newBuilder().setJobId(MapTaskMaster.this.jobInstanceInfo.getJobId()).setJobInstanceId(MapTaskMaster.this.jobInstanceInfo.getJobInstanceId()).setProgress(MapTaskMaster.this.getJobInstanceProgress()).build();
                        MapTaskMaster.this.SERVER_DISCOVERY.getMapMasterRouter().tell(request, null);
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e) {
                            LOGGER.error("report status error, uniqueId={}", jobIdAndInstanceId, e);
                            break;
                        }
                    }
                }
            }, "Schedulerx-MapTaskMaster-report-progress-thread-" + jobIdAndInstanceId).start();
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!MapTaskMaster.this.isFinished()) {
                    try {
                        for (String workerIdAddr : MapTaskMaster.this.aliveCheckWorkerSet) {
                            try {
                                Worker.MasterCheckWorkerAliveRequest request;
                                String workerAddr = workerIdAddr.split("@")[1];
                                String[] tokens = workerAddr.split(":");
                                String host = tokens[0];
                                int port = Integer.valueOf(tokens[1]);
                                int times = 0;
                                while (times < 3) {
                                    Socket socket = new Socket();
                                    try {
                                        socket.connect(new InetSocketAddress(host, port), 5000);
                                        LOGGER.info("socket to {}:{} is reachable, times={}", host, port, times);
                                        break;
                                    }
                                    catch (Exception e) {
                                        LOGGER.info("socket to {}:{} is not reachable, times={}", host, port, times);
                                        Thread.sleep(5000L);
                                        ++times;
                                    }
                                    finally {
                                        if (socket == null) continue;
                                        socket.close();
                                    }
                                }
                                if (times >= 3) {
                                    LOGGER.warn("worker[{}] is down, start to remove this worker and failover tasks, jobInstanceId={}", workerIdAddr, MapTaskMaster.this.jobInstanceInfo.getJobInstanceId());
                                    MapTaskMaster.this.handleWorkerShutdown(workerIdAddr, true);
                                    continue;
                                }
                                long startTime = System.currentTimeMillis();
                                ActorSelection selection = MapTaskMaster.this.getActorContext().actorSelection(ActorPathUtil.getWorkerHeartbeatRouterPath(workerIdAddr));
                                Worker.MasterCheckWorkerAliveResponse response = (Worker.MasterCheckWorkerAliveResponse)FutureUtils.awaitResult(selection, (Object)(request = Worker.MasterCheckWorkerAliveRequest.newBuilder().setJobInstanceId(MapTaskMaster.this.jobInstanceInfo.getJobInstanceId()).setDispatchMode(MapTaskMaster.this.xAttrs.getTaskDispatchMode()).build()), 10L);
                                if (!response.getSuccess()) {
                                    LOGGER.warn("jobInstanceId={} of worker={} is not alive", MapTaskMaster.this.jobInstanceInfo.getJobInstanceId(), workerIdAddr, response.getMessage());
                                    MapTaskMaster.this.handleWorkerShutdown(workerIdAddr, true);
                                    Worker.MasterDestroyContainerPoolRequest destroyContainerPoolRequest = Worker.MasterDestroyContainerPoolRequest.newBuilder().setJobInstanceId(MapTaskMaster.this.jobInstanceInfo.getJobInstanceId()).setJobId(MapTaskMaster.this.jobInstanceInfo.getJobId()).setWorkerIdAddr(workerIdAddr).setSerialNum(MapTaskMaster.this.getSerialNum()).build();
                                    SchedulerxWorker.AtLeastDeliveryRoutingActor.tell(destroyContainerPoolRequest, null);
                                    continue;
                                }
                                MapTaskMaster.this.setWorkerLoad(workerIdAddr, response.getMetricsJson(), System.currentTimeMillis() - startTime);
                            }
                            catch (Exception e) {
                                LOGGER.error("Alive worker check failed.", e);
                                MapTaskMaster.this.handleWorkerShutdown(workerIdAddr, true);
                                Worker.MasterDestroyContainerPoolRequest destroyContainerPoolRequest = Worker.MasterDestroyContainerPoolRequest.newBuilder().setJobInstanceId(MapTaskMaster.this.jobInstanceInfo.getJobInstanceId()).setJobId(MapTaskMaster.this.jobInstanceInfo.getJobId()).setWorkerIdAddr(workerIdAddr).setSerialNum(MapTaskMaster.this.getSerialNum()).build();
                                SchedulerxWorker.AtLeastDeliveryRoutingActor.tell(destroyContainerPoolRequest, null);
                            }
                        }
                        Thread.sleep(10000L);
                    }
                    catch (Throwable e) {
                        LOGGER.error("check worker error, jobInstanceId={}", MapTaskMaster.this.jobInstanceInfo.getJobInstanceId(), e);
                    }
                }
            }
        }, "Schedulerx-MapTaskMaster-check-worker-alive-thread-" + jobIdAndInstanceId).start();
        if (this.xAttrs.getTaskDispatchMode().equals(TaskDispatchMode.PULL.getValue())) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    while (!MapTaskMaster.this.isFinished()) {
                        for (String workerIdAddr : MapTaskMaster.this.jobInstanceInfo.getAllWorkers()) {
                            try {
                                Worker.MasterNotifyWorkerPullRequest request;
                                ActorSelection selection = MapTaskMaster.this.getActorContext().actorSelection(ActorPathUtil.getWorkerJobInstancePath(workerIdAddr));
                                Worker.MasterNotifyWorkerPullResponse response = (Worker.MasterNotifyWorkerPullResponse)FutureUtils.awaitResult(selection, (Object)(request = Worker.MasterNotifyWorkerPullRequest.newBuilder().setJobInstanceId(MapTaskMaster.this.jobInstanceInfo.getJobInstanceId()).setPageSize(MapTaskMaster.this.xAttrs.getPageSize()).setQueueSize(MapTaskMaster.this.xAttrs.getQueueSize()).setTaskMasterAkkaPath(MapTaskMaster.this.getLocalTaskRouterPath()).setConsumerSize(MapTaskMaster.this.xAttrs.getConsumerSize()).setSerialNum(MapTaskMaster.this.getSerialNum()).build()), 5L);
                                if (response.getSuccess()) continue;
                                String errorMsg = response.getMessage();
                                LOGGER.error("notify worker pull failed, jobInstanceId={}", MapTaskMaster.this.jobInstanceInfo.getJobInstanceId(), errorMsg);
                                MapTaskMaster.this.updateNewInstanceStatus(MapTaskMaster.this.getSerialNum(), MapTaskMaster.this.jobInstanceInfo.getJobInstanceId(), InstanceStatus.FAILED, errorMsg);
                            }
                            catch (Throwable e) {
                                LOGGER.error("notify worker pull error, jobInstanceId={}, worker={}", jobIdAndInstanceId, workerIdAddr, e);
                            }
                        }
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e) {
                            LOGGER.error("", e);
                        }
                    }
                }
            }, "Schedulerx-PullTaskMaster-notify-workers-pull-thread-" + jobIdAndInstanceId).start();
        }
    }

    @Override
    public synchronized void submitInstance(JobInstanceInfo jobInstanceInfo) throws Exception {
        try {
            long startTime = System.currentTimeMillis();
            if (this.dispatcherSize > 200) {
                this.dispatcherSize = 200;
            }
            this.startBatchHandler();
            this.createRootTask();
            LOGGER.info("jobInstanceId={} create root task, cost={}ms", jobInstanceInfo.getJobInstanceId(), System.currentTimeMillis() - startTime);
            this.init();
        }
        catch (Throwable e) {
            String jobIdAndInstanceId = jobInstanceInfo.getJobId() + "_" + jobInstanceInfo.getJobInstanceId();
            LOGGER.error("", e);
            this.updateNewInstanceStatus(this.getSerialNum(), InstanceStatus.FAILED, ExceptionUtil.getMessage(e));
            this.logCollector.collect(jobInstanceInfo.getAppGroupId(), jobIdAndInstanceId, "instance init fail:", e);
        }
    }

    @Override
    public void batchUpdateTaskStatus(Worker.ContainerBatchReportTaskStatuesRequest request) throws Exception {
        String workerIdAddr = request.getWorkerId() + "@" + request.getWorkerAddr();
        this.setWorkerLoad(workerIdAddr, request.getMetricsJson(), null);
        super.batchUpdateTaskStatus(request);
    }

    @Override
    public void updateTaskStatus(Worker.ContainerReportTaskStatusRequest request) {
        try {
            this.taskStatusReqQueue.submitRequest(request);
        }
        catch (Throwable e) {
            LOGGER.error("", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batchUpdateTaskStatues(List<Worker.ContainerReportTaskStatusRequest> requests) {
        HashMap<Long, Worker.ContainerReportTaskStatusRequest> finalTaskStatus = Maps.newHashMap();
        try {
            for (Worker.ContainerReportTaskStatusRequest request : requests) {
                MapTaskMaster mapTaskMaster;
                TaskStatus taskStatus = TaskStatus.parseValue(request.getStatus());
                if (!finalTaskStatus.containsKey(request.getTaskId()) || taskStatus.isFinish()) {
                    finalTaskStatus.put(request.getTaskId(), request);
                }
                String workerAddr = request.getWorkerAddr();
                String taskName = request.getTaskName();
                LOGGER.debug("report task status:{} from worker:{}, uniqueId:{}", taskStatus.getDescription(), workerAddr, IdUtil.getUniqueId(request.getJobId(), request.getJobInstanceId(), request.getTaskId()));
                if (!this.taskProgressMap.containsKey(taskName)) {
                    mapTaskMaster = this;
                    synchronized (mapTaskMaster) {
                        if (!this.taskProgressMap.containsKey(taskName)) {
                            TaskProgressCounter taskProgressCounter = new TaskProgressCounter(taskName);
                            this.taskProgressMap.put(taskName, taskProgressCounter);
                        }
                    }
                }
                if (workerAddr != null && !this.workerProgressMap.containsKey(workerAddr)) {
                    mapTaskMaster = this;
                    synchronized (mapTaskMaster) {
                        if (!this.workerProgressMap.containsKey(workerAddr)) {
                            WorkerProgressCounter workerProgressCounter = new WorkerProgressCounter(workerAddr);
                            this.workerProgressMap.put(workerAddr, workerProgressCounter);
                            if (StringUtils.isNotBlank(request.getTraceId())) {
                                workerProgressCounter.setTraceId(request.getTraceId());
                            }
                        }
                    }
                }
                if (taskStatus.equals(TaskStatus.RUNNING)) {
                    this.taskProgressMap.get(taskName).incrementRunning();
                    if (workerAddr != null) {
                        this.workerProgressMap.get(workerAddr).incrementRunning();
                    }
                } else if (taskStatus.equals(TaskStatus.SUCCESS)) {
                    this.taskProgressMap.get(taskName).incrementSuccess();
                    if (workerAddr != null) {
                        this.workerProgressMap.get(workerAddr).incrementSuccess();
                    }
                } else if (taskStatus.equals(TaskStatus.FAILED)) {
                    LOGGER.error("Report task status:{} result:{} from worker:{}, uniqueId:{}", taskStatus.getDescription(), request.getResult(), workerAddr, IdUtil.getUniqueId(request.getJobId(), request.getJobInstanceId(), request.getTaskId()));
                    this.taskProgressMap.get(taskName).incrementFailed();
                    if (workerAddr != null) {
                        this.workerProgressMap.get(workerAddr).incrementFailed();
                        if (StringUtils.isNotBlank(request.getTraceId())) {
                            this.workerProgressMap.get(workerAddr).setTraceId(request.getTraceId());
                        }
                    }
                }
                if (!this.needReduce) continue;
                this.taskResultMap.put(request.getTaskId(), request.getResult());
                this.taskStatusMap.put(request.getTaskId(), taskStatus);
            }
        }
        catch (Throwable e) {
            LOGGER.error("jobInstanceId={}, update progressMap error.", this.jobInstanceInfo.getJobInstanceId(), e);
        }
        try {
            long startTime = System.currentTimeMillis();
            int index = requests.size() - 1;
            if (index >= 0 && TaskStatus.FAILED.getValue() == requests.get(index).getStatus() && "MAP_TASK_ROOT".equals(requests.get(index).getTaskName())) {
                this.setRootTaskResult(requests.get(index).getResult());
            }
            boolean updateSuccess = false;
            for (int i = 0; i < 3; ++i) {
                try {
                    this.taskPersistence.updateTaskStatues(Lists.newArrayList(finalTaskStatus.values()));
                    updateSuccess = true;
                    break;
                }
                catch (Throwable t) {
                    LOGGER.error("jobInstanceId={}, persistent batch updateTaskStatus error.", t);
                    continue;
                }
            }
            if (!updateSuccess) {
                this.updateNewInstanceStatus(this.getSerialNum(), InstanceStatus.FAILED, "persistent batch update TaskStatus error up to 3 times");
            }
            LOGGER.debug("{} batch update status db cost:{}", this.jobInstanceInfo.getJobInstanceId(), System.currentTimeMillis() - startTime);
        }
        catch (Throwable e) {
            LOGGER.error("jobInstanceId={}, batch updateTaskStatus error.", this.jobInstanceInfo.getJobInstanceId(), e);
        }
    }

    public boolean map(List<ByteString> taskList, String taskName) throws Exception {
        LOGGER.debug("map taskName:{}, size:{}", taskName, taskList.size());
        this.initTaskProgress(taskName, taskList.size());
        for (ByteString taskBody : taskList) {
            Worker.MasterStartContainerRequest startContainerRequest = this.convert2StartContainerRequest(this.jobInstanceInfo, this.aquireTaskId(), taskName, taskBody);
            this.taskBlockingQueue.submitRequest(startContainerRequest);
        }
        return this.machineOverload();
    }

    protected void clearTasks(long jobInstanceId) {
        try {
            this.taskPersistence.clearTasks(jobInstanceId);
            LOGGER.info("jobInstanceId={} clearTasks success.", jobInstanceId);
        }
        catch (Throwable ex) {
            LOGGER.error("jobInstanceId={} clearTasks error", jobInstanceId, ex);
        }
    }

    protected void createRootTask() throws Exception {
        String taskName = "MAP_TASK_ROOT";
        ByteString taskBody = ByteString.copyFrom(HessianUtil.toBytes("MAP_TASK_ROOT"));
        this.initTaskProgress(taskName, 1);
        Worker.MasterStartContainerRequest startContainerRequest = this.convert2StartContainerRequest(this.jobInstanceInfo, this.aquireTaskId(), taskName, taskBody);
        this.batchDispatchTasks(Lists.newArrayList(startContainerRequest), this.getLocalWorkerIdAddr());
    }

    private void initTaskFailover(List<Worker.MasterStartContainerRequest> reqs, String workerIdAddr) {
        LOGGER.warn("jobInstanceId={}, worker[{}] is down, try another worker, size:{}", this.jobInstanceInfo.getJobInstanceId(), workerIdAddr, reqs.size());
        String workerId = workerIdAddr.split("@")[0];
        String workerAddr = workerIdAddr.split("@")[1];
        ArrayList<Long> taskIds = Lists.newArrayList();
        for (Worker.MasterStartContainerRequest req : reqs) {
            taskIds.add(req.getTaskId());
        }
        try {
            int affectCnt = this.taskPersistence.updateTaskStatus(this.jobInstanceInfo.getJobInstanceId(), taskIds, TaskStatus.INIT, workerId, workerAddr);
            LOGGER.warn("jobInstanceId={}, worker[{}] is down, reset task status, size:{}", this.jobInstanceInfo.getJobInstanceId(), workerIdAddr, affectCnt);
            this.workerProgressMap.get(workerAddr).decPulledAndTotal(affectCnt);
        }
        catch (Exception e1) {
            LOGGER.error("jobInstanceId={}, timeout return init error", this.jobInstanceInfo.getJobInstanceId());
            this.updateNewInstanceStatus(this.getSerialNum(), InstanceStatus.FAILED, "timeout dispatch return init error");
        }
    }

    private void processDispatchException(String workerIdAddr, List<Worker.MasterStartContainerRequest> reqs, Throwable e) {
        boolean failover;
        String workerId = workerIdAddr.split("@")[0];
        String workerAddr = workerIdAddr.split("@")[1];
        boolean bl = failover = this.xAttrs != null && this.xAttrs.isFailover();
        if (failover && e instanceof TimeoutException) {
            this.initTaskFailover(reqs, workerIdAddr);
        } else {
            String uniqueIdWithoutTask = IdUtil.getUniqueIdWithoutTask(this.jobInstanceInfo.getJobId(), this.jobInstanceInfo.getJobInstanceId());
            LOGGER.error("jobInstanceId:{}, batch dispatch Tasks error worker={}, size:{}", this.jobInstanceInfo.getJobInstanceId(), workerIdAddr, reqs.size(), e);
            this.logCollector.collect(this.jobInstanceInfo.getAppGroupId(), uniqueIdWithoutTask, "map task dispatch fail:", e);
            for (Worker.MasterStartContainerRequest req : reqs) {
                Worker.ContainerReportTaskStatusRequest faileReq = Worker.ContainerReportTaskStatusRequest.newBuilder().setJobId(this.jobInstanceInfo.getJobId()).setJobInstanceId(this.jobInstanceInfo.getJobInstanceId()).setTaskId(req.getTaskId()).setStatus(TaskStatus.FAILED.getValue()).setResult("Dispatch tasks error. Cause by " + e.getMessage()).setWorkerId(workerId).setTaskName(req.getTaskName()).setWorkerAddr(workerAddr).setTaskName(req.getTaskName()).build();
                this.updateTaskStatus(faileReq);
            }
        }
        this.setWorkerInvalid(workerIdAddr);
    }

    private void processDispatchResponse(String workerIdAddr, List<Worker.MasterStartContainerRequest> reqs, Worker.MasterBatchStartContainersResponse response, long startTime) {
        String workerId = workerIdAddr.split("@")[0];
        String workerAddr = workerIdAddr.split("@")[1];
        if (response.getSuccess()) {
            LOGGER.info("jobInstanceId={}, batch start containers successfully, size:{} , worker={}, cost={}ms", this.jobInstanceInfo.getJobInstanceId(), reqs.size(), workerIdAddr, System.currentTimeMillis() - startTime);
            this.aliveCheckWorkerSet.add(workerIdAddr);
            String metricsJson = response.getMetricsJson();
            this.setWorkerLoad(workerIdAddr, metricsJson, System.currentTimeMillis() - startTime);
        } else {
            boolean failover;
            boolean bl = failover = this.xAttrs != null && this.xAttrs.isFailover();
            if (failover && response.getMessage() != null && response.getMessage().contains("WORKER_NOT_RUNNING:")) {
                this.initTaskFailover(reqs, workerIdAddr);
            } else {
                LOGGER.error("jobInstanceId={}, batch start containers failed, worker={}, response={}, size:{}", this.jobInstanceInfo.getJobInstanceId(), workerIdAddr, response.getMessage(), reqs.size());
                for (Worker.MasterStartContainerRequest req : reqs) {
                    Worker.ContainerReportTaskStatusRequest faileStatusRequest = Worker.ContainerReportTaskStatusRequest.newBuilder().setJobId(this.jobInstanceInfo.getJobId()).setJobInstanceId(this.jobInstanceInfo.getJobInstanceId()).setTaskId(req.getTaskId()).setStatus(TaskStatus.FAILED.getValue()).setResult(response.getMessage()).setWorkerId(workerId).setTaskName(req.getTaskName()).setWorkerAddr(workerAddr).setTaskName(req.getTaskName()).build();
                    this.updateTaskStatus(faileStatusRequest);
                }
            }
            this.setWorkerInvalid(workerIdAddr);
        }
    }

    private void batchHandleContainers(final String workerIdAddr, final List<Worker.MasterStartContainerRequest> reqs, boolean isFailover, TaskDispatchMode dispatchMode) {
        String workerId = workerIdAddr.split("@")[0];
        String workerAddr = workerIdAddr.split("@")[1];
        LOGGER.debug("jobInstanceId={}, batch dispatch, worker:{}, size:{}", this.jobInstanceInfo.getJobInstanceId(), workerIdAddr, reqs.size());
        try {
            this.batchHandlePersistence(workerId, workerAddr, reqs, isFailover);
            if (dispatchMode.equals((Object)TaskDispatchMode.PUSH)) {
                final long startTime = System.currentTimeMillis();
                ActorSelection selection = this.getActorContext().actorSelection(ActorPathUtil.getContainerRouterPath(workerIdAddr));
                Worker.MasterBatchStartContainersRequest request = Worker.MasterBatchStartContainersRequest.newBuilder().setJobInstanceId(this.jobInstanceInfo.getJobInstanceId()).setJobId(this.jobInstanceInfo.getJobId()).addAllStartReqs(reqs).build();
                Timeout timeout = new Timeout(Duration.create(3L, TimeUnit.SECONDS));
                if (this.isWorkerLoadRouter()) {
                    try {
                        Worker.MasterBatchStartContainersResponse response = (Worker.MasterBatchStartContainersResponse)FutureUtils.awaitResult(selection, (Object)request, 3L);
                        this.processDispatchResponse(workerIdAddr, reqs, response, startTime);
                    }
                    catch (Throwable e) {
                        this.processDispatchException(workerIdAddr, reqs, e);
                    }
                } else {
                    Future<Object> future2 = Patterns.ask(selection, (Object)request, timeout);
                    future2.onSuccess(new OnSuccess<Object>(){

                        @Override
                        public void onSuccess(Object obj) throws Throwable {
                            Worker.MasterBatchStartContainersResponse response = (Worker.MasterBatchStartContainersResponse)obj;
                            MapTaskMaster.this.processDispatchResponse(workerIdAddr, reqs, response, startTime);
                        }
                    }, this.futureExecutor);
                    future2.onFailure(new OnFailure(){

                        @Override
                        public void onFailure(Throwable e) throws Throwable {
                            MapTaskMaster.this.processDispatchException(workerIdAddr, reqs, e);
                        }
                    }, this.futureExecutor);
                }
            } else {
                this.aliveCheckWorkerSet.add(workerIdAddr);
            }
        }
        catch (Throwable exception) {
            String uniqueIdWithoutTask = IdUtil.getUniqueIdWithoutTask(this.jobInstanceInfo.getJobId(), this.jobInstanceInfo.getJobInstanceId());
            LOGGER.error("jobInstanceId:{}, batch dispatch Tasks error worker={}, size:{}", this.jobInstanceInfo.getJobInstanceId(), workerIdAddr, reqs.size(), exception);
            this.logCollector.collect(this.jobInstanceInfo.getAppGroupId(), uniqueIdWithoutTask, "map task dispatch fail:", exception);
            for (Worker.MasterStartContainerRequest req : reqs) {
                Worker.ContainerReportTaskStatusRequest faileReq = Worker.ContainerReportTaskStatusRequest.newBuilder().setJobId(this.jobInstanceInfo.getJobId()).setJobInstanceId(this.jobInstanceInfo.getJobInstanceId()).setTaskId(req.getTaskId()).setStatus(TaskStatus.FAILED.getValue()).setWorkerId(workerId).setTaskName(req.getTaskName()).setWorkerAddr(workerAddr).setTaskName(req.getTaskName()).build();
                this.updateTaskStatus(faileReq);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setWorkerLoad(String workerIdAddr, String metricsJson, Long cost) {
        block7: {
            try {
                if (this.router == null || !(this.router instanceof WorkerLoadRegister) || !StringUtils.isNotEmpty(metricsJson)) break block7;
                Metrics metrics = JsonUtil.fromJson(metricsJson, Metrics.class);
                if (metrics != null) {
                    LOGGER.info("update worker load, worker={}, sharePoolAvailableSize={}, cost={}", workerIdAddr, metrics.getSharePoolAvailableSize(), cost);
                    ((WorkerLoadRegister)((Object)this.router)).setAvailableSize(workerIdAddr, metrics.getSharePoolAvailableSize());
                    ((WorkerLoadRegister)((Object)this.router)).setRemainCpu(workerIdAddr, (int)((double)metrics.getCpuProcessors() - metrics.getCpuLoad1()));
                    ((WorkerLoadRegister)((Object)this.router)).setRemainMemory(workerIdAddr, (long)(100.0 - metrics.getHeap1Usage() * 100.0));
                    if (cost != null) {
                        ((WorkerLoadRegister)((Object)this.router)).setCost(workerIdAddr, cost);
                    }
                }
                Router router = this.router;
                synchronized (router) {
                    this.router.notifyAll();
                }
            }
            catch (Exception e) {
                LOGGER.warn("Set worker load failed.", e);
            }
        }
    }

    private void setWorkerInvalid(String workerIdAddr) {
        try {
            this.invalidWorkerSet.add(workerIdAddr);
            if (this.router != null && this.router instanceof WorkerLoadRegister) {
                ((WorkerLoadRegister)((Object)this.router)).setAvailableSize(workerIdAddr, 0);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Set worker load failed.", e);
        }
    }

    private void batchHandlePersistence(String workerId, String workerAddr, List<Worker.MasterStartContainerRequest> reqs, boolean isFailover) throws Exception {
        long startTime = System.currentTimeMillis();
        if (!isFailover) {
            this.taskPersistence.createTasks(reqs, workerId, workerAddr);
            if (this.needReduce) {
                for (Worker.MasterStartContainerRequest req : reqs) {
                    this.taskStatusMap.put(req.getTaskId(), TaskStatus.INIT);
                }
            }
        } else {
            ArrayList<Long> taskIds = Lists.newArrayList();
            for (Worker.MasterStartContainerRequest req : reqs) {
                taskIds.add(req.getTaskId());
            }
            this.taskPersistence.updateTaskStatus(this.jobInstanceInfo.getJobInstanceId(), taskIds, TaskStatus.RUNNING, workerId, workerAddr);
        }
        LOGGER.debug("jobInstance={}, batch dispatch db cost:{} ms, size:{}", this.jobInstanceInfo.getJobInstanceId(), System.currentTimeMillis() - startTime, reqs.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void batchHandlePulledProgress(List<Worker.MasterStartContainerRequest> masterStartContainerRequests, Map<String, List<Worker.MasterStartContainerRequest>> worker2ReqsWithNormal, Map<String, List<Worker.MasterStartContainerRequest>> worker2ReqsWithFailover, String remoteWorker) {
        for (Worker.MasterStartContainerRequest request : masterStartContainerRequests) {
            String workerIdAddr;
            String string2 = workerIdAddr = remoteWorker != null ? remoteWorker : this.selectWorker(request.getFailover());
            if (workerIdAddr == null) {
                this.updateNewInstanceStatus(this.getSerialNum(), InstanceStatus.FAILED, "all worker is down!");
                break;
            }
            String workerAddr = workerIdAddr.split("@")[1];
            if (request.getFailover()) {
                if (!worker2ReqsWithFailover.containsKey(workerIdAddr)) {
                    worker2ReqsWithFailover.put(workerIdAddr, Lists.newArrayList(request));
                } else {
                    worker2ReqsWithFailover.get(workerIdAddr).add(request);
                }
            } else {
                if (!worker2ReqsWithNormal.containsKey(workerIdAddr)) {
                    worker2ReqsWithNormal.put(workerIdAddr, Lists.newArrayList(request));
                } else {
                    worker2ReqsWithNormal.get(workerIdAddr).add(request);
                }
                this.taskProgressMap.get(request.getTaskName()).incrementPulled();
            }
            if (workerAddr != null && !this.workerProgressMap.containsKey(workerAddr)) {
                MapTaskMaster mapTaskMaster = this;
                synchronized (mapTaskMaster) {
                    if (!this.workerProgressMap.containsKey(workerAddr)) {
                        WorkerProgressCounter workerProgressCounter = new WorkerProgressCounter(workerAddr);
                        this.workerProgressMap.put(workerAddr, workerProgressCounter);
                    }
                }
            }
            this.workerProgressMap.get(workerAddr).incrementTotal();
            this.workerProgressMap.get(workerAddr).incrementPulled();
        }
    }

    public void batchDispatchTasks(List<Worker.MasterStartContainerRequest> masterStartContainerRequests) {
        this.batchDispatchTasks(masterStartContainerRequests, null);
    }

    public void batchDispatchTasks(List<Worker.MasterStartContainerRequest> masterStartContainerRequests, String remoteWorker) {
        HashMap<String, List<Worker.MasterStartContainerRequest>> worker2ReqsWithNormal = Maps.newHashMap();
        HashMap<String, List<Worker.MasterStartContainerRequest>> worker2ReqsWithFailover = Maps.newHashMap();
        this.batchHandlePulledProgress(masterStartContainerRequests, worker2ReqsWithNormal, worker2ReqsWithFailover, remoteWorker);
        for (Map.Entry entry : worker2ReqsWithNormal.entrySet()) {
            this.batchHandleContainers((String)entry.getKey(), (List)entry.getValue(), false, TaskDispatchMode.PUSH);
        }
        for (Map.Entry entry : worker2ReqsWithFailover.entrySet()) {
            this.batchHandleContainers((String)entry.getKey(), (List)entry.getValue(), true, TaskDispatchMode.PUSH);
        }
    }

    public void batchPullTasks(List<Worker.MasterStartContainerRequest> masterStartContainerRequests, String workerIdAddr) {
        HashMap<String, List<Worker.MasterStartContainerRequest>> worker2ReqsWithNormal = Maps.newHashMap();
        HashMap<String, List<Worker.MasterStartContainerRequest>> worker2ReqsWithFailover = Maps.newHashMap();
        this.batchHandlePulledProgress(masterStartContainerRequests, worker2ReqsWithNormal, worker2ReqsWithFailover, workerIdAddr);
        for (Map.Entry entry : worker2ReqsWithNormal.entrySet()) {
            this.batchHandleContainers((String)entry.getKey(), (List)entry.getValue(), false, TaskDispatchMode.PULL);
        }
        for (Map.Entry entry : worker2ReqsWithFailover.entrySet()) {
            this.batchHandleContainers((String)entry.getKey(), (List)entry.getValue(), true, TaskDispatchMode.PULL);
        }
    }

    protected synchronized String selectWorker(Boolean failover) {
        String worker;
        List<String> allWorkers = this.jobInstanceInfo.getAllWorkers();
        if (failover.booleanValue() && !CollectionUtils.isEmpty(this.getAliveCheckWorkerSet())) {
            allWorkers = new ArrayList<String>(this.getAliveCheckWorkerSet());
            allWorkers.removeAll(this.invalidWorkerSet);
        }
        if (this.router != null) {
            worker = this.router.route(this.jobInstanceInfo.getAppGroupId(), this.jobInstanceInfo.getJobId(), allWorkers, this.jobInstanceInfo.getTargetWorkerAddrsMap(), this.getSerialNum(), this.getLocalWorkerIdAddr());
        } else {
            boolean doNext;
            int size2 = allWorkers.size();
            if (size2 == 0) {
                return null;
            }
            int count2 = 0;
            do {
                doNext = false;
                if (this.index >= size2) {
                    this.index %= size2;
                }
                worker = allWorkers.get(this.index++);
                if (this.xAttrs != null && allWorkers.size() > 1 && !this.xAttrs.isExecOnMaster() && worker.equals(this.getLocalWorkerIdAddr())) {
                    doNext = true;
                }
                if (!this.invalidWorkerSet.contains(worker)) continue;
                LOGGER.warn("Failover={}, Worker={} is invalid skip. Invalid worker set={}, All workers={}", failover, worker, this.invalidWorkerSet, allWorkers);
                doNext = true;
            } while (doNext && ++count2 < size2);
        }
        return worker;
    }

    @Override
    public void killInstance(boolean mayInterruptIfRunning, String reason) {
        super.killInstance(mayInterruptIfRunning, reason);
        List<String> allWorkers = this.jobInstanceInfo.getAllWorkers();
        this.sendKillContainerRequest(mayInterruptIfRunning, allWorkers);
        this.updateNewInstanceStatus(this.getSerialNum(), this.jobInstanceInfo.getJobInstanceId(), InstanceStatus.FAILED, reason);
    }

    @Override
    public void destroyContainerPool() {
        List<String> allWorkers = this.jobInstanceInfo.getAllWorkers();
        for (String workerIdAddr : allWorkers) {
            Worker.MasterDestroyContainerPoolRequest request = Worker.MasterDestroyContainerPoolRequest.newBuilder().setJobInstanceId(this.jobInstanceInfo.getJobInstanceId()).setSerialNum(this.getSerialNum()).setJobId(this.jobInstanceInfo.getJobId()).setWorkerIdAddr(workerIdAddr).build();
            SchedulerxWorker.AtLeastDeliveryRoutingActor.tell(request, null);
        }
    }

    @Override
    public void killTask(String uniqueId, String workerId, String workerAddr) {
        String workerIdAddr = workerId + "@" + workerAddr;
        try {
            ActorSelection selection = this.getActorContext().actorSelection(ActorPathUtil.getContainerRouterPath(workerIdAddr));
            Worker.MasterKillContainerRequest request = Worker.MasterKillContainerRequest.newBuilder().setJobId(IdUtil.parse(uniqueId, IdUtil.IdType.JOB_ID)).setJobInstanceId(IdUtil.parse(uniqueId, IdUtil.IdType.JOB_INSTANCE_ID)).setTaskId(IdUtil.parse(uniqueId, IdUtil.IdType.TASK_ID)).setMayInterruptIfRunning(true).setAppGroupId(this.jobInstanceInfo.getAppGroupId()).build();
            selection.tell(request, null);
        }
        catch (Throwable e) {
            LOGGER.error("send kill request exception, worker:" + workerIdAddr);
        }
    }

    @Override
    public String getJobInstanceProgress() {
        MapTaskProgress detail = new MapTaskProgress();
        detail.setTaskProgress(this.taskProgressMap.values());
        detail.setWorkerProgress(this.workerProgressMap.values());
        return JsonUtil.toJson(detail);
    }

    @Override
    public ProcessResult postFinish(long jobInstanceId) {
        ProcessResult reduceResult;
        block13: {
            reduceResult = null;
            try {
                JobContext context = JobContext.newBuilder().setJobId(this.jobInstanceInfo.getJobId()).setJobInstanceId(jobInstanceId).setJobType(this.jobInstanceInfo.getJobType()).setContent(this.jobInstanceInfo.getContent()).setScheduleTime(this.jobInstanceInfo.getScheduleTime()).setDataTime(this.jobInstanceInfo.getDataTime()).setJobParameters(this.jobInstanceInfo.getParameters()).setInstanceParameters(this.jobInstanceInfo.getInstanceParameters()).setUser(this.jobInstanceInfo.getUser()).setTaskResults(this.taskResultMap).setTaskStatuses(this.taskStatusMap).setSerialNum(this.getSerialNum()).build();
                JobProcessor jobProcessor = JobProcessorUtil.getJavaProcessor(context.getContent());
                if (this.needReduce) {
                    if (jobProcessor instanceof MapReduceJobProcessor) {
                        boolean runReduceIfFail = ((MapReduceJobProcessor)jobProcessor).runReduceIfFail(context);
                        if (this.getInstanceStatus().equals(InstanceStatus.FAILED) && !runReduceIfFail) {
                            LOGGER.warn("jobInstanceId={} is failed, skip reduce", jobInstanceId);
                            return null;
                        }
                    } else {
                        reduceResult = new ProcessResult(false);
                        reduceResult.setResult(String.format("JobProcessor[%s] can not cast to com.alibaba.schedulerx.worker.processor.MapReduceJobProcessor, you can make CGLIB enabled (e.g. @EnableAspectJAutoProxy(proxyTargetClass = true)) to support reduce operations if spring aop is used.", jobProcessor.getClass().getName()));
                        return reduceResult;
                    }
                    String reduceTaskName = "REDUCE_TASK";
                    if (!this.taskProgressMap.containsKey(reduceTaskName)) {
                        TaskProgressCounter taskProgressCounter = new TaskProgressCounter(reduceTaskName);
                        this.taskProgressMap.put(reduceTaskName, taskProgressCounter);
                    }
                    this.taskProgressMap.get(reduceTaskName).incrementTotal();
                    this.taskProgressMap.get(reduceTaskName).incrementRunning();
                    String workerAddr = this.getActorContext().provider().getDefaultAddress().host().get() + ":" + this.getActorContext().provider().getDefaultAddress().port().get();
                    if (!this.workerProgressMap.containsKey(workerAddr)) {
                        WorkerProgressCounter workerProgressCounter = new WorkerProgressCounter(workerAddr);
                        this.workerProgressMap.put(workerAddr, workerProgressCounter);
                    }
                    this.workerProgressMap.get(workerAddr).incrementTotal();
                    this.workerProgressMap.get(workerAddr).incrementRunning();
                    try {
                        reduceResult = ((MapReduceJobProcessor)jobProcessor).reduce(context);
                    }
                    catch (Exception e) {
                        LOGGER.error("do reduce process failed.", e);
                        reduceResult = new ProcessResult(false);
                        reduceResult.setResult("reduce exception: " + ExceptionUtil.getMessage(e));
                    }
                    if (reduceResult.getStatus().equals(InstanceStatus.SUCCESS)) {
                        this.taskProgressMap.get(reduceTaskName).incrementSuccess();
                        this.workerProgressMap.get(workerAddr).incrementSuccess();
                    } else {
                        this.taskProgressMap.get(reduceTaskName).incrementFailed();
                        this.workerProgressMap.get(workerAddr).incrementFailed();
                    }
                    break block13;
                }
                if (jobProcessor instanceof JobProcessorEx) {
                    ((JobProcessorEx)jobProcessor).postProcess(context);
                }
            }
            catch (Throwable e) {
                LOGGER.error("Map task postFinish failed.", e);
            }
        }
        return reduceResult;
    }

    @Override
    public void stop() {
        if (this.taskDispatchReqHandler != null) {
            this.taskDispatchReqHandler.stop();
        }
        if (this.taskStatusReqBatchHandler != null) {
            this.taskStatusReqBatchHandler.stop();
        }
        LOGGER.info("jobInstanceId:{}, instance master successfully stop.", this.jobInstanceInfo.getJobInstanceId());
    }

    @Override
    protected void doTerminate() {
        if (this.taskDispatchReqHandler != null) {
            this.taskDispatchReqHandler.stop();
        }
    }

    protected void startBatchHandler() {
        if (this.INITED) {
            return;
        }
        this.taskStatusReqQueue.init();
        this.taskStatusReqBatchHandler.start();
        this.taskBlockingQueue.setCapacity(this.queueSize);
        this.taskBlockingQueue.init();
        if (this.xAttrs.getTaskDispatchMode().equals(TaskDispatchMode.PUSH.getValue())) {
            if (this.isWorkerLoadRouter()) {
                this.taskDispatchReqHandler.start();
            } else {
                this.taskDispatchReqHandler.setWorkThreadNum(this.dispatcherSize);
                this.taskDispatchReqHandler.setDispatchSize(this.pageSize * this.jobInstanceInfo.getAllWorkers().size());
                this.taskDispatchReqHandler.start();
            }
        }
    }

    private int getTotalPulledAndRunning() {
        int total = 0;
        ArrayList<TaskProgressCounter> taskCounters = Lists.newArrayList(this.taskProgressMap.values());
        for (TaskProgressCounter taskProgressCounter : taskCounters) {
            total += taskProgressCounter.getPulled();
            total += taskProgressCounter.getRunning();
        }
        return total;
    }

    private boolean machineOverload() {
        boolean memOverload = false;
        boolean loadOverload = false;
        boolean taskQueueOverload = false;
        Metrics vmDetail = MetricsCollector.getMetrics();
        if (vmDetail != null) {
            memOverload = vmDetail.getHeap1Usage() >= (double)0.9f;
            loadOverload = vmDetail.getCpuLoad1() >= (double)vmDetail.getCpuProcessors();
        }
        return memOverload || loadOverload || taskQueueOverload;
    }

    public String getRootTaskResult() {
        return this.rootTaskResult;
    }

    public void setRootTaskResult(String rootTaskResult) {
        this.rootTaskResult = rootTaskResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTaskProgress(String taskName, int delta) {
        if (!this.taskProgressMap.containsKey(taskName)) {
            MapTaskMaster mapTaskMaster = this;
            synchronized (mapTaskMaster) {
                if (!this.taskProgressMap.containsKey(taskName)) {
                    TaskProgressCounter taskProgressCounter = new TaskProgressCounter(taskName);
                    this.taskProgressMap.put(taskName, taskProgressCounter);
                }
            }
        }
        this.taskProgressMap.get(taskName).incrementTotal(delta);
    }

    @Override
    public void clear() {
        super.clear();
        if (this.taskStatusReqQueue != null) {
            this.taskStatusReqQueue.clear();
        }
        if (this.taskBlockingQueue != null) {
            this.taskBlockingQueue.clear();
        }
        if (this.taskDispatchReqHandler != null) {
            this.taskDispatchReqHandler.clear();
        }
        if (this.taskStatusReqBatchHandler != null) {
            this.taskStatusReqBatchHandler.clear();
        }
        if (this.taskProgressMap != null) {
            this.taskProgressMap.clear();
        }
        if (this.workerProgressMap != null) {
            this.workerProgressMap.clear();
        }
        if (this.taskResultMap != null) {
            this.taskResultMap.clear();
        }
        if (this.taskStatusMap != null) {
            this.taskStatusMap.clear();
        }
        this.clearTasks(this.jobInstanceInfo.getJobInstanceId());
        this.taskCounter.set(0);
        this.setStartStatusCheck(false);
    }

    public Map<String, TaskProgressCounter> getTaskProgressMap() {
        return this.taskProgressMap;
    }

    public synchronized List<Worker.MasterStartContainerRequest> syncPullTasks(long serialNum, int pageSize, String workerIdAddr) {
        if (this.getTotalPulledAndRunning() >= this.xAttrs.getGlobalConsumerSize()) {
            return Lists.newArrayList();
        }
        if (this.getSerialNum() == serialNum) {
            return this.taskDispatchReqHandler.syncHandleReqs(pageSize, workerIdAddr);
        }
        return Lists.newArrayList();
    }

    @Override
    protected void checkProcessor() throws Exception {
        if ("java".equalsIgnoreCase(this.jobInstanceInfo.getJobType())) {
            JavaProcessorProfile profile = JsonUtil.fromJson(this.jobInstanceInfo.getContent(), JavaProcessorProfile.class);
            if (!JobProcessorUtil.checkJavaProcessor(profile.getClassName(), MapJobProcessor.class).booleanValue()) {
                throw new IOException(profile.getClassName() + " must extends MapJobProcessor or MapReduceJobProcessor");
            }
            if (JobProcessorUtil.checkJavaProcessor(profile.getClassName(), MapReduceJobProcessor.class).booleanValue()) {
                this.needReduce = true;
            }
        }
    }

    @Override
    public synchronized void handleWorkerShutdown(String workerIdAddr, boolean withFailover) {
        this.existInvalidWorker = true;
        this.invalidWorkerSet.add(workerIdAddr);
        if (!this.aliveCheckWorkerSet.contains(workerIdAddr)) {
            return;
        }
        String[] workerInfo = workerIdAddr.split("@");
        String workerAddr = workerInfo[1];
        String workerId = workerInfo[0];
        this.aliveCheckWorkerSet.remove(workerIdAddr);
        this.jobInstanceInfo.getAllWorkers().remove(workerIdAddr);
        this.taskDispatchReqHandler.setDispatchSize(this.aliveCheckWorkerSet.size() * this.pageSize);
        if (withFailover && this.xAttrs != null && this.xAttrs.isFailover()) {
            int affectCnt = this.taskPersistence.batchUpdateTaskStatus(this.jobInstanceInfo.getJobInstanceId(), TaskStatus.INIT, workerId, workerAddr);
            LOGGER.warn("jobInstanceId={}, failover task number:{}, workerId:{}, workerAddr:{}", this.jobInstanceInfo.getJobInstanceId(), affectCnt, workerId, workerAddr);
            if (affectCnt > 0) {
                this.workerProgressMap.get(workerAddr).decRunningAndTotal(affectCnt);
            }
        } else {
            int affectCnt = this.taskPersistence.batchUpdateTaskStatus(this.jobInstanceInfo.getJobInstanceId(), TaskStatus.FAILED, workerId, workerAddr);
            LOGGER.warn("jobInstanceId={}, worker shutdown, failed task number:{}, workerId:{}, workerAddr:{}", this.jobInstanceInfo.getJobInstanceId(), affectCnt, workerId, workerAddr);
            if (affectCnt > 0) {
                this.workerProgressMap.get(workerAddr).incrementFailed(affectCnt);
            }
        }
    }

    public boolean isStartStatusCheck() {
        return this.startStatusCheck;
    }

    public void setStartStatusCheck(boolean startStatusCheck) {
        this.startStatusCheck = startStatusCheck;
    }

    protected boolean isWorkerLoadRouter() {
        Integer routerStrategy = ConfigUtil.getWorkerConfig().getInteger("map.master.router.strategy", null);
        boolean enableShareContainerPool = WorkerConfigUtil.isEnableShareContainerPool();
        return enableShareContainerPool && (this.xAttrs != null && RouteStrategyEnum.WORKER_LOAD.getValue().equals(this.xAttrs.getRouteType()) || RouteStrategyEnum.WORKER_LOAD.getValue().equals(routerStrategy));
    }

    protected Long parseDispatchSpeed() {
        String dispatchSpeed = this.xAttrs.getDispatchSpeed();
        Long dispatchDelay = null;
        if (StringUtils.isNotEmpty(dispatchSpeed)) {
            Integer speed = null;
            TimeUnit timeUnit = TimeUnit.MILLISECONDS;
            if (NumberUtils.isNumber(dispatchSpeed)) {
                speed = NumberUtils.toInt(dispatchSpeed);
            } else {
                String[] arr = dispatchSpeed.split("/");
                if (arr != null && arr.length == 2) {
                    if (NumberUtils.isNumber(arr[0])) {
                        speed = NumberUtils.toInt(arr[0]);
                    }
                    if (StringUtils.isNotEmpty(arr[1])) {
                        switch (StringUtils.upperCase(arr[1])) {
                            case "S": {
                                timeUnit = TimeUnit.SECONDS;
                                break;
                            }
                            case "M": {
                                timeUnit = TimeUnit.MINUTES;
                                break;
                            }
                            case "H": {
                                timeUnit = TimeUnit.HOURS;
                            }
                        }
                    }
                }
            }
            if (speed != null && speed > 0) {
                dispatchDelay = TimeUnit.MILLISECONDS.convert(1L, timeUnit) / (long)speed.intValue();
            }
        }
        return dispatchDelay;
    }
}

