/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.master;

import akka.actor.ActorContext;
import com.alibaba.schedulerx.common.domain.JobInstanceInfo;
import com.alibaba.schedulerx.common.domain.MapTaskXAttrs;
import com.alibaba.schedulerx.common.domain.TaskDispatchMode;
import com.alibaba.schedulerx.common.domain.TaskProgressCounter;
import com.alibaba.schedulerx.common.domain.TaskStatus;
import com.alibaba.schedulerx.common.domain.WorkerProgressCounter;
import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.common.util.IdUtil;
import com.alibaba.schedulerx.common.util.JsonUtil;
import com.alibaba.schedulerx.protocol.Server;
import com.alibaba.schedulerx.protocol.Worker;
import com.alibaba.schedulerx.protocol.utils.FutureUtils;
import com.alibaba.schedulerx.shade.com.google.common.collect.Lists;
import com.alibaba.schedulerx.shade.com.google.protobuf.ByteString;
import com.alibaba.schedulerx.shade.org.apache.commons.collections.CollectionUtils;
import com.alibaba.schedulerx.worker.batch.ReqQueue;
import com.alibaba.schedulerx.worker.batch.TMStatusReqHandler;
import com.alibaba.schedulerx.worker.batch.TaskPushReqHandler;
import com.alibaba.schedulerx.worker.discovery.GroupManager;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.logcollector.ClientLoggerMessage;
import com.alibaba.schedulerx.worker.logcollector.LogCollector;
import com.alibaba.schedulerx.worker.logcollector.LogCollectorFactory;
import com.alibaba.schedulerx.worker.master.MapTaskMaster;
import com.alibaba.schedulerx.worker.master.persistence.ServerTaskPersistence;
import com.alibaba.schedulerx.worker.pull.TaskPullReqHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class ParallelTaskMater
extends MapTaskMaster {
    private static final Logger LOGGER = LogFactory.getLogger(ParallelTaskMater.class);
    private LogCollector logCollector = LogCollectorFactory.get();
    private static final Integer BATCH_SIZE = 256;

    public ParallelTaskMater(JobInstanceInfo jobInstanceInfo, ActorContext actorContext) throws Exception {
        super(jobInstanceInfo, actorContext);
        this.taskPersistence = new ServerTaskPersistence(jobInstanceInfo.getGroupId());
        long jobInstanceId = jobInstanceInfo.getJobInstanceId();
        this.taskStatusReqQueue = new ReqQueue(jobInstanceId, 1024);
        this.taskStatusReqBatchHandler = new TMStatusReqHandler(jobInstanceId, 1, 1, BATCH_SIZE * 2 * jobInstanceInfo.getAllWorkers().size(), this.taskStatusReqQueue);
        this.taskBlockingQueue = new ReqQueue(jobInstanceId, BATCH_SIZE * 4);
        if (jobInstanceInfo.getXattrs() != null) {
            this.xAttrs = JsonUtil.fromJson(jobInstanceInfo.getXattrs(), MapTaskXAttrs.class);
        }
        if (this.xAttrs != null && this.xAttrs.getTaskDispatchMode().equals(TaskDispatchMode.PULL.getValue())) {
            this.taskDispatchReqHandler = new TaskPullReqHandler(jobInstanceId, 1, 2, BATCH_SIZE * jobInstanceInfo.getAllWorkers().size(), this.taskBlockingQueue);
        } else {
            Long dispatchDelay;
            int batchSize = BATCH_SIZE * jobInstanceInfo.getAllWorkers().size();
            if (this.isWorkerLoadRouter()) {
                batchSize = 2 * jobInstanceInfo.getAllWorkers().size();
            }
            if ((dispatchDelay = this.parseDispatchSpeed()) != null) {
                batchSize = 1;
            }
            this.taskDispatchReqHandler = new TaskPushReqHandler(jobInstanceId, 1, 2, batchSize, this.taskBlockingQueue, BATCH_SIZE, dispatchDelay);
        }
    }

    @Override
    public boolean map(List<ByteString> taskList, String taskName) throws Exception {
        String uniqueId = IdUtil.getUniqueIdWithoutTask(this.jobInstanceInfo.getJobId(), this.jobInstanceInfo.getJobInstanceId());
        if (CollectionUtils.isEmpty(taskList)) {
            LOGGER.warn("map taskList is empty, taskName:{}", taskName);
            this.logCollector.collect(this.jobInstanceInfo.getAppGroupId(), uniqueId, ClientLoggerMessage.appendMessage("map task init fail:", "map taskList is empty"));
            return false;
        }
        LOGGER.info("map taskList, jobInstanceId={}, taskName={}, taskList size={}", this.jobInstanceInfo.getJobInstanceId(), taskName, taskList.size());
        int counter = this.taskCounter.addAndGet(taskList.size());
        int defaultTaskMaxSize = GroupManager.INSTANCE.isAdvancedVersion(this.jobInstanceInfo.getGroupId()) ? 1000 : 300;
        int parallelTaskMaxSize = ConfigUtil.getWorkerConfig().getInt("schedulerx.worker.parallel.task.maxSize", defaultTaskMaxSize);
        if (counter > parallelTaskMaxSize) {
            LOGGER.error("jobInstanceId={}, task counter={}, beyond {} !", this.jobInstanceInfo.getJobInstanceId(), counter, parallelTaskMaxSize);
            this.logCollector.collect(this.jobInstanceInfo.getAppGroupId(), uniqueId, ClientLoggerMessage.appendMessage("map task init fail:", "task list size beyond " + parallelTaskMaxSize));
            throw new IOException("task list size beyond " + parallelTaskMaxSize + " !");
        }
        return super.map(taskList, taskName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retryTasks(List<Server.RetryTaskEntity> taskEntities) {
        block18: {
            ArrayList<Long> taskIdList = Lists.newArrayList();
            for (Server.RetryTaskEntity taskEntity : taskEntities) {
                if (taskEntity.getTaskName().equals("MAP_TASK_ROOT")) {
                    LOGGER.warn("root task can't retry");
                    continue;
                }
                taskIdList.add(taskEntity.getTaskId());
            }
            this.taskIdGenerator = new AtomicLong(System.currentTimeMillis() / 1000L);
            Worker.WorkerReportTaskListStatusRequest request = Worker.WorkerReportTaskListStatusRequest.newBuilder().setJobInstanceId(this.jobInstanceInfo.getJobInstanceId()).addAllTaskId(taskIdList).setStatus(TaskStatus.INIT.getValue()).build();
            try {
                Worker.WorkerReportTaskListStatusResponse response = (Worker.WorkerReportTaskListStatusResponse)FutureUtils.awaitResult(this.SERVER_DISCOVERY.getMapMasterRouter(), (Object)request, 30L);
                if (response.getSuccess()) {
                    if (!this.INITED) {
                        this.startBatchHandler();
                        this.init();
                        for (Server.RetryTaskEntity taskEntity : taskEntities) {
                            String taskName = taskEntity.getTaskName();
                            if (!this.taskProgressMap.containsKey(taskName)) {
                                ParallelTaskMater parallelTaskMater = this;
                                synchronized (parallelTaskMater) {
                                    if (!this.taskProgressMap.containsKey(taskName)) {
                                        TaskProgressCounter taskProgressCounter = new TaskProgressCounter(taskName);
                                        this.taskProgressMap.put(taskName, taskProgressCounter);
                                    }
                                }
                            }
                            ((TaskProgressCounter)this.taskProgressMap.get(taskName)).incrementTotal();
                        }
                        break block18;
                    }
                    for (Server.RetryTaskEntity taskEntity : taskEntities) {
                        String taskName = taskEntity.getTaskName();
                        String workerAddr = taskEntity.getWorkerAddr();
                        int oldStatus = taskEntity.getOldStatus();
                        if (this.taskProgressMap.containsKey(taskName)) {
                            TaskProgressCounter taskProgressCounter = (TaskProgressCounter)this.taskProgressMap.get(taskName);
                            if (oldStatus == TaskStatus.SUCCESS.getValue()) {
                                taskProgressCounter.decrementSuccess();
                            } else if (oldStatus == TaskStatus.FAILED.getValue()) {
                                taskProgressCounter.decrementFailed();
                            }
                        }
                        if (!this.workerProgressMap.containsKey(workerAddr)) continue;
                        WorkerProgressCounter workerProgressCounter = (WorkerProgressCounter)this.workerProgressMap.get(workerAddr);
                        if (oldStatus == TaskStatus.SUCCESS.getValue()) {
                            workerProgressCounter.decrementSuccess();
                            continue;
                        }
                        if (oldStatus != TaskStatus.FAILED.getValue()) continue;
                        workerProgressCounter.decrementFailed();
                    }
                    break block18;
                }
                LOGGER.error("", response.getMessage());
            }
            catch (Throwable e) {
                LOGGER.error("", e);
            }
        }
    }
}

