/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.master;

import akka.actor.ActorContext;
import akka.actor.ActorSelection;
import akka.pattern.Patterns;
import akka.util.Timeout;
import com.alibaba.schedulerx.common.domain.InstanceStatus;
import com.alibaba.schedulerx.common.domain.JobInstanceData;
import com.alibaba.schedulerx.common.domain.JobInstanceInfo;
import com.alibaba.schedulerx.common.domain.MapTaskXAttrs;
import com.alibaba.schedulerx.common.domain.Pair;
import com.alibaba.schedulerx.common.domain.TaskStatus;
import com.alibaba.schedulerx.common.util.IdUtil;
import com.alibaba.schedulerx.common.util.JsonUtil;
import com.alibaba.schedulerx.common.util.StringUtils;
import com.alibaba.schedulerx.protocol.Common;
import com.alibaba.schedulerx.protocol.Server;
import com.alibaba.schedulerx.protocol.Worker;
import com.alibaba.schedulerx.shade.com.google.common.collect.Lists;
import com.alibaba.schedulerx.shade.com.google.common.collect.Maps;
import com.alibaba.schedulerx.shade.com.google.common.collect.Sets;
import com.alibaba.schedulerx.shade.com.google.protobuf.ByteString;
import com.alibaba.schedulerx.shade.org.apache.commons.collections.CollectionUtils;
import com.alibaba.schedulerx.shade.scala.concurrent.Await;
import com.alibaba.schedulerx.shade.scala.concurrent.Awaitable;
import com.alibaba.schedulerx.shade.scala.concurrent.Future;
import com.alibaba.schedulerx.shade.scala.concurrent.duration.Duration;
import com.alibaba.schedulerx.worker.container.ShutdownMode;
import com.alibaba.schedulerx.worker.discovery.ServerDiscovery;
import com.alibaba.schedulerx.worker.discovery.ServerDiscoveryFactory;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.master.TaskMasterPool;
import com.alibaba.schedulerx.worker.master.handler.UpdateInstanceStatusHandler;
import com.alibaba.schedulerx.worker.master.handler.UpdateInstanceStatusHandlerFactory;
import com.alibaba.schedulerx.worker.master.scheduler.TimeScheduler;
import com.alibaba.schedulerx.worker.processor.ProcessResult;
import com.alibaba.schedulerx.worker.util.ActorPathUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public abstract class TaskMaster {
    private final ActorContext actorContext;
    protected volatile InstanceStatus instanceStatus = InstanceStatus.RUNNING;
    protected volatile Map<String, TaskStatus> taskStatusMap = Maps.newHashMap();
    protected AtomicLong taskIdGenerator = new AtomicLong(0L);
    private final String localWorkIdAddr;
    private final String localContainerRouterPath;
    private final String localTaskRouterPath;
    private final String localInstanceRouterPath;
    protected final JobInstanceInfo jobInstanceInfo;
    protected String jobInstanceProgress;
    protected final UpdateInstanceStatusHandler statusHandler;
    protected volatile boolean killed = false;
    protected volatile boolean INITED = false;
    protected volatile Set<String> aliveCheckWorkerSet = Sets.newConcurrentHashSet();
    protected volatile Set<String> invalidWorkerSet = Sets.newConcurrentHashSet();
    protected final ServerDiscovery SERVER_DISCOVERY;
    protected AtomicLong serialNum = new AtomicLong(0L);
    private static final Logger LOGGER = LogFactory.getLogger(TaskMaster.class);
    protected final CountDownLatch latch = new CountDownLatch(1);
    protected volatile boolean existInvalidWorker = false;

    public TaskMaster(JobInstanceInfo jobInstanceInfo, ActorContext actorContext) throws Exception {
        this.jobInstanceInfo = jobInstanceInfo;
        this.actorContext = actorContext;
        this.localWorkIdAddr = actorContext.provider().getDefaultAddress().hostPort();
        this.localInstanceRouterPath = actorContext.provider().getDefaultAddress().toString() + "/user/job_instance_routing";
        this.localContainerRouterPath = actorContext.provider().getDefaultAddress().toString() + "/user/container_routing";
        this.localTaskRouterPath = actorContext.provider().getDefaultAddress().toString() + "/user/task_routing";
        this.SERVER_DISCOVERY = ServerDiscoveryFactory.getDiscovery(jobInstanceInfo.getGroupId());
        this.checkProcessor();
        this.statusHandler = UpdateInstanceStatusHandlerFactory.create(this, jobInstanceInfo);
    }

    public ActorContext getActorContext() {
        return this.actorContext;
    }

    public String getLocalWorkerIdAddr() {
        return this.localWorkIdAddr;
    }

    public String getLocalJobInstanceRouterPath() {
        return this.localInstanceRouterPath;
    }

    public String getLocalContainerRouterPath() {
        return this.localContainerRouterPath;
    }

    public String getLocalTaskRouterPath() {
        return this.localTaskRouterPath;
    }

    public boolean isJobInstanceFinished() {
        boolean isFinish = true;
        for (TaskStatus status : this.taskStatusMap.values()) {
            if (status.isFinish()) continue;
            isFinish = false;
            break;
        }
        return isFinish;
    }

    public void updateTaskStatus(Worker.ContainerReportTaskStatusRequest request) {
        long jobId = request.getJobId();
        long jobInstanceId = request.getJobInstanceId();
        long taskId = request.getTaskId();
        TaskStatus taskStatus = TaskStatus.parseValue(request.getStatus());
        String uniqueId = IdUtil.getUniqueId(jobId, jobInstanceId, taskId);
        this.taskStatusMap.put(uniqueId, taskStatus);
        InstanceStatus newStatus = InstanceStatus.UNKNOWN;
        if (this.taskStatusMap.size() > 0) {
            if (!this.isJobInstanceFinished()) {
                newStatus = InstanceStatus.RUNNING;
            } else {
                newStatus = InstanceStatus.SUCCESS;
                if (!newStatus.equals(InstanceStatus.FAILED)) {
                    for (TaskStatus status : this.taskStatusMap.values()) {
                        if (!status.equals(TaskStatus.FAILED)) continue;
                        newStatus = InstanceStatus.FAILED;
                        break;
                    }
                }
            }
        }
        this.jobInstanceInfo.setTraceId(request.getTraceId());
        this.jobInstanceProgress = request.getProgress();
        this.updateNewInstanceStatus(request.getSerialNum(), jobInstanceId, newStatus, request.getResult());
    }

    public void batchUpdateTaskStatus(Worker.ContainerBatchReportTaskStatuesRequest request) throws Exception {
        for (Worker.TaskStatusInfo taskStatusInfo : request.getTaskStatuesList()) {
            Worker.ContainerReportTaskStatusRequest.Builder builder = Worker.ContainerReportTaskStatusRequest.newBuilder().setJobId(request.getJobId()).setJobInstanceId(request.getJobInstanceId()).setTaskId(taskStatusInfo.getTaskId()).setWorkerAddr(request.getWorkerAddr()).setWorkerId(request.getWorkerId()).setStatus(taskStatusInfo.getStatus());
            if (taskStatusInfo.hasResult()) {
                builder.setResult(taskStatusInfo.getResult());
            }
            if (taskStatusInfo.hasTaskName()) {
                builder.setTaskName(taskStatusInfo.getTaskName());
            }
            if (taskStatusInfo.hasProgress()) {
                builder.setProgress(taskStatusInfo.getProgress());
            }
            if (request.hasSerialNum()) {
                builder.setSerialNum(request.getSerialNum());
            }
            if (taskStatusInfo.hasTraceId()) {
                builder.setTraceId(taskStatusInfo.getTraceId());
            }
            this.updateTaskStatus(builder.build());
        }
    }

    public void batchUpdateTaskStatues(List<Worker.ContainerReportTaskStatusRequest> requests) {
    }

    public void killInstance(boolean mayInterruptIfRunning, String reason) {
        this.killed = true;
        TimeScheduler.INSTANCE.remove(this.jobInstanceInfo.getJobInstanceId());
    }

    protected void sendKillContainerRequest(boolean mayInterruptIfRunning, List<String> allWorkers) {
        String uniqueId = IdUtil.getUniqueIdWithoutTask(this.jobInstanceInfo.getJobId(), this.jobInstanceInfo.getJobInstanceId());
        HashSet<Pair<String, Future<Object>>> futures = Sets.newHashSet();
        Timeout timeout = new Timeout(Duration.create(5L, TimeUnit.SECONDS));
        for (String string2 : allWorkers) {
            try {
                ActorSelection selection = this.getActorContext().actorSelection(ActorPathUtil.getContainerRouterPath(string2));
                Worker.MasterKillContainerRequest request = Worker.MasterKillContainerRequest.newBuilder().setJobId(this.jobInstanceInfo.getJobId()).setJobInstanceId(this.jobInstanceInfo.getJobInstanceId()).setMayInterruptIfRunning(mayInterruptIfRunning).setAppGroupId(this.jobInstanceInfo.getAppGroupId()).build();
                if (mayInterruptIfRunning) {
                    selection.tell(request, null);
                    continue;
                }
                Future<Object> future2 = Patterns.ask(selection, (Object)request, timeout);
                futures.add(new Pair<String, Future<Object>>(string2, future2));
            }
            catch (Throwable e) {
                LOGGER.warn("send kill instance request exception, worker:{}, uninqueId:{}", string2, uniqueId);
            }
        }
        for (Pair pair : futures) {
            try {
                Await.result((Awaitable)pair.getSecond(), timeout.duration());
            }
            catch (Exception e) {
                LOGGER.warn("send kill instance request timeout, worker:{}, uninqueId:{}", pair.getFirst(), uniqueId);
            }
        }
    }

    public abstract void destroyContainerPool();

    public void killTask(String uniqueId, String workerId, String workerAddr) {
    }

    protected void init() {
        if (this.INITED) {
            return;
        }
        this.INITED = true;
    }

    public void retryTasks(List<Server.RetryTaskEntity> taskEntities) {
    }

    public abstract void submitInstance(JobInstanceInfo var1) throws Exception;

    protected long aquireTaskId() {
        return this.taskIdGenerator.getAndIncrement();
    }

    public String getJobInstanceProgress() {
        return this.jobInstanceProgress;
    }

    public void updateNewInstanceStatus(long serialNum, InstanceStatus newStatus, String result2) {
        this.updateNewInstanceStatus(serialNum, this.jobInstanceInfo.getJobInstanceId(), newStatus, result2);
    }

    protected synchronized void updateNewInstanceStatus(long serialNum, long jobInstanceId, InstanceStatus newStatus, String result2) {
        try {
            this.statusHandler.handle(serialNum, newStatus, result2);
        }
        catch (Exception e) {
            LOGGER.error("update jobInstanceId={} serialNum={}, status={} failed", jobInstanceId, serialNum, newStatus.getValue(), e);
        }
    }

    public void stop() {
    }

    public void clear() {
        this.taskStatusMap.clear();
        this.taskIdGenerator.set(0L);
        this.instanceStatus = InstanceStatus.RUNNING;
        this.aliveCheckWorkerSet.clear();
        this.invalidWorkerSet.clear();
        this.destroyContainerPool();
    }

    public ProcessResult postFinish(long jobInstanceId) {
        return null;
    }

    protected Worker.MasterStartContainerRequest.Builder convert2StartContainerRequestBuilder(JobInstanceInfo jobInstanceInfo, long taskId) {
        return this.convert2StartContainerRequestBuilder(jobInstanceInfo, taskId, null, null, false);
    }

    protected Worker.MasterStartContainerRequest convert2StartContainerRequest(JobInstanceInfo jobInstanceInfo, long taskId, String taskName, ByteString taskBody) {
        Worker.MasterStartContainerRequest.Builder builder = this.convert2StartContainerRequestBuilder(jobInstanceInfo, taskId, taskName, taskBody, false);
        return builder.build();
    }

    protected Worker.MasterStartContainerRequest.Builder convert2StartContainerRequestBuilder(JobInstanceInfo jobInstanceInfo, long taskId, String taskName, ByteString taskBody, boolean failover) {
        Worker.MasterStartContainerRequest.Builder builder = Worker.MasterStartContainerRequest.newBuilder();
        builder.setJobId(jobInstanceInfo.getJobId());
        builder.setJobInstanceId(jobInstanceInfo.getJobInstanceId());
        builder.setTaskId(taskId);
        builder.setAppGroupId(jobInstanceInfo.getAppGroupId());
        builder.setUser(jobInstanceInfo.getUser());
        builder.setJobType(jobInstanceInfo.getJobType());
        builder.setContent(jobInstanceInfo.getContent());
        builder.setScheduleTime(jobInstanceInfo.getScheduleTime().getMillis());
        builder.setDataTime(jobInstanceInfo.getDataTime().getMillis());
        builder.setParameters(jobInstanceInfo.getParameters());
        builder.setInstanceParameters(jobInstanceInfo.getInstanceParameters());
        builder.setInstanceMasterAkkaPath(this.getLocalTaskRouterPath());
        builder.setGroupId(jobInstanceInfo.getGroupId());
        builder.setMaxAttempt(jobInstanceInfo.getMaxAttempt());
        builder.setAttempt(jobInstanceInfo.getAttempt());
        builder.setTriggerType(jobInstanceInfo.getTriggerType());
        if (jobInstanceInfo.getUpstreamData() != null && !jobInstanceInfo.getUpstreamData().isEmpty()) {
            for (JobInstanceData jobInstanceData : jobInstanceInfo.getUpstreamData()) {
                Common.UpstreamData upstreamData = Common.UpstreamData.newBuilder().setJobName(jobInstanceData.getJobName()).setData(jobInstanceData.getData()).build();
                builder.addUpstreamData(upstreamData);
            }
        }
        if (StringUtils.isNotEmpty(jobInstanceInfo.getXattrs())) {
            builder.setXattrs(jobInstanceInfo.getXattrs());
            MapTaskXAttrs xAttrs = JsonUtil.fromJson(jobInstanceInfo.getXattrs(), MapTaskXAttrs.class);
            builder.setConsumerNum(xAttrs.getConsumerSize());
            builder.setTaskMaxAttempt(xAttrs.getTaskMaxAttempt());
            builder.setTaskAttemptInterval(xAttrs.getTaskAttemptInterval());
        }
        if (taskName != null) {
            builder.setTaskName(taskName);
        }
        if (taskBody != null) {
            builder.setTask(taskBody);
        }
        if (failover) {
            builder.setFailover(true);
        }
        if (jobInstanceInfo.getWfInstanceId() != null) {
            builder.setWfInstanceId(jobInstanceInfo.getWfInstanceId());
        }
        builder.setSerialNum(this.getSerialNum());
        builder.setExecuteMode(jobInstanceInfo.getExecuteMode());
        if (jobInstanceInfo.getJobName() != null) {
            builder.setJobName(jobInstanceInfo.getJobName());
        }
        builder.setTimeType(jobInstanceInfo.getTimeType());
        builder.setTimeExpression(jobInstanceInfo.getTimeExpression());
        if (StringUtils.isNotEmpty(jobInstanceInfo.getNamespace())) {
            builder.setNamespace(jobInstanceInfo.getNamespace());
        }
        if (StringUtils.isNotEmpty(jobInstanceInfo.getTemplate())) {
            builder.setTemplate(jobInstanceInfo.getTemplate());
        }
        if (jobInstanceInfo.getWorkflowId() != null) {
            builder.setWorkflowId(jobInstanceInfo.getWorkflowId());
        }
        return builder;
    }

    public InstanceStatus getInstanceStatus() {
        return this.instanceStatus;
    }

    public void setInstanceStatus(InstanceStatus instanceStatus) {
        this.instanceStatus = instanceStatus;
    }

    public boolean isKilled() {
        return this.killed;
    }

    public JobInstanceInfo getJobInstanceInfo() {
        return this.jobInstanceInfo;
    }

    public Set<String> getAliveCheckWorkerSet() {
        return this.aliveCheckWorkerSet;
    }

    public boolean isInited() {
        return this.INITED;
    }

    public long getSerialNum() {
        return this.serialNum.get();
    }

    public long aquireSerialNum() {
        return this.serialNum.incrementAndGet();
    }

    protected void checkProcessor() throws Exception {
    }

    public boolean existInvalidWorker() {
        return this.existInvalidWorker;
    }

    public void restJobInstanceWorkerList(Set<String> freeWorkers) {
        if (CollectionUtils.isNotEmpty(freeWorkers)) {
            this.jobInstanceInfo.setAllWorkers(Lists.newCopyOnWriteArrayList(freeWorkers));
            this.existInvalidWorker = false;
            LOGGER.info("restJobInstanceWorkerList appGroupId={} instanceId={} workerSize={}.", this.jobInstanceInfo.getAppGroupId(), this.jobInstanceInfo.getJobInstanceId(), freeWorkers.size());
        } else {
            LOGGER.warn("restJobInstanceWorkerList update appGroupId={} instanceId={} workers=0.", this.jobInstanceInfo.getAppGroupId(), this.jobInstanceInfo.getJobInstanceId());
        }
    }

    public synchronized void handleWorkerShutdown(String workerIdAddr, boolean withFailover) {
    }

    public synchronized void handleWorkerOffline(String workerIdAddr) {
        this.existInvalidWorker = true;
        this.getJobInstanceInfo().getAllWorkers().remove(workerIdAddr);
        this.invalidWorkerSet.add(workerIdAddr);
        LOGGER.info("handle worker={} offline.", workerIdAddr);
    }

    public void terminate(ShutdownMode shutdownMode) throws InterruptedException {
        if (ShutdownMode.IMMEDIATE.equals((Object)shutdownMode)) {
            this.doTerminate();
            this.killInstance(true, "Worker master shutdown.");
        } else if (ShutdownMode.WAIT_RUNNING.equals((Object)shutdownMode)) {
            this.doTerminate();
            this.killInstance(false, "Worker master shutdown.");
        }
        this.latch.await();
    }

    protected void doTerminate() {
    }

    public void latchRelease() {
        this.latch.countDown();
    }

    protected boolean isFinished() {
        return this.instanceStatus.isFinish() || !TaskMasterPool.INSTANCE.contains(this.jobInstanceInfo.getJobInstanceId());
    }
}

