/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.master.handler;

import com.alibaba.schedulerx.common.domain.InstanceStatus;
import com.alibaba.schedulerx.common.domain.JobInstanceInfo;
import com.alibaba.schedulerx.common.util.IdUtil;
import com.alibaba.schedulerx.protocol.Worker;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;
import com.alibaba.schedulerx.worker.SchedulerxWorker;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.logcollector.ClientLoggerMessage;
import com.alibaba.schedulerx.worker.logcollector.LogCollector;
import com.alibaba.schedulerx.worker.logcollector.LogCollectorFactory;
import com.alibaba.schedulerx.worker.master.StandaloneTaskMaster;
import com.alibaba.schedulerx.worker.master.TaskMaster;
import com.alibaba.schedulerx.worker.master.handler.UpdateInstanceStatusHandler;
import com.alibaba.schedulerx.worker.processor.ProcessResult;

public class CommonUpdateInstanceStatusHandler
extends UpdateInstanceStatusHandler {
    private LogCollector logCollector = LogCollectorFactory.get();
    private static final Logger LOGGER = LogFactory.getLogger(CommonUpdateInstanceStatusHandler.class);

    CommonUpdateInstanceStatusHandler(TaskMaster taskMaster, JobInstanceInfo jobInstanceInfo) {
        super(taskMaster, jobInstanceInfo);
    }

    @Override
    public void handle(long serialNum, InstanceStatus instanceStatus, String result2) throws Exception {
        Worker.WorkerReportJobInstanceStatusRequest.Builder builder;
        String uniqueId = IdUtil.getUniqueIdWithoutTask(this.jobInstanceInfo.getJobId(), this.jobInstanceInfo.getJobInstanceId());
        if (!this.taskMaster.getInstanceStatus().equals(instanceStatus)) {
            this.taskMaster.setInstanceStatus(instanceStatus);
            if (instanceStatus.isFinish()) {
                ProcessResult postResult = this.taskMaster.postFinish(this.jobInstanceInfo.getJobInstanceId());
                if (postResult != null) {
                    if (instanceStatus.equals(InstanceStatus.SUCCESS) && postResult.getStatus().equals(InstanceStatus.FAILED)) {
                        instanceStatus = InstanceStatus.FAILED;
                    }
                    if (postResult.getResult() != null && !StringUtils.contains(result2, "Worker master shutdown")) {
                        result2 = postResult.getResult();
                    }
                }
                if (!"killed from server".equals(result2)) {
                    String traceId;
                    String progress;
                    builder = Worker.WorkerReportJobInstanceStatusRequest.newBuilder().setJobId(this.jobInstanceInfo.getJobId()).setJobInstanceId(this.jobInstanceInfo.getJobInstanceId()).setStatus(instanceStatus.getValue()).setGroupId(this.jobInstanceInfo.getGroupId());
                    if (result2 != null) {
                        builder.setResult(result2);
                    }
                    if (!StringUtils.isEmpty(progress = this.taskMaster.getJobInstanceProgress())) {
                        builder.setProgress(progress);
                    }
                    if (!StringUtils.isEmpty(traceId = this.jobInstanceInfo.getTraceId())) {
                        builder.setTraceId(traceId);
                    }
                    SchedulerxWorker.AtLeastDeliveryRoutingActor.tell(builder.build(), null);
                    LOGGER.info("report jobInstance={}, status={} to AtLeastDeliveryRoutingActor", this.jobInstanceInfo.getJobInstanceId(), instanceStatus);
                }
                this.taskMaster.destroyContainerPool();
                this.masterPool.get(this.jobInstanceInfo.getJobInstanceId()).stop();
                this.masterPool.remove(this.jobInstanceInfo.getJobInstanceId());
                this.logCollector.collect(this.jobInstanceInfo.getAppGroupId(), uniqueId, ClientLoggerMessage.appendMessage("instance finished, final status is:", instanceStatus.getDescription()));
                LOGGER.info("uniqueId: {} is finished, remove from MasterPool.", uniqueId);
            }
        }
        String progress = this.taskMaster.getJobInstanceProgress();
        if (!(!(this.taskMaster instanceof StandaloneTaskMaster) || instanceStatus.isFinish() || StringUtils.isEmpty(progress) && StringUtils.isEmpty(this.jobInstanceInfo.getTraceId()))) {
            String traceId;
            builder = Worker.WorkerReportJobInstanceStatusRequest.newBuilder().setJobId(this.jobInstanceInfo.getJobId()).setJobInstanceId(this.jobInstanceInfo.getJobInstanceId()).setStatus(instanceStatus.getValue()).setGroupId(this.jobInstanceInfo.getGroupId());
            if (result2 != null) {
                builder.setResult(result2);
            }
            if (!StringUtils.isEmpty(traceId = this.jobInstanceInfo.getTraceId())) {
                builder.setTraceId(traceId);
            }
            if (!StringUtils.isEmpty(progress)) {
                builder.setProgress(progress);
            }
            SchedulerxWorker.AtLeastDeliveryRoutingActor.tell(builder.build(), null);
            LOGGER.info("report jobInstance={}, status={} to AtLeastDeliveryRoutingActor", this.jobInstanceInfo.getJobInstanceId(), instanceStatus);
        }
    }
}

