/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.master.persistence;

import com.alibaba.schedulerx.protocol.Worker;
import com.alibaba.schedulerx.shade.com.google.common.collect.Lists;
import com.alibaba.schedulerx.shade.com.google.common.collect.Maps;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PersistenceUtil {
    public static Map<Integer, Map<String, List<Worker.TaskStatusInfo>>> getTaskStatusMap(List<Worker.ContainerReportTaskStatusRequest> taskStatusInfos) {
        HashMap<Integer, Map<String, List<Worker.TaskStatusInfo>>> status2WorkIdAddr2TaskIds = Maps.newHashMap();
        for (Worker.ContainerReportTaskStatusRequest e : taskStatusInfos) {
            Integer status = e.getStatus();
            Long taskId = e.getTaskId();
            String traceId = e.getTraceId();
            String workerIdAddr = e.getWorkerId() + "@" + e.getWorkerAddr();
            PersistenceUtil.addTaskStatusInfo(status2WorkIdAddr2TaskIds, status, workerIdAddr, taskId, traceId);
        }
        return status2WorkIdAddr2TaskIds;
    }

    public static void addTaskStatusInfo(Map<Integer, Map<String, List<Worker.TaskStatusInfo>>> status2WorkIdAddr2TaskIds, Integer status, String workerIdAddr, Long taskId, String traceId) {
        Worker.TaskStatusInfo.Builder builder = Worker.TaskStatusInfo.newBuilder().setTaskId(taskId).setStatus(status);
        if (StringUtils.isNotBlank(traceId)) {
            builder.setTraceId(traceId);
        }
        Worker.TaskStatusInfo taskStatusInfo = builder.build();
        if (!status2WorkIdAddr2TaskIds.containsKey(status)) {
            HashMap<String, ArrayList<Worker.TaskStatusInfo>> workerAddr2TaskIds = Maps.newHashMap();
            workerAddr2TaskIds.put(workerIdAddr, Lists.newArrayList(taskStatusInfo));
            status2WorkIdAddr2TaskIds.put(status, workerAddr2TaskIds);
        } else {
            Map<String, List<Worker.TaskStatusInfo>> workerIdAddr2TaskIds = status2WorkIdAddr2TaskIds.get(status);
            if (!workerIdAddr2TaskIds.containsKey(workerIdAddr)) {
                workerIdAddr2TaskIds.put(workerIdAddr, Lists.newArrayList(taskStatusInfo));
            } else {
                workerIdAddr2TaskIds.get(workerIdAddr).add(taskStatusInfo);
            }
        }
    }
}

