/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.route;

import com.alibaba.schedulerx.common.domain.enums.RouteStrategyEnum;
import com.alibaba.schedulerx.common.util.ReflectionUtil;
import com.alibaba.schedulerx.worker.route.RoundRobinRouter;
import com.alibaba.schedulerx.worker.route.Router;
import com.alibaba.schedulerx.worker.route.RouterManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RouterFactory {
    protected static final Logger LOGGER = LogManager.getLogger();
    private static RouterManager routerManager = RouterManager.INSTANCE;

    public static Router getRouter(long appGroupId, long jobId, int type, String content) {
        Router router = routerManager.getRouter(appGroupId, jobId);
        if (router != null) {
            return router;
        }
        router = RouterFactory.buildRouter(type, content);
        routerManager.updateRouter(appGroupId, jobId, router);
        return router;
    }

    public static Router buildRouter(int type, String content) {
        Router router = null;
        String className = RouteStrategyEnum.routerClassName(type);
        try {
            router = (Router)ReflectionUtil.getInstanceByClassName(String.format(className, "worker"));
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("class not found", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
        if (router == null) {
            router = new RoundRobinRouter();
        }
        router.init(content);
        return router;
    }
}

