/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.timer;

import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;
import com.alibaba.schedulerx.worker.timer.AbstractTimerTask;
import com.alibaba.schedulerx.worker.util.FileUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LabelFromEdasFetchTimer
extends AbstractTimerTask {
    private static final String LABEL_KEY_IN_FILE = "alicloud.service.tag";

    @Override
    public String getName() {
        return "LabelFromEdasFetchTimer";
    }

    @Override
    public long getInitialDelay() {
        return 10L;
    }

    @Override
    public long getPeriod() {
        return 10L;
    }

    @Override
    public void run() {
        String labelFromFile;
        String labelLine;
        if (StringUtils.isNotBlank(ConfigUtil.getWorkerConfig().getString("worker.label"))) {
            return;
        }
        String labelFromEnv = System.getenv("EDAS_PACKAGE_VERSION");
        if (StringUtils.isNotBlank(labelFromEnv)) {
            ConfigUtil.getWorkerConfig().setProperty("worker.cur.label", labelFromEnv.trim().replace(" ", "_"));
            return;
        }
        String labelPath = ConfigUtil.getWorkerConfig().getString("worker.label.path");
        if (FileUtils.isExist(labelPath) && StringUtils.isNotBlank(labelLine = FileUtils.readLine(labelPath, LABEL_KEY_IN_FILE)) && StringUtils.isNotBlank(labelFromFile = this.getLabel(labelLine))) {
            ConfigUtil.getWorkerConfig().setProperty("worker.cur.label", labelFromFile.trim().replace(" ", "_"));
            return;
        }
        this.changeCurLabelToUserSetted();
    }

    private String getLabel(String labelLine) {
        String regex = "alicloud.service.tag=\"(.*?)\"";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(labelLine);
        if (matcher.find()) {
            String label = matcher.group(1);
            return StringUtils.isNotBlank(label) ? label : null;
        }
        return null;
    }

    private void changeCurLabelToUserSetted() {
        String labelSetByUser = ConfigUtil.getWorkerConfig().getString("worker.label");
        String curLabel = ConfigUtil.getWorkerConfig().getString("worker.cur.label");
        if (StringUtils.isBlank(labelSetByUser)) {
            return;
        }
        if (!labelSetByUser.equalsIgnoreCase(curLabel)) {
            ConfigUtil.getWorkerConfig().setProperty("worker.cur.label", labelSetByUser);
        }
    }
}

