/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.util;

import com.alibaba.schedulerx.common.domain.JobInstanceData;
import com.alibaba.schedulerx.common.util.HessianUtil;
import com.alibaba.schedulerx.protocol.Common;
import com.alibaba.schedulerx.protocol.Worker;
import com.alibaba.schedulerx.shade.com.google.common.collect.Lists;
import com.alibaba.schedulerx.worker.domain.JobContext;
import com.alibaba.schedulerx.worker.domain.ShardingTask;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;

public class ContanerUtil {
    public static JobContext convert2JobContext(Worker.MasterStartContainerRequest request) throws IOException {
        JobContext.JobContextBuilder contextBuilder = JobContext.newBuilder();
        contextBuilder.setJobId(request.getJobId());
        contextBuilder.setJobInstanceId(request.getJobInstanceId());
        contextBuilder.setTaskId(request.getTaskId());
        contextBuilder.setScheduleTime(new DateTime(request.getScheduleTime()));
        contextBuilder.setDataTime(new DateTime(request.getDataTime()));
        contextBuilder.setExecuteMode(request.getExecuteMode());
        contextBuilder.setJobType(request.getJobType());
        contextBuilder.setContent(request.getContent());
        contextBuilder.setJobParameters(request.getParameters());
        contextBuilder.setInstanceParameters(request.getInstanceParameters());
        contextBuilder.setUser(request.getUser());
        contextBuilder.setTaskMasterActorPath(request.getInstanceMasterAkkaPath());
        contextBuilder.setGroupId(request.getGroupId());
        contextBuilder.setMaxAttempt(request.getMaxAttempt());
        contextBuilder.setAttempt(request.getAttempt());
        if (request.hasTaskName()) {
            contextBuilder.setTaskName(request.getTaskName());
        }
        if (request.hasTask()) {
            Object obj = HessianUtil.toObject(request.getTask().toByteArray());
            contextBuilder.setTask(obj);
            if (obj instanceof ShardingTask) {
                ShardingTask shardingTask = (ShardingTask)obj;
                contextBuilder.setShardingId(shardingTask.getId());
                contextBuilder.setShardingParameter(shardingTask.getParameter());
            }
        } else {
            contextBuilder.setShardingId(request.getTaskId());
        }
        if (request.hasTaskMaxAttempt()) {
            contextBuilder.setTaskMaxAttempt(request.getTaskMaxAttempt());
        }
        if (request.hasTaskAttemptInterval()) {
            contextBuilder.setTaskAttemptInterval(request.getTaskAttemptInterval());
        }
        List<Common.UpstreamData> upstreamProtoDatas = request.getUpstreamDataList();
        ArrayList<JobInstanceData> upstreamDatas = Lists.newArrayList();
        for (Common.UpstreamData upstreamData : upstreamProtoDatas) {
            upstreamDatas.add(new JobInstanceData(upstreamData.getJobName(), upstreamData.getData()));
        }
        contextBuilder.setUpstreamData(upstreamDatas);
        if (request.hasWfInstanceId()) {
            contextBuilder.setWfInstanceId(request.getWfInstanceId());
        }
        if (request.hasSerialNum()) {
            contextBuilder.setSerialNum(request.getSerialNum());
        }
        if (request.hasJobName()) {
            contextBuilder.setJobName(request.getJobName());
        }
        if (request.hasShardingNum()) {
            contextBuilder.setShardingNum(request.getShardingNum());
        }
        if (request.hasTimeType()) {
            contextBuilder.setTimeType(request.getTimeType());
        }
        if (request.hasTimeExpression()) {
            contextBuilder.setTimeExpression(request.getTimeExpression());
        }
        if (request.hasNamespace()) {
            contextBuilder.setNamespace(request.getNamespace());
        }
        if (request.hasXattrs()) {
            contextBuilder.setXAttrs(request.getXattrs());
        }
        if (request.hasTriggerType()) {
            contextBuilder.setTriggerType(request.getTriggerType());
        }
        if (request.hasAppGroupId()) {
            contextBuilder.setAppGroupId(request.getAppGroupId());
        }
        if (request.hasTemplate()) {
            contextBuilder.setTemplate(request.getTemplate());
        }
        if (request.hasWorkflowId()) {
            contextBuilder.setWorkflowId(request.getWorkflowId());
        }
        return contextBuilder.build();
    }
}

