/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.util;

import com.alibaba.schedulerx.shade.com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class ShellUtil {
    public static ProcessBuilder createShellProcessBuilder(String cmd) {
        return new ProcessBuilder("/bin/sh", "-c", cmd);
    }

    public static ProcessBuilder createProcessBuilder(String[] cmds) {
        return new ProcessBuilder(cmds);
    }

    public static List<String> executeShell(String cmd) throws IOException {
        return ShellUtil.executeShell(cmd, -1L);
    }

    public static List<String> executeShell(String[] cmds, long timeout) throws IOException {
        try {
            String line;
            ProcessBuilder pb = ShellUtil.createProcessBuilder(cmds);
            Process p = pb.start();
            int exitCode = 0;
            exitCode = p.waitFor();
            InputStream stdOutStream = p.getInputStream();
            InputStream errStream = p.getErrorStream();
            BufferedReader br = null;
            br = exitCode == 0 ? new BufferedReader(new InputStreamReader(stdOutStream, StandardCharsets.UTF_8)) : new BufferedReader(new InputStreamReader(errStream, StandardCharsets.UTF_8));
            ArrayList<String> result2 = Lists.newArrayList();
            while ((line = br.readLine()) != null) {
                result2.add(line);
            }
            return result2;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    public static List<String> executeShell(String cmd, long timeout) throws IOException {
        try {
            String line;
            ProcessBuilder pb = ShellUtil.createShellProcessBuilder(cmd);
            Process p = pb.start();
            int exitCode = 0;
            exitCode = p.waitFor();
            InputStream stdOutStream = p.getInputStream();
            InputStream errStream = p.getErrorStream();
            BufferedReader br = null;
            br = exitCode == 0 ? new BufferedReader(new InputStreamReader(stdOutStream, StandardCharsets.UTF_8)) : new BufferedReader(new InputStreamReader(errStream, StandardCharsets.UTF_8));
            ArrayList<String> result2 = Lists.newArrayList();
            while ((line = br.readLine()) != null) {
                result2.add(line);
            }
            return result2;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    public static long getPidOfProcess(Process p) {
        long pid = -1L;
        try {
            if (p.getClass().getName().equals("java.lang.UNIXProcess")) {
                Field f = p.getClass().getDeclaredField("pid");
                f.setAccessible(true);
                pid = f.getLong(p);
                f.setAccessible(false);
            }
        }
        catch (Throwable e) {
            pid = -1L;
        }
        return pid;
    }

    public static void killProcess(long pid) throws IOException {
    }

    public static String stringListToString(List<String> stringList) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < stringList.size(); ++i) {
            builder.append(stringList.get(i)).append(System.lineSeparator());
        }
        return builder.toString();
    }

    public static void main(String[] args) throws IOException {
        String[] cmds = new String[]{"python", "/Users/armon/script/python/python_6230549.py"};
        List<String> lines2 = ShellUtil.executeShell(cmds, -1L);
        for (String line : lines2) {
            System.out.println(line);
        }
    }
}

