/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.util;

import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.HttpResponse;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.JsonNode;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.Unirest;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.exceptions.UnirestException;
import com.alibaba.schedulerx.worker.exception.TimeOffsetException;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;

public class TimeResolver {
    private static TimeResolver INSTANCE = new TimeResolver();
    private static final String TIME_OFFSET_QUERY_PATH = "/v1/calendar/getOffset";
    private static final String DOMAIN = ConfigUtil.getWorkerConfig().getString("domainName");
    private static final String TIME_OFFSET_QUERY_URL = "http://" + DOMAIN + "/v1/calendar/getOffset";

    public static TimeResolver getInstance() {
        return INSTANCE;
    }

    public Date plusTime(String calendarName, long baseTimeStamp, long offset, TimeUnit timeUnit) throws TimeOffsetException, UnirestException {
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        if (calendarName != null && !calendarName.trim().isEmpty()) {
            params.put("name", calendarName);
        }
        params.put("baseTimeStamp", baseTimeStamp);
        params.put("offset", offset);
        params.put("timeUnit", timeUnit.toString());
        HttpResponse<JsonNode> response = Unirest.get(TIME_OFFSET_QUERY_URL).queryString(params).asJson();
        if (response.getBody().getObject().getInt("code") != 200) {
            throw new TimeOffsetException(response.getBody().getObject().getString("msg"));
        }
        return new Date(response.getBody().getObject().getJSONObject("data").getLong("offsetInMillis"));
    }

    public Date plusDays(String calendarName, Date baseTime, long offset) throws Exception {
        return this.plusTime(calendarName, baseTime.getTime(), offset, TimeUnit.DAYS);
    }

    public Date plusHours(String calendarName, Date baseTime, long offset) throws Exception {
        return this.plusTime(calendarName, baseTime.getTime(), offset, TimeUnit.HOURS);
    }

    public Date plusMinutes(String calendarName, Date baseTime, long offset) throws Exception {
        return this.plusTime(calendarName, baseTime.getTime(), offset, TimeUnit.MINUTES);
    }

    public Date plusSeconds(String calendarName, Date baseTime, long offset) throws Exception {
        return this.plusTime(calendarName, baseTime.getTime(), offset, TimeUnit.SECONDS);
    }

    public Date plusMillis(String calendarName, Date baseTime, long offset) throws Exception {
        return this.plusTime(calendarName, baseTime.getTime(), offset, TimeUnit.MILLISECONDS);
    }

    public Date minusDays(String calendarName, Date baseTime, long offset) throws Exception {
        return this.plusTime(calendarName, baseTime.getTime(), 0L - offset, TimeUnit.DAYS);
    }

    public Date minusHours(String calendarName, Date baseTime, long offset) throws Exception {
        return this.plusTime(calendarName, baseTime.getTime(), 0L - offset, TimeUnit.HOURS);
    }

    public Date minusMinutes(String calendarName, Date baseTime, long offset) throws Exception {
        return this.plusTime(calendarName, baseTime.getTime(), 0L - offset, TimeUnit.MINUTES);
    }

    public Date minusSeconds(String calendarName, Date baseTime, long offset) throws Exception {
        return this.plusTime(calendarName, baseTime.getTime(), 0L - offset, TimeUnit.SECONDS);
    }

    public Date minusMillis(String calendarName, Date baseTime, long offset) throws Exception {
        return this.plusTime(calendarName, baseTime.getTime(), 0L - offset, TimeUnit.MILLISECONDS);
    }

    public static void main(String[] args) throws Exception {
        Date baseTime = new DateTime(2018, 3, 6, 0, 0, 30).toDate();
        TimeResolver timeResolver = TimeResolver.getInstance();
        System.out.println(timeResolver.plusDays("\u5de5\u4f5c\u65e5", baseTime, 2L));
        System.out.println(timeResolver.plusDays("\u5de5\u4f5c\u65e5", baseTime, -2L));
        System.out.println(timeResolver.plusDays(null, baseTime, 4L));
        System.out.println(timeResolver.plusDays("\u5de5\u4f5c\u65e5", baseTime, 9L));
    }
}

