/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.util;

import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.common.util.IpUtil;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;

public class WorkerIdGenerator {
    private static String WORKER_ID;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String get() {
        if (WORKER_ID != null) return WORKER_ID;
        Class<WorkerIdGenerator> clazz = WorkerIdGenerator.class;
        synchronized (WorkerIdGenerator.class) {
            if (WORKER_ID != null) return WORKER_ID;
            WORKER_ID = IpUtil.getFormatIpv4Address() + "_" + WorkerIdGenerator.getNamespaceHashCode() + "_" + System.currentTimeMillis() % 100000L;
            // ** MonitorExit[var0] (shouldn't be in output)
            return WORKER_ID;
        }
    }

    private static int getNamespaceHashCode() {
        String namespace = ConfigUtil.getWorkerConfig().getString("schedulerx.namespace");
        if (StringUtils.isBlank(namespace)) {
            namespace = System.getProperty("schedulerx.namespace");
        }
        if (StringUtils.isBlank(namespace)) {
            namespace = System.getProperty("tenant.id");
        }
        if (StringUtils.isBlank(namespace)) {
            namespace = "system_namespace";
        }
        return (namespace.hashCode() & Integer.MAX_VALUE) % 1000000;
    }

    public static void main(String[] args) {
        long start2 = System.currentTimeMillis();
        System.out.println("WORKER_ID=" + WorkerIdGenerator.get() + ", cost=" + (System.currentTimeMillis() - start2) + "ms");
    }
}

