/*
 * Decompiled with CFR 0.152.
 */
package akka.protobuf;

import akka.protobuf.CodedInputStream;
import akka.protobuf.CodedOutputStream;
import akka.protobuf.LiteralByteString;
import akka.protobuf.RopeByteString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class ByteString
implements Iterable<Byte> {
    static final int CONCATENATE_BY_COPY_SIZE = 128;
    static final int MIN_READ_FROM_CHUNK_SIZE = 256;
    static final int MAX_READ_FROM_CHUNK_SIZE = 8192;
    public static final ByteString EMPTY = new LiteralByteString(new byte[0]);

    ByteString() {
    }

    public abstract byte byteAt(int var1);

    public abstract ByteIterator iterator();

    public abstract int size();

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public ByteString substring(int n) {
        return this.substring(n, this.size());
    }

    public abstract ByteString substring(int var1, int var2);

    public boolean startsWith(ByteString byteString) {
        return this.size() >= byteString.size() && this.substring(0, byteString.size()).equals(byteString);
    }

    public static ByteString copyFrom(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return new LiteralByteString(byArray2);
    }

    public static ByteString copyFrom(byte[] byArray) {
        return ByteString.copyFrom(byArray, 0, byArray.length);
    }

    public static ByteString copyFrom(ByteBuffer byteBuffer, int n) {
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        return new LiteralByteString(byArray);
    }

    public static ByteString copyFrom(ByteBuffer byteBuffer) {
        return ByteString.copyFrom(byteBuffer, byteBuffer.remaining());
    }

    public static ByteString copyFrom(String string2, String string3) throws UnsupportedEncodingException {
        return new LiteralByteString(string2.getBytes(string3));
    }

    public static ByteString copyFromUtf8(String string2) {
        try {
            return new LiteralByteString(string2.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-8 not supported?", unsupportedEncodingException);
        }
    }

    public static ByteString readFrom(InputStream inputStream) throws IOException {
        return ByteString.readFrom(inputStream, 256, 8192);
    }

    public static ByteString readFrom(InputStream inputStream, int n) throws IOException {
        return ByteString.readFrom(inputStream, n, n);
    }

    public static ByteString readFrom(InputStream inputStream, int n, int n2) throws IOException {
        ByteString byteString;
        ArrayList<ByteString> arrayList = new ArrayList<ByteString>();
        int n3 = n;
        while ((byteString = ByteString.readChunk(inputStream, n3)) != null) {
            arrayList.add(byteString);
            n3 = Math.min(n3 * 2, n2);
        }
        return ByteString.copyFrom(arrayList);
    }

    private static ByteString readChunk(InputStream inputStream, int n) throws IOException {
        int n2;
        int n3;
        byte[] byArray = new byte[n];
        for (n2 = 0; n2 < n && (n3 = inputStream.read(byArray, n2, n - n2)) != -1; n2 += n3) {
        }
        if (n2 == 0) {
            return null;
        }
        return ByteString.copyFrom(byArray, 0, n2);
    }

    public ByteString concat(ByteString byteString) {
        int n;
        int n2 = this.size();
        if ((long)n2 + (long)(n = byteString.size()) >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("ByteString would be too long: " + n2 + "+" + n);
        }
        return RopeByteString.concatenate(this, byteString);
    }

    public static ByteString copyFrom(Iterable<ByteString> iterable) {
        ArrayList<ByteString> arrayList;
        if (!(iterable instanceof Collection)) {
            arrayList = new ArrayList<ByteString>();
            for (ByteString byteString : iterable) {
                arrayList.add(byteString);
            }
        } else {
            arrayList = (ArrayList<ByteString>)iterable;
        }
        ByteString byteString = arrayList.isEmpty() ? EMPTY : ByteString.balancedConcat(arrayList.iterator(), arrayList.size());
        return byteString;
    }

    private static ByteString balancedConcat(Iterator<ByteString> iterator2, int n) {
        ByteString byteString;
        assert (n >= 1);
        if (n == 1) {
            byteString = iterator2.next();
        } else {
            int n2 = n >>> 1;
            ByteString byteString2 = ByteString.balancedConcat(iterator2, n2);
            ByteString byteString3 = ByteString.balancedConcat(iterator2, n - n2);
            byteString = byteString2.concat(byteString3);
        }
        return byteString;
    }

    public void copyTo(byte[] byArray, int n) {
        this.copyTo(byArray, 0, n, this.size());
    }

    public void copyTo(byte[] byArray, int n, int n2, int n3) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Source offset < 0: " + n);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Target offset < 0: " + n2);
        }
        if (n3 < 0) {
            throw new IndexOutOfBoundsException("Length < 0: " + n3);
        }
        if (n + n3 > this.size()) {
            throw new IndexOutOfBoundsException("Source end offset < 0: " + (n + n3));
        }
        if (n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException("Target end offset < 0: " + (n2 + n3));
        }
        if (n3 > 0) {
            this.copyToInternal(byArray, n, n2, n3);
        }
    }

    protected abstract void copyToInternal(byte[] var1, int var2, int var3, int var4);

    public abstract void copyTo(ByteBuffer var1);

    public byte[] toByteArray() {
        int n = this.size();
        byte[] byArray = new byte[n];
        this.copyToInternal(byArray, 0, 0, n);
        return byArray;
    }

    public abstract void writeTo(OutputStream var1) throws IOException;

    public abstract ByteBuffer asReadOnlyByteBuffer();

    public abstract List<ByteBuffer> asReadOnlyByteBufferList();

    public abstract String toString(String var1) throws UnsupportedEncodingException;

    public String toStringUtf8() {
        try {
            return this.toString("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-8 not supported?", unsupportedEncodingException);
        }
    }

    public abstract boolean isValidUtf8();

    protected abstract int partialIsValidUtf8(int var1, int var2, int var3);

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract InputStream newInput();

    public abstract CodedInputStream newCodedInput();

    public static Output newOutput(int n) {
        return new Output(n);
    }

    public static Output newOutput() {
        return new Output(128);
    }

    static CodedBuilder newCodedBuilder(int n) {
        return new CodedBuilder(n);
    }

    protected abstract int getTreeDepth();

    protected abstract boolean isBalanced();

    protected abstract int peekCachedHashCode();

    protected abstract int partialHash(int var1, int var2, int var3);

    public String toString() {
        return String.format("<ByteString@%s size=%d>", Integer.toHexString(System.identityHashCode(this)), this.size());
    }

    static final class CodedBuilder {
        private final CodedOutputStream output;
        private final byte[] buffer;

        private CodedBuilder(int n) {
            this.buffer = new byte[n];
            this.output = CodedOutputStream.newInstance(this.buffer);
        }

        public ByteString build() {
            this.output.checkNoSpaceLeft();
            return new LiteralByteString(this.buffer);
        }

        public CodedOutputStream getCodedOutput() {
            return this.output;
        }
    }

    public static final class Output
    extends OutputStream {
        private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
        private final int initialCapacity;
        private final ArrayList<ByteString> flushedBuffers;
        private int flushedBuffersTotalBytes;
        private byte[] buffer;
        private int bufferPos;

        Output(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Buffer size < 0");
            }
            this.initialCapacity = n;
            this.flushedBuffers = new ArrayList();
            this.buffer = new byte[n];
        }

        @Override
        public synchronized void write(int n) {
            if (this.bufferPos == this.buffer.length) {
                this.flushFullBuffer(1);
            }
            this.buffer[this.bufferPos++] = (byte)n;
        }

        @Override
        public synchronized void write(byte[] byArray, int n, int n2) {
            if (n2 <= this.buffer.length - this.bufferPos) {
                System.arraycopy(byArray, n, this.buffer, this.bufferPos, n2);
                this.bufferPos += n2;
            } else {
                int n3 = this.buffer.length - this.bufferPos;
                System.arraycopy(byArray, n, this.buffer, this.bufferPos, n3);
                this.flushFullBuffer(n2 -= n3);
                System.arraycopy(byArray, n += n3, this.buffer, 0, n2);
                this.bufferPos = n2;
            }
        }

        public synchronized ByteString toByteString() {
            this.flushLastBuffer();
            return ByteString.copyFrom(this.flushedBuffers);
        }

        private byte[] copyArray(byte[] byArray, int n) {
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, Math.min(byArray.length, n));
            return byArray2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeTo(OutputStream outputStream) throws IOException {
            ByteString[] byteStringArray = this;
            synchronized (this) {
                ByteString[] byteStringArray2 = this.flushedBuffers.toArray(new ByteString[this.flushedBuffers.size()]);
                byte[] byArray = this.buffer;
                int n = this.bufferPos;
                // ** MonitorExit[var5_2] (shouldn't be in output)
                for (ByteString byteString : byteStringArray2) {
                    byteString.writeTo(outputStream);
                }
                outputStream.write(super.copyArray(byArray, n));
                return;
            }
        }

        public synchronized int size() {
            return this.flushedBuffersTotalBytes + this.bufferPos;
        }

        public synchronized void reset() {
            this.flushedBuffers.clear();
            this.flushedBuffersTotalBytes = 0;
            this.bufferPos = 0;
        }

        public String toString() {
            return String.format("<ByteString.Output@%s size=%d>", Integer.toHexString(System.identityHashCode(this)), this.size());
        }

        private void flushFullBuffer(int n) {
            this.flushedBuffers.add(new LiteralByteString(this.buffer));
            this.flushedBuffersTotalBytes += this.buffer.length;
            int n2 = Math.max(this.initialCapacity, Math.max(n, this.flushedBuffersTotalBytes >>> 1));
            this.buffer = new byte[n2];
            this.bufferPos = 0;
        }

        private void flushLastBuffer() {
            if (this.bufferPos < this.buffer.length) {
                if (this.bufferPos > 0) {
                    byte[] byArray = this.copyArray(this.buffer, this.bufferPos);
                    this.flushedBuffers.add(new LiteralByteString(byArray));
                }
            } else {
                this.flushedBuffers.add(new LiteralByteString(this.buffer));
                this.buffer = EMPTY_BYTE_ARRAY;
            }
            this.flushedBuffersTotalBytes += this.bufferPos;
            this.bufferPos = 0;
        }
    }

    public static interface ByteIterator
    extends Iterator<Byte> {
        public byte nextByte();
    }
}

