/*
 * Decompiled with CFR 0.152.
 */
package akka.remote;

import akka.actor.ExtendedActorSystem;
import akka.protobuf.ByteString;
import akka.remote.MessageSerializer;
import akka.remote.WireFormats;
import akka.remote.artery.EnvelopeBuffer;
import akka.remote.artery.HeaderBuilder;
import akka.remote.artery.OutboundEnvelope;
import akka.serialization.ByteBufferSerializer;
import akka.serialization.Serialization;
import akka.serialization.SerializationExtension$;
import akka.serialization.Serializer;
import akka.serialization.SerializerWithStringManifest;
import com.alibaba.schedulerx.shade.scala.Option;
import com.alibaba.schedulerx.shade.scala.Predef$;
import com.alibaba.schedulerx.shade.scala.StringContext;
import com.alibaba.schedulerx.shade.scala.collection.mutable.StringBuilder;
import com.alibaba.schedulerx.shade.scala.runtime.BoxedUnit;
import com.alibaba.schedulerx.shade.scala.util.control.NonFatal$;

public final class MessageSerializer$ {
    public static final MessageSerializer$ MODULE$;

    static {
        new MessageSerializer$();
    }

    public Object deserialize(ExtendedActorSystem system, WireFormats.SerializedMessage messageProtocol) {
        return ((Serialization)SerializationExtension$.MODULE$.apply(system)).deserialize(messageProtocol.getMessage().toByteArray(), messageProtocol.getSerializerId(), messageProtocol.hasMessageManifest() ? messageProtocol.getMessageManifest().toStringUtf8() : "").get();
    }

    public WireFormats.SerializedMessage serialize(ExtendedActorSystem system, Object message) {
        Serialization s2 = (Serialization)SerializationExtension$.MODULE$.apply(system);
        Serializer serializer = s2.findSerializerFor(message);
        WireFormats.SerializedMessage.Builder builder = WireFormats.SerializedMessage.newBuilder();
        try {
            BoxedUnit boxedUnit;
            builder.setMessage(ByteString.copyFrom(serializer.toBinary(message)));
            builder.setSerializerId(serializer.identifier());
            Serializer serializer2 = serializer;
            if (serializer2 instanceof SerializerWithStringManifest) {
                String manifest;
                SerializerWithStringManifest serializerWithStringManifest = (SerializerWithStringManifest)serializer2;
                String string2 = manifest = serializerWithStringManifest.manifest(message);
                String string3 = "";
                boxedUnit = !(string2 != null ? !string2.equals(string3) : string3 != null) ? BoxedUnit.UNIT : builder.setMessageManifest(ByteString.copyFromUtf8(manifest));
            } else {
                boxedUnit = serializer.includeManifest() ? builder.setMessageManifest(ByteString.copyFromUtf8(message.getClass().getName())) : BoxedUnit.UNIT;
            }
            return builder.build();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = option.get();
            throw new MessageSerializer.SerializationException(new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to serialize remote message [", "] "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{message.getClass()}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"using serializer [", "]."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{serializer.getClass()}))).toString(), e);
        }
    }

    public void serializeForArtery(Serialization serialization, OutboundEnvelope outboundEnvelope, HeaderBuilder headerBuilder, EnvelopeBuffer envelope) {
        Object message = outboundEnvelope.message();
        Serializer serializer = serialization.findSerializerFor(message);
        headerBuilder.setSerializer(serializer.identifier());
        Serializer serializer2 = serializer;
        if (serializer2 instanceof ByteBufferSerializer) {
            Serializer serializer3 = serializer2;
            headerBuilder.setManifest(this.manifest$1(message, serializer));
            envelope.writeHeader(headerBuilder, outboundEnvelope);
            ((ByteBufferSerializer)((Object)serializer3)).toBinary(message, envelope.byteBuffer());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            headerBuilder.setManifest(this.manifest$1(message, serializer));
            envelope.writeHeader(headerBuilder, outboundEnvelope);
            envelope.byteBuffer().put(serializer.toBinary(message));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Object deserializeForArtery(ExtendedActorSystem system, long originUid, Serialization serialization, int serializer, String classManifest, EnvelopeBuffer envelope) {
        return serialization.deserializeByteBuffer(envelope.byteBuffer(), serializer, classManifest);
    }

    private final String manifest$1(Object message$1, Serializer serializer$1) {
        String string2;
        Serializer serializer = serializer$1;
        if (serializer instanceof SerializerWithStringManifest) {
            SerializerWithStringManifest serializerWithStringManifest = (SerializerWithStringManifest)serializer;
            string2 = serializerWithStringManifest.manifest(message$1);
        } else {
            string2 = serializer$1.includeManifest() ? message$1.getClass().getName() : "";
        }
        return string2;
    }

    private MessageSerializer$() {
        MODULE$ = this;
    }
}

