/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.common.domain.enums;

import com.alibaba.schedulerx.common.domain.CommonResultCode;
import com.alibaba.schedulerx.common.exception.SchedulerxException;

public enum PermissionTypeEnum {
    ALL("*", 3, "\u5168\u90e8\u6743\u9650"),
    READ_ONLY("r", 1, "\u53ea\u8bfb\u6743\u9650");

    private String key;
    private int value;
    private String desc;

    private PermissionTypeEnum(String key, int value2, String desc) {
        this.key = key;
        this.value = value2;
        this.desc = desc;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value2) {
        this.value = value2;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static boolean isValidType(String type) {
        for (PermissionTypeEnum item : PermissionTypeEnum.values()) {
            if (!item.key.equals(type)) continue;
            return true;
        }
        return false;
    }

    public static PermissionTypeEnum getType(String type) {
        for (PermissionTypeEnum item : PermissionTypeEnum.values()) {
            if (!item.key.equals(type)) continue;
            return item;
        }
        throw new SchedulerxException(CommonResultCode.INVALID_PARAMETERS);
    }

    public boolean implies(PermissionTypeEnum target) {
        if (target != null) {
            return (this.value & target.value) == target.value;
        }
        return false;
    }
}

