/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.common.sdk.request;

import com.alibaba.schedulerx.common.domain.enums.ResponseCodeEnum;
import com.alibaba.schedulerx.common.exception.RequestCheckException;
import com.alibaba.schedulerx.common.sdk.common.JavaJobConfig;
import com.alibaba.schedulerx.common.sdk.common.ParamValidate;
import com.alibaba.schedulerx.common.sdk.request.BaseRequest;
import com.alibaba.schedulerx.common.sdk.response.CreateJobResponse;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;

public class CreateJavaJobRequest
extends BaseRequest<CreateJobResponse> {
    private JavaJobConfig javaJobConfig;

    public JavaJobConfig getJavaJobConfig() {
        return this.javaJobConfig;
    }

    public void setJavaJobConfig(JavaJobConfig javaJobConfig) {
        this.javaJobConfig = javaJobConfig;
        super.getParameterMap().putAll(javaJobConfig.getParamMap());
    }

    @Override
    public Class<CreateJobResponse> getResponseClass() {
        return CreateJobResponse.class;
    }

    @Override
    public String getUrlPath() {
        return "/openapi/v1/job/create";
    }

    @Override
    public void preRun() throws RequestCheckException {
        if (this.javaJobConfig != null) {
            ParamValidate.doValidator(this.javaJobConfig);
            if ((this.javaJobConfig.getTimeConfig().getTimeType() == 1 || this.javaJobConfig.getTimeConfig().getTimeType() == 3 || this.javaJobConfig.getTimeConfig().getTimeType() == 4) && StringUtils.isBlank(this.javaJobConfig.getTimeConfig().getTimeExpression())) {
                throw new RequestCheckException(ResponseCodeEnum.PARAM_CHECK_ERROR.getCode(), "cron/fix_rate/second_delay timeType must set timeExpression");
            }
        } else {
            throw new RequestCheckException(ResponseCodeEnum.PARAM_CHECK_ERROR.getCode(), "javaJobConfig is null");
        }
    }
}

