/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.common.util;

import com.alibaba.schedulerx.shade.org.apache.commons.codec.binary.Base64;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.security.cert.X509Certificate;

public class SignatureUtil {
    public static final String SHA1_RSA_SIGNATURE = "SHA1withRSA";
    public static final String ALGORITHM_RSA = "RSA";
    public static final String SECRET_KEY_IGNORE_LINE = "---";

    public static String geneHmacSHA1Encrypt(String timeStamp, String appGroupId, String secretKey) throws Exception {
        String encryptText = appGroupId + timeStamp;
        Mac mac = Mac.getInstance("HmacSHA1");
        if (secretKey == null) {
            throw new RuntimeException("accesskey not exist");
        }
        mac.init(new SecretKeySpec(secretKey.getBytes(Charset.forName("UTF-8")), "HmacSHA1"));
        byte[] bytes = mac.doFinal(encryptText.getBytes(Charset.forName("UTF-8")));
        return new String(Base64.encodeBase64(bytes), Charset.forName("UTF-8")).replace("+", "").replace("=", "").replace("/", "");
    }

    public static String signWithPKCS8(File secretKeyFile, String message) throws SignatureException {
        return SignatureUtil.signWithPKCS8(secretKeyFile, message, SHA1_RSA_SIGNATURE);
    }

    public static String signWithPKCS8(File secretKeyFile, String message, String algorithm) throws SignatureException {
        try {
            String secretKey = "";
            for (String line : Files.readAllLines(Paths.get(secretKeyFile.toURI()), StandardCharsets.UTF_8)) {
                if (line.startsWith(SECRET_KEY_IGNORE_LINE)) continue;
                secretKey = secretKey + line;
            }
            return SignatureUtil.signWithPKCS8(secretKey, message, algorithm);
        }
        catch (Exception ex) {
            throw new SignatureException(ex);
        }
    }

    public static String signWithPKCS8(String secretKey, String message, String algorithm) throws SignatureException {
        try {
            Signature sign2 = Signature.getInstance(algorithm);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64(secretKey.getBytes()));
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM_RSA);
            PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
            sign2.initSign(privateKey);
            sign2.update(message.getBytes("UTF-8"));
            return new String(Base64.encodeBase64(sign2.sign()), "UTF-8");
        }
        catch (Exception ex) {
            throw new SignatureException(ex);
        }
    }

    public static boolean verify(String publicKeyPath, String message, String signature) throws SignatureException {
        try {
            Signature sign2 = Signature.getInstance(SHA1_RSA_SIGNATURE);
            byte[] keyBytes = Files.readAllBytes(Paths.get(publicKeyPath, new String[0]));
            X509Certificate cert = X509Certificate.getInstance(keyBytes);
            PublicKey publicKey = cert.getPublicKey();
            sign2.initVerify(publicKey);
            sign2.update(message.getBytes("UTF-8"));
            return sign2.verify(Base64.decodeBase64(signature.getBytes("UTF-8")));
        }
        catch (Exception ex) {
            throw new SignatureException(ex);
        }
    }

    public static void main(String[] args) throws Exception {
        String timeNow = Long.toString(System.currentTimeMillis());
        System.out.println(timeNow);
        System.out.println(SignatureUtil.geneHmacSHA1Encrypt(timeNow, "hxm.test", "9AqOGlUp4xmx3Dfn21BM6A=="));
    }
}

