/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.common.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    private static final int PAD_LIMIT = 8192;
    private static Pattern linePattern = Pattern.compile("_(\\w)");

    public static String leftPad(String str, int size2, String padStr) {
        if (str == null) {
            return null;
        }
        if (StringUtils.isEmpty(padStr)) {
            padStr = " ";
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size2 - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return StringUtils.leftPad(str, size2, padStr.charAt(0));
        }
        if (pads == padLen) {
            return padStr.concat(str);
        }
        if (pads < padLen) {
            return padStr.substring(0, pads).concat(str);
        }
        char[] padding2 = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding2[i] = padChars[i % padLen];
        }
        return new String(padding2).concat(str);
    }

    public static String lineToHump(String str, Boolean firstUpperCase) {
        if (StringUtils.isEmpty(str)) {
            return "";
        }
        str = str.toLowerCase();
        Matcher matcher = linePattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(sb);
        if (firstUpperCase.booleanValue()) {
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        }
        return sb.toString();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtils.isEmpty(str);
    }

    public static String leftPad(String str, int size2, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size2 - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            return StringUtils.leftPad(str, size2, String.valueOf(padChar));
        }
        return StringUtils.padding(pads, padChar).concat(str);
    }

    private static String padding(int repeat2, char padChar) throws IndexOutOfBoundsException {
        if (repeat2 < 0) {
            throw new IndexOutOfBoundsException("Cannot pad a negative amount: " + repeat2);
        }
        char[] buf = new char[repeat2];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = padChar;
        }
        return new String(buf);
    }

    public static boolean equals(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equalsIgnoreCase(str2);
    }

    public static String upperCase(String str) {
        return str == null ? null : str.toUpperCase();
    }
}

