/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer.internals;

import com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer.Attempt;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer.ProducerConfig;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer.internals.ProducerBatch;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer.internals.RetryQueue;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.Client;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.TagContent;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.exception.LogException;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.request.PutLogsRequest;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.response.PutLogsResponse;
import com.alibaba.schedulerx.shade.com.google.common.math.LongMath;
import com.alibaba.schedulerx.shade.org.slf4j.Logger;
import com.alibaba.schedulerx.shade.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class SendProducerBatchTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProducerBatch.class);
    private static final String TAG_PACK_ID = "__pack_id__";
    private final ProducerBatch batch;
    private final ProducerConfig producerConfig;
    private final Map<String, Client> clientPool;
    private final RetryQueue retryQueue;
    private final BlockingQueue<ProducerBatch> successQueue;
    private final BlockingQueue<ProducerBatch> failureQueue;
    private final AtomicInteger batchCount;

    public SendProducerBatchTask(ProducerBatch batch2, ProducerConfig producerConfig, Map<String, Client> clientPool, RetryQueue retryQueue, BlockingQueue<ProducerBatch> successQueue, BlockingQueue<ProducerBatch> failureQueue, AtomicInteger batchCount) {
        this.batch = batch2;
        this.producerConfig = producerConfig;
        this.clientPool = clientPool;
        this.retryQueue = retryQueue;
        this.successQueue = successQueue;
        this.failureQueue = failureQueue;
        this.batchCount = batchCount;
    }

    @Override
    public void run() {
        try {
            this.sendProducerBatch(System.currentTimeMillis());
        }
        catch (Throwable t) {
            LOGGER.error("Uncaught error in send producer batch task, project=" + this.batch.getProject() + ", logStore=" + this.batch.getLogStore() + ", e=", t);
        }
    }

    private void sendProducerBatch(long nowMs) throws InterruptedException {
        LOGGER.trace("Prepare to send producer batch, batch={}", (Object)this.batch);
        String project = this.batch.getProject();
        Client client = this.getClient(project);
        if (client == null) {
            LOGGER.error("Failed to get client, project={}", (Object)project);
            Attempt attempt = new Attempt(false, "", "ProjectConfigNotExist", "Cannot get the projectConfig for project " + project, nowMs);
            this.batch.appendAttempt(attempt);
            this.failureQueue.put(this.batch);
        } else {
            PutLogsResponse response;
            try {
                PutLogsRequest request2 = this.buildPutLogsRequest(this.batch);
                response = client.PutLogs(request2);
            }
            catch (Exception e) {
                block8: {
                    LOGGER.error("Failed to put logs, project=" + this.batch.getProject() + ", logStore=" + this.batch.getLogStore() + ", e=", e);
                    Attempt attempt = this.buildAttempt(e, nowMs);
                    this.batch.appendAttempt(attempt);
                    if (this.meetFailureCondition(e)) {
                        LOGGER.debug("Prepare to put batch to the failure queue");
                        this.failureQueue.put(this.batch);
                    } else {
                        LOGGER.debug("Prepare to put batch to the retry queue");
                        long retryBackoffMs = this.calculateRetryBackoffMs();
                        LOGGER.debug("Calculate the retryBackoffMs successfully, retryBackoffMs=" + retryBackoffMs);
                        this.batch.setNextRetryMs(System.currentTimeMillis() + retryBackoffMs);
                        try {
                            this.retryQueue.put(this.batch);
                        }
                        catch (IllegalStateException e1) {
                            LOGGER.error("Failed to put batch to the retry queue, project=" + this.batch.getProject() + ", logStore=" + this.batch.getLogStore() + ", e=", e);
                            if (!this.retryQueue.isClosed()) break block8;
                            LOGGER.info("Prepare to put batch to the failure queue since the retry queue was closed");
                            this.failureQueue.put(this.batch);
                        }
                    }
                }
                return;
            }
            Attempt attempt = new Attempt(true, response.GetRequestId(), "", "", nowMs);
            this.batch.appendAttempt(attempt);
            this.successQueue.put(this.batch);
            LOGGER.trace("Send producer batch successfully, batch={}", (Object)this.batch);
        }
    }

    private Client getClient(String project) {
        return this.clientPool.get(project);
    }

    private PutLogsRequest buildPutLogsRequest(ProducerBatch batch2) {
        PutLogsRequest request2 = batch2.getShardHash() != null && !batch2.getShardHash().isEmpty() ? new PutLogsRequest(batch2.getProject(), batch2.getLogStore(), batch2.getTopic(), batch2.getSource(), batch2.getLogItems(), batch2.getShardHash()) : new PutLogsRequest(batch2.getProject(), batch2.getLogStore(), batch2.getTopic(), batch2.getSource(), batch2.getLogItems());
        ArrayList<TagContent> tags = new ArrayList<TagContent>();
        tags.add(new TagContent(TAG_PACK_ID, batch2.getPackageId()));
        request2.SetTags(tags);
        if (this.producerConfig.getLogFormat() == ProducerConfig.LogFormat.PROTOBUF) {
            request2.setContentType("application/x-protobuf");
        } else {
            request2.setContentType("application/json");
        }
        return request2;
    }

    private Attempt buildAttempt(Exception e, long nowMs) {
        if (e instanceof LogException) {
            LogException logException = (LogException)e;
            return new Attempt(false, logException.GetRequestId(), logException.GetErrorCode(), logException.GetErrorMessage(), nowMs);
        }
        return new Attempt(false, "", "ProducerException", e.getMessage(), nowMs);
    }

    private boolean meetFailureCondition(Exception e) {
        if (!this.isRetriableException(e)) {
            return true;
        }
        if (this.retryQueue.isClosed()) {
            return true;
        }
        return this.batch.getRetries() >= this.producerConfig.getRetries() && this.failureQueue.size() <= this.batchCount.get() / 2;
    }

    private boolean isRetriableException(Exception e) {
        if (e instanceof LogException) {
            LogException logException = (LogException)e;
            return logException.GetErrorCode().equals("RequestError") || logException.GetErrorCode().equals("Unauthorized") || logException.GetErrorCode().equals("WriteQuotaExceed") || logException.GetErrorCode().equals("ShardWriteQuotaExceed") || logException.GetErrorCode().equals("ExceedQuota") || logException.GetErrorCode().equals("InternalServerError") || logException.GetErrorCode().equals("ServerBusy") || logException.GetErrorCode().equals("BadResponse") || logException.GetErrorCode().equals("ProjectNotExists") || logException.GetErrorCode().equals("LogstoreNotExists");
        }
        return false;
    }

    private long calculateRetryBackoffMs() {
        int retry = this.batch.getRetries();
        long retryBackoffMs = this.producerConfig.getBaseRetryBackoffMs() * LongMath.pow(2L, retry);
        if (retryBackoffMs <= 0L) {
            retryBackoffMs = this.producerConfig.getMaxRetryBackoffMs();
        }
        return Math.min(retryBackoffMs, this.producerConfig.getMaxRetryBackoffMs());
    }
}

