/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common;

import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.FastLogContent;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.util.VarintUtil;
import java.util.ArrayList;

public class FastLog {
    private byte[] rawBytes;
    private int beginOffset;
    private int endOffset;
    private int time = -1;
    private ArrayList<FastLogContent> contents;

    public FastLog(byte[] rawBytes, int offset, int length) {
        this.rawBytes = rawBytes;
        this.beginOffset = offset;
        this.endOffset = offset + length;
        this.contents = new ArrayList();
        if (!this.parse()) {
            this.contents.clear();
        }
    }

    private boolean parse() {
        int pos = this.beginOffset;
        boolean findTime = false;
        while (pos < this.endOffset) {
            int[] value2 = VarintUtil.DecodeVarInt32(this.rawBytes, pos, this.endOffset);
            if (value2[0] == 0) {
                return false;
            }
            int mode = value2[1] & 7;
            int index2 = value2[1] >> 3;
            if (mode == 0) {
                pos = value2[2];
                if ((value2 = VarintUtil.DecodeVarInt32(this.rawBytes, pos, this.endOffset))[0] == 0) {
                    return false;
                }
                pos = value2[2];
                if (index2 != 1) continue;
                this.time = value2[1];
                findTime = true;
                continue;
            }
            if (mode == 1) {
                pos = value2[2] + 8;
                continue;
            }
            if (mode == 2) {
                pos = value2[2];
                if ((value2 = VarintUtil.DecodeVarInt32(this.rawBytes, pos, this.endOffset))[0] == 0) {
                    return false;
                }
                pos = value2[2] + value2[1];
                if (index2 != 2) continue;
                this.contents.add(new FastLogContent(this.rawBytes, value2[2], value2[1]));
                continue;
            }
            if (mode == 5) {
                pos = value2[2] + 4;
                continue;
            }
            return false;
        }
        return findTime && pos == this.endOffset;
    }

    public int getTime() {
        return this.time;
    }

    public int getContentsCount() {
        return this.contents.size();
    }

    public FastLogContent getContents(int i) {
        if (i < this.contents.size()) {
            return this.contents.get(i);
        }
        return null;
    }
}

