/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common;

import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.util.VarintUtil;

public class FastLogTag {
    private byte[] rawBytes;
    private int beginOffset;
    private int endOffset;
    private int keyOffset = -1;
    private int keyLength = -1;
    private int valueOffset = -1;
    private int valueLength = -1;

    public FastLogTag(byte[] rawBytes, int offset, int length) {
        this.rawBytes = rawBytes;
        this.beginOffset = offset;
        this.endOffset = offset + length;
        if (!this.parse()) {
            this.keyOffset = -1;
            this.keyLength = -1;
            this.valueOffset = -1;
            this.valueLength = -1;
        }
    }

    private boolean parse() {
        int pos = this.beginOffset;
        while (pos < this.endOffset) {
            int[] value2 = VarintUtil.DecodeVarInt32(this.rawBytes, pos, this.endOffset);
            if (value2[0] == 0) {
                return false;
            }
            pos = value2[2];
            int mode = value2[1] & 7;
            int index2 = value2[1] >> 3;
            if (mode == 0) {
                value2 = VarintUtil.DecodeVarInt32(this.rawBytes, pos, this.endOffset);
                if (value2[0] == 0) {
                    return false;
                }
                pos = value2[2];
                continue;
            }
            if (mode == 1) {
                pos += 8;
                continue;
            }
            if (mode == 2) {
                value2 = VarintUtil.DecodeVarInt32(this.rawBytes, pos, this.endOffset);
                if (value2[0] == 0) {
                    return false;
                }
                pos = value2[2] + value2[1];
                if (index2 == 1) {
                    this.keyOffset = value2[2];
                    this.keyLength = value2[1];
                    continue;
                }
                if (index2 != 2) continue;
                this.valueOffset = value2[2];
                this.valueLength = value2[1];
                continue;
            }
            if (mode == 5) {
                pos += 4;
                continue;
            }
            return false;
        }
        return this.keyOffset != -1 && this.valueOffset != -1 && pos == this.endOffset;
    }

    public String getKey() {
        if (this.keyOffset < 0) {
            return null;
        }
        return new String(this.rawBytes, this.keyOffset, this.keyLength);
    }

    public String getValue() {
        if (this.valueOffset < 0) {
            return null;
        }
        return new String(this.rawBytes, this.valueOffset, this.valueLength);
    }

    public byte[] getKeyBytes() {
        if (this.keyOffset < 0) {
            return null;
        }
        byte[] keyBytes = new byte[this.keyLength];
        System.arraycopy(this.rawBytes, this.keyOffset, keyBytes, 0, this.keyLength);
        return keyBytes;
    }

    public byte[] getValueBytes() {
        if (this.valueOffset < 0) {
            return null;
        }
        byte[] valueBytes = new byte[this.valueLength];
        System.arraycopy(this.rawBytes, this.valueOffset, valueBytes, 0, this.valueLength);
        return valueBytes;
    }
}

