/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common;

import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.FastLogGroup;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.LogContent;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.LogItem;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.Logs;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.exception.LogException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class LogGroupData
implements Serializable {
    private static final long serialVersionUID = -7939302281903476332L;
    protected String mReserved = "";
    protected String mTopic = "";
    protected String mSource = "";
    protected String mMachineUUID = "";
    protected ArrayList<LogItem> mLogs;
    protected Logs.LogGroup mLogGroup = null;
    protected FastLogGroup mFastLogGroup = null;
    protected byte[] rawBytes = null;
    protected int offset;
    protected int length;
    protected String mRequestId = "";

    public LogGroupData() {
    }

    public LogGroupData(byte[] rawBytes, int offset, int length, String requestId) {
        this.rawBytes = rawBytes;
        this.offset = offset;
        this.length = length;
        this.mRequestId = requestId;
    }

    public LogGroupData(Logs.LogGroup logGroup) {
        this.mLogGroup = logGroup;
    }

    public Logs.LogGroup GetLogGroup() throws LogException {
        if (this.mLogGroup == null) {
            this.ParseLogGroupPb();
        }
        return this.mLogGroup;
    }

    public void SetLogGroup(Logs.LogGroup mLogGroup) {
        this.mLogGroup = mLogGroup;
    }

    public FastLogGroup GetFastLogGroup() {
        if (this.mFastLogGroup == null) {
            this.mFastLogGroup = new FastLogGroup(this.rawBytes, this.offset, this.length);
        }
        return this.mFastLogGroup;
    }

    @Deprecated
    public LogGroupData(LogGroupData logGroup) {
        this.mReserved = logGroup.GetReserved();
        this.mTopic = logGroup.GetTopic();
        this.mSource = logGroup.GetSource();
        this.mMachineUUID = logGroup.GetMachineUUID();
        this.mLogs = logGroup.mLogs;
        this.mLogGroup = logGroup.mLogGroup;
    }

    @Deprecated
    public LogGroupData(String reserved, String topic, String source, String mMachineUUID, ArrayList<LogItem> logs) {
        this.mReserved = reserved;
        this.mTopic = topic;
        this.mSource = source;
        this.SetAllLogs(logs);
    }

    private boolean ParseLogGroupPb() throws LogException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.rawBytes, this.offset, this.length);
        try {
            this.mLogGroup = Logs.LogGroup.parseFrom(inputStream);
        }
        catch (IOException e) {
            throw new LogException("InitLogGroupsError", e.getMessage(), e, this.mRequestId);
        }
        return true;
    }

    protected void AutoDeserilize() throws LogException {
        if (this.mLogGroup == null && !this.ParseLogGroupPb()) {
            return;
        }
        if (this.mLogs != null) {
            return;
        }
        if (this.mLogGroup.hasCategory()) {
            this.SetReserved(this.mLogGroup.getCategory());
        }
        if (this.mLogGroup.hasTopic()) {
            this.SetTopic(this.mLogGroup.getTopic());
        }
        if (this.mLogGroup.hasSource()) {
            this.SetSource(this.mLogGroup.getSource());
        }
        if (this.mLogGroup.hasMachineUUID()) {
            this.SetMachineUUID(this.mLogGroup.getMachineUUID());
        }
        List<Logs.Log> logs = this.mLogGroup.getLogsList();
        ArrayList<LogItem> logItems = new ArrayList<LogItem>();
        for (Logs.Log log2 : logs) {
            ArrayList<LogContent> logContents = new ArrayList<LogContent>();
            for (Logs.Log.Content content : log2.getContentsList()) {
                logContents.add(new LogContent(content.getKey(), content.getValue()));
            }
            logItems.add(new LogItem(log2.getTime(), logContents));
        }
        this.SetAllLogs(logItems);
    }

    @Deprecated
    public ArrayList<LogItem> GetAllLogs() throws LogException {
        this.AutoDeserilize();
        return this.mLogs;
    }

    @Deprecated
    public LogItem GetLogByIndex(int index2) throws LogException {
        this.AutoDeserilize();
        return this.mLogs.get(index2);
    }

    @Deprecated
    public void SetAllLogs(ArrayList<LogItem> logs) {
        this.mLogs = logs;
    }

    @Deprecated
    public String GetReserved() {
        return this.mReserved;
    }

    @Deprecated
    public void SetReserved(String reserved) {
        this.mReserved = reserved;
    }

    @Deprecated
    public String GetTopic() {
        return this.mLogGroup.getTopic();
    }

    @Deprecated
    public void SetTopic(String topic) {
        this.mTopic = topic;
    }

    @Deprecated
    public String GetSource() {
        return this.mLogGroup.getSource();
    }

    @Deprecated
    public void SetSource(String source) {
        this.mSource = source;
    }

    @Deprecated
    public String GetMachineUUID() {
        return this.mLogGroup.getMachineUUID();
    }

    @Deprecated
    public void SetMachineUUID(String machineUUID) {
        this.mMachineUUID = machineUUID;
    }
}

