/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common;

import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.ShipperConfig;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.exception.LogException;
import com.alibaba.schedulerx.shade.net.sf.json.JSONArray;
import com.alibaba.schedulerx.shade.net.sf.json.JSONException;
import com.alibaba.schedulerx.shade.net.sf.json.JSONObject;
import java.util.ArrayList;
import java.util.List;

public class OdpsShipperConfig
implements ShipperConfig {
    private String mOdpsEndPoint;
    private String mOdpsProject;
    private String mOdpsTable;
    private List<String> mLogFieldsList;
    private List<String> mPartitionColumn;
    private String mPartitionTimeFormat;
    private int mBufferInterval;

    public OdpsShipperConfig(String odpsEndPoint, String odpsProject, String odpsTable, List<String> logFieldsList, List<String> partitionColumn, String partitionTimeFormat) {
        this.mOdpsEndPoint = odpsEndPoint;
        this.mOdpsProject = odpsProject;
        this.mOdpsTable = odpsTable;
        this.mLogFieldsList = logFieldsList;
        this.mPartitionColumn = partitionColumn;
        this.mPartitionTimeFormat = partitionTimeFormat;
        this.mBufferInterval = 1800;
    }

    public OdpsShipperConfig() {
    }

    public String GetOdpsEndPoint() {
        return this.mOdpsEndPoint;
    }

    public String GetOdpsProject() {
        return this.mOdpsProject;
    }

    public String GetOdpsTable() {
        return this.mOdpsTable;
    }

    public List<String> GetLogFieldsList() {
        return new ArrayList<String>(this.mLogFieldsList);
    }

    public List<String> GetPartitionColumn() {
        return new ArrayList<String>(this.mPartitionColumn);
    }

    public String GetPartitionTimeFromat() {
        return this.mPartitionTimeFormat;
    }

    @Override
    public String GetShipperType() {
        return "odps";
    }

    public void setOdpsEndPoint(String odpsEndPoint) {
        this.mOdpsEndPoint = odpsEndPoint;
    }

    public void setOdpsProject(String odpsProject) {
        this.mOdpsProject = odpsProject;
    }

    public void setOdpsTable(String odpsTable) {
        this.mOdpsTable = odpsTable;
    }

    public void setLogFieldsList(List<String> logFieldsList) {
        this.mLogFieldsList = logFieldsList;
    }

    public void setPartitionColumn(List<String> partitionColumn) {
        this.mPartitionColumn = partitionColumn;
    }

    public void setPartitionTimeFormat(String partitionTimeFormat) {
        this.mPartitionTimeFormat = partitionTimeFormat;
    }

    public void setBufferInterval(int mBufferInterval) {
        this.mBufferInterval = mBufferInterval;
    }

    @Override
    public JSONObject GetJsonObj() {
        JSONObject obj = new JSONObject();
        obj.put("odpsEndpoint", this.mOdpsEndPoint);
        obj.put("odpsProject", this.mOdpsProject);
        obj.put("odpsTable", this.mOdpsTable);
        obj.put("fields", this.mLogFieldsList);
        obj.put("partitionColumn", this.mPartitionColumn);
        obj.put("partitionTimeFormat", this.mPartitionTimeFormat);
        obj.put("bufferInterval", (Object)this.mBufferInterval);
        return obj;
    }

    private List<String> FromJsonArray(JSONArray jsonArray2) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < jsonArray2.size(); ++i) {
            list.add(jsonArray2.getString(i));
        }
        return list;
    }

    @Override
    public void FromJsonObj(JSONObject obj) throws LogException {
        try {
            this.mOdpsEndPoint = obj.getString("odpsEndpoint");
            this.mOdpsProject = obj.getString("odpsProject");
            this.mOdpsTable = obj.getString("odpsTable");
            this.mLogFieldsList = this.FromJsonArray(obj.getJSONArray("fields"));
            this.mPartitionColumn = this.FromJsonArray(obj.getJSONArray("partitionColumn"));
            this.mPartitionTimeFormat = obj.getString("partitionTimeFormat");
            this.mBufferInterval = obj.getInt("bufferInterval");
        }
        catch (JSONException e) {
            throw new LogException("FailToParseOssShipperConfig", e.getMessage(), e, "");
        }
    }
}

