/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.log.http.client;

import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.http.client.ClientConnectionContainer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ClientConnectionHelper {
    private Map<String, ClientConnectionContainer> mAllConnections = new ConcurrentHashMap<String, ClientConnectionContainer>();

    private ClientConnectionHelper() {
        new Thread(new ClientConnectionUpdateThread(this)).start();
    }

    public static ClientConnectionHelper getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public ClientConnectionContainer GetConnectionContainer(String endpoint, String accessId, String accessKey) {
        String key = endpoint + "#" + accessId;
        if (!this.mAllConnections.containsKey(key)) {
            ClientConnectionContainer container = new ClientConnectionContainer();
            container.Init(endpoint, accessId, accessKey);
            this.mAllConnections.put(key, container);
            return container;
        }
        return this.mAllConnections.get(key);
    }

    class ClientConnectionUpdateThread
    implements Runnable {
        ClientConnectionHelper mHelper;

        ClientConnectionUpdateThread(ClientConnectionHelper helper) {
            this.mHelper = helper;
        }

        @Override
        public void run() {
            while (true) {
                for (Map.Entry entry : this.mHelper.mAllConnections.entrySet()) {
                    ((ClientConnectionContainer)entry.getValue()).UpdateConnections();
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    private static class SingletonHolder {
        private static final ClientConnectionHelper INSTANCE = new ClientConnectionHelper();

        private SingletonHolder() {
        }
    }
}

