/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.log.http.comm;

import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.http.client.ClientException;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.http.client.HttpMethod;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.http.comm.RepeatableInputStreamEntity;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.http.comm.ServiceClient;
import com.alibaba.schedulerx.shade.org.apache.http.client.methods.HttpDelete;
import com.alibaba.schedulerx.shade.org.apache.http.client.methods.HttpGet;
import com.alibaba.schedulerx.shade.org.apache.http.client.methods.HttpHead;
import com.alibaba.schedulerx.shade.org.apache.http.client.methods.HttpOptions;
import com.alibaba.schedulerx.shade.org.apache.http.client.methods.HttpPost;
import com.alibaba.schedulerx.shade.org.apache.http.client.methods.HttpPut;
import com.alibaba.schedulerx.shade.org.apache.http.client.methods.HttpRequestBase;
import java.util.Map;

class HttpRequestFactory {
    HttpRequestFactory() {
    }

    public HttpRequestBase createHttpRequest(ServiceClient.Request request2, String charset) {
        HttpRequestBase httpRequest;
        String uri = request2.getUri();
        HttpMethod method = request2.getMethod();
        if (method == HttpMethod.POST) {
            HttpPost postMethod = new HttpPost(uri);
            if (request2.getContent() != null) {
                postMethod.setEntity(new RepeatableInputStreamEntity(request2));
            }
            httpRequest = postMethod;
        } else if (method == HttpMethod.PUT) {
            HttpPut putMethod = new HttpPut(uri);
            if (request2.getContent() != null) {
                putMethod.setEntity(new RepeatableInputStreamEntity(request2));
            }
            httpRequest = putMethod;
        } else if (method == HttpMethod.GET) {
            httpRequest = new HttpGet(uri);
        } else if (method == HttpMethod.DELETE) {
            httpRequest = new HttpDelete(uri);
        } else if (method == HttpMethod.HEAD) {
            httpRequest = new HttpHead(uri);
        } else if (method == HttpMethod.OPTIONS) {
            httpRequest = new HttpOptions(uri);
        } else {
            throw new ClientException("Unknown HTTP method name: " + method.toString());
        }
        this.configureRequestHeaders(request2, charset, httpRequest);
        return httpRequest;
    }

    private void configureRequestHeaders(ServiceClient.Request request2, String charset, HttpRequestBase httpRequest) {
        for (Map.Entry<String, String> entry : request2.getHeaders().entrySet()) {
            if (entry.getKey().equalsIgnoreCase("Content-Length")) continue;
            httpRequest.addHeader(entry.getKey(), entry.getValue());
        }
        if (httpRequest.getHeaders("Content-Type") == null || httpRequest.getHeaders("Content-Type").length == 0) {
            httpRequest.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + charset.toLowerCase());
        }
    }
}

