/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.log.http.comm;

import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.http.comm.ServiceClient;
import com.alibaba.schedulerx.shade.org.apache.http.entity.AbstractHttpEntity;
import com.alibaba.schedulerx.shade.org.apache.http.entity.BasicHttpEntity;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class RepeatableInputStreamEntity
extends BasicHttpEntity {
    private boolean firstAttempt = true;
    private NoAutoClosedInputStreamEntity innerEntity;
    private InputStream content;

    public RepeatableInputStreamEntity(ServiceClient.Request request2) {
        this.setChunked(false);
        String contentType = request2.getHeaders().get("Content-Type");
        this.content = request2.getContent();
        long contentLength = request2.getContentLength();
        this.innerEntity = new NoAutoClosedInputStreamEntity(this.content, contentLength);
        this.innerEntity.setContentType(contentType);
        this.setContent(this.content);
        this.setContentType(contentType);
        this.setContentLength(request2.getContentLength());
    }

    @Override
    public boolean isChunked() {
        return false;
    }

    @Override
    public boolean isRepeatable() {
        return this.content.markSupported() || this.innerEntity.isRepeatable();
    }

    @Override
    public void writeTo(OutputStream output) throws IOException {
        if (!this.firstAttempt && this.isRepeatable()) {
            this.content.reset();
        }
        this.firstAttempt = false;
        this.innerEntity.writeTo(output);
    }

    public static class NoAutoClosedInputStreamEntity
    extends AbstractHttpEntity {
        private static final int BUFFER_SIZE = 2048;
        private final InputStream content;
        private final long length;

        public NoAutoClosedInputStreamEntity(InputStream instream, long length) {
            if (instream == null) {
                throw new IllegalArgumentException("Source input stream may not be null");
            }
            this.content = instream;
            this.length = length;
        }

        @Override
        public boolean isRepeatable() {
            return false;
        }

        @Override
        public long getContentLength() {
            return this.length;
        }

        @Override
        public InputStream getContent() throws IOException {
            return this.content;
        }

        @Override
        public void writeTo(OutputStream outstream) throws IOException {
            if (outstream == null) {
                throw new IllegalArgumentException("Output stream may not be null");
            }
            InputStream instream = this.content;
            byte[] buffer = new byte[2048];
            if (this.length < 0L) {
                int l;
                while ((l = instream.read(buffer)) != -1) {
                    outstream.write(buffer, 0, l);
                }
            } else {
                int l;
                for (long remaining = this.length; remaining > 0L && (l = instream.read(buffer, 0, (int)Math.min(2048L, remaining))) != -1; remaining -= (long)l) {
                    outstream.write(buffer, 0, l);
                }
            }
        }

        @Override
        public boolean isStreaming() {
            return true;
        }
    }
}

