/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.log.http.comm;

import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.http.client.ClientConfiguration;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.http.client.ClientException;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.http.comm.DefaultServiceClient;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.http.comm.ResponseMessage;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.http.comm.ServiceClient;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.http.utils.ExceptionFactory;
import com.alibaba.schedulerx.shade.org.apache.http.client.methods.CloseableHttpResponse;
import com.alibaba.schedulerx.shade.org.apache.http.client.methods.HttpRequestBase;
import com.alibaba.schedulerx.shade.org.apache.http.client.methods.HttpUriRequest;
import com.alibaba.schedulerx.shade.org.apache.http.client.protocol.HttpClientContext;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TimeoutServiceClient
extends DefaultServiceClient {
    private ThreadPoolExecutor executor;

    public TimeoutServiceClient(ClientConfiguration config) {
        super(config);
        int processors = Runtime.getRuntime().availableProcessors();
        this.executor = this.createThreadPool(processors * 5, processors * 10, processors * 100);
    }

    public TimeoutServiceClient(ClientConfiguration config, int corePoolSize, int maximumPoolSize, int queueSize) {
        super(config);
        this.executor = this.createThreadPool(corePoolSize, maximumPoolSize, queueSize);
    }

    private ThreadPoolExecutor createThreadPool(int corePoolSize, int maximumPoolSize, int queueSize) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(queueSize), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    public TimeoutServiceClient(ClientConfiguration config, ThreadPoolExecutor executor) {
        super(config);
        this.executor = executor;
    }

    @Override
    public ResponseMessage sendRequestCore(ServiceClient.Request request2, String charset) throws IOException {
        HttpRequestBase httpRequest = httpRequestFactory.createHttpRequest(request2, charset);
        HttpClientContext httpContext = HttpClientContext.create();
        httpContext.setRequestConfig(this.requestConfig);
        CloseableHttpResponse httpResponse = null;
        HttpRequestTask httpRequestTask = new HttpRequestTask(httpRequest, httpContext);
        Future<CloseableHttpResponse> future2 = this.executor.submit(httpRequestTask);
        try {
            httpResponse = future2.get(this.config.getRequestTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            httpRequest.abort();
            throw new ClientException(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            httpRequest.abort();
            throw ExceptionFactory.createNetworkException((IOException)e.getCause());
        }
        catch (TimeoutException e) {
            httpRequest.abort();
            throw new ClientException(e.getMessage(), "RequestTimeout", "Unknown", e);
        }
        return TimeoutServiceClient.buildResponse(request2, httpResponse);
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(60000L, TimeUnit.MILLISECONDS)) {
                this.executor.shutdownNow();
                this.executor.awaitTermination(60000L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException ie) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
        super.shutdown();
    }

    class HttpRequestTask
    implements Callable<CloseableHttpResponse> {
        private HttpRequestBase httpRequest;
        private HttpClientContext httpContext;

        public HttpRequestTask(HttpRequestBase httpRequest, HttpClientContext httpContext) {
            this.httpRequest = httpRequest;
            this.httpContext = httpContext;
        }

        @Override
        public CloseableHttpResponse call() throws Exception {
            return TimeoutServiceClient.this.httpClient.execute((HttpUriRequest)this.httpRequest, this.httpContext);
        }
    }
}

