/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.log.response;

import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.LZ4Encoder;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.LogGroupData;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.exception.LogException;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.response.Response;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.util.Args;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.util.VarintUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PullLogsResponse
extends Response {
    private static final long serialVersionUID = -2027711570684362279L;
    private List<LogGroupData> logGroups = new ArrayList<LogGroupData>();
    private int rawSize;
    private int count;

    public PullLogsResponse(Map<String, String> headers) {
        super(headers);
    }

    public PullLogsResponse(Map<String, String> headers, byte[] rawData) throws LogException {
        this(headers);
        try {
            this.rawSize = Integer.parseInt(headers.get("x-log-bodyrawsize"));
            if (this.rawSize > 0) {
                byte[] uncompressedData = LZ4Encoder.decompressFromLhLz4Chunk(rawData, this.rawSize);
                this.parseFastLogGroupList(uncompressedData);
            }
            this.count = Integer.parseInt(this.GetHeader("x-log-count"));
        }
        catch (NumberFormatException e) {
            throw new LogException("ParseLogGroupListRawSizeError", e.getMessage(), e, this.GetRequestId());
        }
        if (this.logGroups.size() != this.count) {
            throw new LogException("LogGroupCountNotMatch", "LogGroup count does match with the count in header message", this.GetRequestId());
        }
    }

    public int getRawSize() {
        return this.rawSize;
    }

    private void parseFastLogGroupList(byte[] uncompressedData) throws LogException {
        int pos = 0;
        int rawSize = uncompressedData.length;
        while (pos < rawSize) {
            int[] value2 = VarintUtil.DecodeVarInt32(uncompressedData, pos, rawSize);
            if (value2[0] == 0) {
                throw new LogException("InitLogGroupsError", "decode varint32 error", this.GetRequestId());
            }
            pos = value2[2];
            int mode = value2[1] & 7;
            int index2 = value2[1] >> 3;
            if (mode == 0) {
                value2 = VarintUtil.DecodeVarInt32(uncompressedData, pos, rawSize);
                if (value2[0] == 0) {
                    throw new LogException("InitLogGroupsError", "decode varint32 error", this.GetRequestId());
                }
                pos = value2[2];
                continue;
            }
            if (mode == 1) {
                pos += 8;
                continue;
            }
            if (mode == 2) {
                value2 = VarintUtil.DecodeVarInt32(uncompressedData, pos, rawSize);
                if (value2[0] == 0) {
                    throw new LogException("InitLogGroupsError", "decode varint32 error", this.GetRequestId());
                }
                if (index2 == 1) {
                    this.logGroups.add(new LogGroupData(uncompressedData, value2[2], value2[1], this.GetRequestId()));
                }
                pos = value2[1] + value2[2];
                continue;
            }
            if (mode == 5) {
                pos += 4;
                continue;
            }
            throw new LogException("InitLogGroupsError", "mode: " + mode, this.GetRequestId());
        }
        if (pos != rawSize) {
            throw new LogException("InitLogGroupsError", "parse LogGroupList fail", this.GetRequestId());
        }
    }

    public String getNextCursor() {
        return this.GetHeader("x-log-cursor");
    }

    public int getCount() {
        return this.count;
    }

    public LogGroupData getLogGroup(int index2) {
        Args.check(this.count > 0, "No LogGroups in response");
        Args.check(index2 >= 0 && index2 < this.count, "index out of range [0, " + this.count + ")");
        return this.logGroups.get(index2);
    }

    public List<LogGroupData> getLogGroups(int offset) {
        Args.check(this.count > 0, "No LogGroups in response");
        Args.check(offset >= 0 && offset < this.count, "offset out of range [0, " + this.count + ")");
        return this.logGroups.subList(offset, this.count);
    }

    public List<LogGroupData> getLogGroups() {
        return this.logGroups;
    }
}

