/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.log.sample;

import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.Client;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.Consts;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.LogContent;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.LogGroupData;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.LogItem;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.Shard;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.exception.LogException;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.request.PullLogsRequest;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.response.GetCursorResponse;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.response.ListShardResponse;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.response.PullLogsResponse;
import java.util.ArrayList;
import java.util.List;

class ClientSample {
    private final String endPoint = "";
    private final String akId = "your_access_id";
    private final String ak = "your_access_key";
    private final Client client = new Client("", "your_access_id", "your_access_key");
    private final String project = "your_project_name";
    private final String logStore = "your_log_store";
    private final int defaultShardNum = 10;

    public void getCursor() {
        int shardId = 1;
        try {
            long fromTime = (int)((double)System.currentTimeMillis() / 1000.0 - 3600.0);
            GetCursorResponse res = this.client.GetCursor("your_project_name", "your_log_store", shardId, fromTime);
            System.out.println("Cursor:" + res.GetCursor());
            res = this.client.GetCursor("your_project_name", "your_log_store", shardId, Consts.CursorMode.BEGIN);
            System.out.println("Cursor:" + res.GetCursor());
            res = this.client.GetCursor("your_project_name", "your_log_store", shardId, Consts.CursorMode.END);
            System.out.println("shard_id:" + shardId + " Cursor:" + res.GetCursor());
        }
        catch (LogException e) {
            e.printStackTrace();
        }
    }

    public void pullLogs() {
        try {
            block2: for (int i = 0; i < 10; ++i) {
                GetCursorResponse cursorRes = this.client.GetCursor("your_project_name", "your_log_store", i, Consts.CursorMode.BEGIN);
                String cursor = cursorRes.GetCursor();
                for (int j = 0; j < 5; ++j) {
                    PullLogsRequest request2 = new PullLogsRequest("your_project_name", "your_log_store", i, 5, cursor);
                    PullLogsResponse response = this.client.pullLogs(request2);
                    String next_cursor = response.getNextCursor();
                    System.out.print("The Next cursor:" + next_cursor);
                    List<LogGroupData> logGroups = response.getLogGroups();
                    for (LogGroupData logGroup : logGroups) {
                        System.out.println("Source:" + logGroup.GetSource());
                        System.out.println("Topic:" + logGroup.GetTopic());
                        for (LogItem log2 : logGroup.GetAllLogs()) {
                            System.out.println("LogTime:" + log2.GetTime());
                            ArrayList<LogContent> contents = log2.GetLogContents();
                            for (LogContent content : contents) {
                                System.out.println(content.GetKey() + ":" + content.GetValue());
                            }
                        }
                    }
                    if (cursor.equals(next_cursor)) continue block2;
                    cursor = next_cursor;
                }
            }
        }
        catch (LogException e) {
            e.printStackTrace();
        }
    }

    public void listShard() {
        try {
            ListShardResponse res = this.client.ListShard("your_project_name", "your_log_store");
            System.out.println("RequestId:" + res.GetRequestId());
            Shard shard = res.GetShards().get(0);
            System.out.println("ShardId:" + shard.GetShardId());
        }
        catch (LogException e) {
            e.printStackTrace();
        }
    }
}

