/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.google.common.collect;

import com.alibaba.schedulerx.shade.com.google.common.annotations.GwtCompatible;
import com.alibaba.schedulerx.shade.com.google.common.base.Objects;
import com.alibaba.schedulerx.shade.com.google.common.base.Preconditions;
import com.alibaba.schedulerx.shade.com.google.common.collect.Hashing;
import com.alibaba.schedulerx.shade.com.google.common.collect.ImmutableList;
import com.alibaba.schedulerx.shade.com.google.common.collect.ImmutableMultiset;
import com.alibaba.schedulerx.shade.com.google.common.collect.ImmutableSet;
import com.alibaba.schedulerx.shade.com.google.common.collect.Multiset;
import com.alibaba.schedulerx.shade.com.google.common.collect.Multisets;
import com.alibaba.schedulerx.shade.com.google.common.primitives.Ints;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.util.Collection;
import javax.annotation.Nullable;

@GwtCompatible(serializable=true)
class RegularImmutableMultiset<E>
extends ImmutableMultiset<E> {
    static final RegularImmutableMultiset<Object> EMPTY = new RegularImmutableMultiset(ImmutableList.of());
    private final transient Multisets.ImmutableEntry<E>[] entries;
    private final transient Multisets.ImmutableEntry<E>[] hashTable;
    private final transient int size;
    private final transient int hashCode;
    @LazyInit
    private transient ImmutableSet<E> elementSet;

    RegularImmutableMultiset(Collection<? extends Multiset.Entry<? extends E>> entries) {
        int distinct2 = entries.size();
        Multisets.ImmutableEntry[] entryArray = new Multisets.ImmutableEntry[distinct2];
        if (distinct2 == 0) {
            this.entries = entryArray;
            this.hashTable = null;
            this.size = 0;
            this.hashCode = 0;
            this.elementSet = ImmutableSet.of();
        } else {
            int tableSize = Hashing.closedTableSize(distinct2, 1.0);
            int mask = tableSize - 1;
            Multisets.ImmutableEntry[] hashTable = new Multisets.ImmutableEntry[tableSize];
            int index2 = 0;
            int hashCode = 0;
            long size2 = 0L;
            for (Multiset.Entry<E> entry : entries) {
                Multisets.ImmutableEntry newEntry;
                E element = Preconditions.checkNotNull(entry.getElement());
                int count2 = entry.getCount();
                int hash2 = element.hashCode();
                int bucket = Hashing.smear(hash2) & mask;
                Multisets.ImmutableEntry bucketHead = hashTable[bucket];
                if (bucketHead == null) {
                    boolean canReuseEntry = entry instanceof Multisets.ImmutableEntry && !(entry instanceof NonTerminalEntry);
                    newEntry = canReuseEntry ? (Multisets.ImmutableEntry)entry : new Multisets.ImmutableEntry<E>(element, count2);
                } else {
                    newEntry = new NonTerminalEntry<E>(element, count2, bucketHead);
                }
                hashCode += hash2 ^ count2;
                entryArray[index2++] = newEntry;
                hashTable[bucket] = newEntry;
                size2 += (long)count2;
            }
            this.entries = entryArray;
            this.hashTable = hashTable;
            this.size = Ints.saturatedCast(size2);
            this.hashCode = hashCode;
        }
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public int count(@Nullable Object element) {
        Multisets.ImmutableEntry<E>[] hashTable = this.hashTable;
        if (element == null || hashTable == null) {
            return 0;
        }
        int hash2 = Hashing.smearedHash(element);
        int mask = hashTable.length - 1;
        for (Multisets.ImmutableEntry<E> entry = hashTable[hash2 & mask]; entry != null; entry = entry.nextInBucket()) {
            if (!Objects.equal(element, entry.getElement())) continue;
            return entry.getCount();
        }
        return 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public ImmutableSet<E> elementSet() {
        ElementSet result2 = this.elementSet;
        return result2 == null ? (this.elementSet = new ElementSet()) : result2;
    }

    @Override
    Multiset.Entry<E> getEntry(int index2) {
        return this.entries[index2];
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    private final class ElementSet
    extends ImmutableSet.Indexed<E> {
        private ElementSet() {
        }

        @Override
        E get(int index2) {
            return RegularImmutableMultiset.this.entries[index2].getElement();
        }

        @Override
        public boolean contains(@Nullable Object object) {
            return RegularImmutableMultiset.this.contains(object);
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        public int size() {
            return RegularImmutableMultiset.this.entries.length;
        }
    }

    private static final class NonTerminalEntry<E>
    extends Multisets.ImmutableEntry<E> {
        private final Multisets.ImmutableEntry<E> nextInBucket;

        NonTerminalEntry(E element, int count2, Multisets.ImmutableEntry<E> nextInBucket) {
            super(element, count2);
            this.nextInBucket = nextInBucket;
        }

        @Override
        public Multisets.ImmutableEntry<E> nextInBucket() {
            return this.nextInBucket;
        }
    }
}

