/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.google.gson.internal.bind;

import com.alibaba.schedulerx.shade.com.google.gson.Gson;
import com.alibaba.schedulerx.shade.com.google.gson.TypeAdapter;
import com.alibaba.schedulerx.shade.com.google.gson.TypeAdapterFactory;
import com.alibaba.schedulerx.shade.com.google.gson.internal.LinkedTreeMap;
import com.alibaba.schedulerx.shade.com.google.gson.reflect.TypeToken;
import com.alibaba.schedulerx.shade.com.google.gson.stream.JsonReader;
import com.alibaba.schedulerx.shade.com.google.gson.stream.JsonToken;
import com.alibaba.schedulerx.shade.com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;

public final class ObjectTypeAdapter
extends TypeAdapter<Object> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (type.getRawType() == Object.class) {
                return new ObjectTypeAdapter(gson);
            }
            return null;
        }
    };
    private final Gson gson;

    ObjectTypeAdapter(Gson gson) {
        this.gson = gson;
    }

    @Override
    public Object read(JsonReader in2) throws IOException {
        JsonToken token2 = in2.peek();
        switch (token2) {
            case BEGIN_ARRAY: {
                ArrayList<Object> list = new ArrayList<Object>();
                in2.beginArray();
                while (in2.hasNext()) {
                    list.add(this.read(in2));
                }
                in2.endArray();
                return list;
            }
            case BEGIN_OBJECT: {
                LinkedTreeMap<String, Object> map2 = new LinkedTreeMap<String, Object>();
                in2.beginObject();
                while (in2.hasNext()) {
                    map2.put(in2.nextName(), this.read(in2));
                }
                in2.endObject();
                return map2;
            }
            case STRING: {
                return in2.nextString();
            }
            case NUMBER: {
                return in2.nextDouble();
            }
            case BOOLEAN: {
                return in2.nextBoolean();
            }
            case NULL: {
                in2.nextNull();
                return null;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void write(JsonWriter out, Object value2) throws IOException {
        if (value2 == null) {
            out.nullValue();
            return;
        }
        TypeAdapter<?> typeAdapter = this.gson.getAdapter(value2.getClass());
        if (typeAdapter instanceof ObjectTypeAdapter) {
            out.beginObject();
            out.endObject();
            return;
        }
        typeAdapter.write(out, value2);
    }
}

