/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.mashape.unirest.http;

import com.alibaba.schedulerx.shade.com.mashape.unirest.http.HttpDeleteWithBody;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.HttpMethod;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.HttpPatchWithBody;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.HttpResponse;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.async.Callback;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.async.utils.AsyncIdleConnectionMonitorThread;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.exceptions.UnirestException;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.options.Option;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.options.Options;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.utils.ClientFactory;
import com.alibaba.schedulerx.shade.com.mashape.unirest.request.HttpRequest;
import com.alibaba.schedulerx.shade.org.apache.http.HttpEntity;
import com.alibaba.schedulerx.shade.org.apache.http.client.HttpClient;
import com.alibaba.schedulerx.shade.org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import com.alibaba.schedulerx.shade.org.apache.http.client.methods.HttpGet;
import com.alibaba.schedulerx.shade.org.apache.http.client.methods.HttpHead;
import com.alibaba.schedulerx.shade.org.apache.http.client.methods.HttpOptions;
import com.alibaba.schedulerx.shade.org.apache.http.client.methods.HttpPost;
import com.alibaba.schedulerx.shade.org.apache.http.client.methods.HttpPut;
import com.alibaba.schedulerx.shade.org.apache.http.client.methods.HttpRequestBase;
import com.alibaba.schedulerx.shade.org.apache.http.concurrent.FutureCallback;
import com.alibaba.schedulerx.shade.org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import com.alibaba.schedulerx.shade.org.apache.http.nio.entity.NByteArrayEntity;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClientHelper {
    private static final String CONTENT_TYPE = "content-type";
    private static final String ACCEPT_ENCODING_HEADER = "accept-encoding";
    private static final String USER_AGENT_HEADER = "user-agent";
    private static final String USER_AGENT = "unirest-java/1.3.11";

    private static <T> FutureCallback<com.alibaba.schedulerx.shade.org.apache.http.HttpResponse> prepareCallback(final Class<T> responseClass, final Callback<T> callback) {
        if (callback == null) {
            return null;
        }
        return new FutureCallback<com.alibaba.schedulerx.shade.org.apache.http.HttpResponse>(){

            @Override
            public void cancelled() {
                callback.cancelled();
            }

            @Override
            public void completed(com.alibaba.schedulerx.shade.org.apache.http.HttpResponse arg0) {
                callback.completed(new HttpResponse(arg0, responseClass));
            }

            @Override
            public void failed(Exception arg0) {
                callback.failed(new UnirestException(arg0));
            }
        };
    }

    public static <T> Future<HttpResponse<T>> requestAsync(HttpRequest request2, final Class<T> responseClass, Callback<T> callback) {
        HttpRequestBase requestObj = HttpClientHelper.prepareRequest(request2, true);
        CloseableHttpAsyncClient asyncHttpClient = ClientFactory.getAsyncHttpClient();
        if (!asyncHttpClient.isRunning()) {
            asyncHttpClient.start();
            AsyncIdleConnectionMonitorThread asyncIdleConnectionMonitorThread = (AsyncIdleConnectionMonitorThread)Options.getOption(Option.ASYNC_MONITOR);
            asyncIdleConnectionMonitorThread.start();
        }
        final Future<com.alibaba.schedulerx.shade.org.apache.http.HttpResponse> future2 = asyncHttpClient.execute(requestObj, HttpClientHelper.prepareCallback(responseClass, callback));
        return new Future<HttpResponse<T>>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return future2.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return future2.isCancelled();
            }

            @Override
            public boolean isDone() {
                return future2.isDone();
            }

            @Override
            public HttpResponse<T> get() throws InterruptedException, ExecutionException {
                com.alibaba.schedulerx.shade.org.apache.http.HttpResponse httpResponse = (com.alibaba.schedulerx.shade.org.apache.http.HttpResponse)future2.get();
                return new HttpResponse(httpResponse, responseClass);
            }

            @Override
            public HttpResponse<T> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                com.alibaba.schedulerx.shade.org.apache.http.HttpResponse httpResponse = (com.alibaba.schedulerx.shade.org.apache.http.HttpResponse)future2.get(timeout, unit);
                return new HttpResponse(httpResponse, responseClass);
            }
        };
    }

    public static <T> HttpResponse<T> request(HttpRequest request2, Class<T> responseClass) throws UnirestException {
        HttpRequestBase requestObj = HttpClientHelper.prepareRequest(request2, false);
        HttpClient client = ClientFactory.getHttpClient();
        try {
            com.alibaba.schedulerx.shade.org.apache.http.HttpResponse response = client.execute(requestObj);
            HttpResponse<T> httpResponse = new HttpResponse<T>(response, responseClass);
            requestObj.releaseConnection();
            HttpResponse<T> httpResponse2 = httpResponse;
            return httpResponse2;
        }
        catch (Exception e) {
            throw new UnirestException(e);
        }
        finally {
            requestObj.releaseConnection();
        }
    }

    private static HttpRequestBase prepareRequest(HttpRequest request2, boolean async) {
        Object defaultHeaders = Options.getOption(Option.DEFAULT_HEADERS);
        if (defaultHeaders != null) {
            Set entrySet = ((Map)defaultHeaders).entrySet();
            for (Map.Entry entry : entrySet) {
                request2.header((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (!request2.getHeaders().containsKey(USER_AGENT_HEADER)) {
            request2.header(USER_AGENT_HEADER, USER_AGENT);
        }
        if (!request2.getHeaders().containsKey(ACCEPT_ENCODING_HEADER)) {
            request2.header(ACCEPT_ENCODING_HEADER, "gzip");
        }
        HttpRequestBase reqObj = null;
        String urlToRequest = null;
        try {
            URL url = new URL(request2.getUrl());
            URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), URLDecoder.decode(url.getPath(), "UTF-8"), "", url.getRef());
            urlToRequest = uri.toURL().toString();
            if (url.getQuery() != null && !url.getQuery().trim().equals("")) {
                if (!urlToRequest.substring(urlToRequest.length() - 1).equals("?")) {
                    urlToRequest = urlToRequest + "?";
                }
                urlToRequest = urlToRequest + url.getQuery();
            } else if (urlToRequest.substring(urlToRequest.length() - 1).equals("?")) {
                urlToRequest = urlToRequest.substring(0, urlToRequest.length() - 1);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        switch (request2.getHttpMethod()) {
            case GET: {
                reqObj = new HttpGet(urlToRequest);
                break;
            }
            case POST: {
                reqObj = new HttpPost(urlToRequest);
                break;
            }
            case PUT: {
                reqObj = new HttpPut(urlToRequest);
                break;
            }
            case DELETE: {
                reqObj = new HttpDeleteWithBody(urlToRequest);
                break;
            }
            case PATCH: {
                reqObj = new HttpPatchWithBody(urlToRequest);
                break;
            }
            case OPTIONS: {
                reqObj = new HttpOptions(urlToRequest);
                break;
            }
            case HEAD: {
                reqObj = new HttpHead(urlToRequest);
            }
        }
        Set<Map.Entry<String, List<String>>> entrySet = request2.getHeaders().entrySet();
        for (Map.Entry entry : entrySet) {
            List values2 = (List)entry.getValue();
            if (values2 == null) continue;
            for (String value2 : values2) {
                reqObj.addHeader((String)entry.getKey(), value2);
            }
        }
        if (request2.getHttpMethod() != HttpMethod.GET && request2.getHttpMethod() != HttpMethod.HEAD && request2.getBody() != null) {
            HttpEntity entity = request2.getBody().getEntity();
            if (async) {
                if (reqObj.getHeaders(CONTENT_TYPE) == null || reqObj.getHeaders(CONTENT_TYPE).length == 0) {
                    reqObj.setHeader(entity.getContentType());
                }
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    entity.writeTo(byteArrayOutputStream);
                    NByteArrayEntity en = new NByteArrayEntity(byteArrayOutputStream.toByteArray());
                    ((HttpEntityEnclosingRequestBase)reqObj).setEntity(en);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            } else {
                ((HttpEntityEnclosingRequestBase)reqObj).setEntity(entity);
            }
        }
        return reqObj;
    }
}

