/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.mashape.unirest.request;

import com.alibaba.schedulerx.shade.com.mashape.unirest.http.HttpMethod;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.utils.Base64Coder;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.utils.URLParamEncoder;
import com.alibaba.schedulerx.shade.com.mashape.unirest.request.BaseRequest;
import com.alibaba.schedulerx.shade.com.mashape.unirest.request.body.Body;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequest
extends BaseRequest {
    private HttpMethod httpMethod;
    protected String url;
    Map<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
    protected Body body;

    public HttpRequest(HttpMethod method, String url) {
        this.httpMethod = method;
        this.url = url;
        this.httpRequest = this;
    }

    public HttpRequest routeParam(String name, String value2) {
        Matcher matcher = Pattern.compile("\\{" + name + "\\}").matcher(this.url);
        int count2 = 0;
        while (matcher.find()) {
            ++count2;
        }
        if (count2 == 0) {
            throw new RuntimeException("Can't find route parameter name \"" + name + "\"");
        }
        this.url = this.url.replaceAll("\\{" + name + "\\}", URLParamEncoder.encode(value2));
        return this;
    }

    public HttpRequest basicAuth(String username, String password) {
        this.header("Authorization", "Basic " + Base64Coder.encodeString(username + ":" + password));
        return this;
    }

    public HttpRequest header(String name, String value2) {
        List<String> list = this.headers.get(name.trim());
        if (list == null) {
            list = new ArrayList<String>();
        }
        list.add(value2);
        this.headers.put(name.trim(), list);
        return this;
    }

    public HttpRequest headers(Map<String, String> headers) {
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                this.header(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    public HttpRequest queryString(String name, Collection<?> value2) {
        for (Object cur : value2) {
            this.queryString(name, cur);
        }
        return this;
    }

    public HttpRequest queryString(String name, Object value2) {
        StringBuilder queryString = new StringBuilder();
        if (this.url.contains("?")) {
            queryString.append("&");
        } else {
            queryString.append("?");
        }
        try {
            queryString.append(URLEncoder.encode(name)).append("=").append(URLEncoder.encode(value2 == null ? "" : value2.toString(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.url = this.url + queryString.toString();
        return this;
    }

    public HttpRequest queryString(Map<String, Object> parameters) {
        if (parameters != null) {
            for (Map.Entry<String, Object> param2 : parameters.entrySet()) {
                if (param2.getValue() instanceof String || param2.getValue() instanceof Number || param2.getValue() instanceof Boolean) {
                    this.queryString(param2.getKey(), param2.getValue());
                    continue;
                }
                throw new RuntimeException("Parameter \"" + param2.getKey() + "\" can't be sent with a GET request because of type: " + param2.getValue().getClass().getName());
            }
        }
        return this;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, List<String>> getHeaders() {
        if (this.headers == null) {
            return new HashMap<String, List<String>>();
        }
        return this.headers;
    }

    public Body getBody() {
        return this.body;
    }
}

