/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.zaxxer.hikari.hibernate;

import com.alibaba.schedulerx.shade.com.zaxxer.hikari.HikariConfig;
import java.util.Map;
import java.util.Properties;

public class HikariConfigurationUtil {
    public static final String CONFIG_PREFIX = "hibernate.hikari.";
    public static final String CONFIG_PREFIX_DATASOURCE = "hibernate.hikari.dataSource.";

    public static HikariConfig loadConfiguration(Map props2) {
        Properties hikariProps = new Properties();
        HikariConfigurationUtil.copyProperty("hibernate.connection.isolation", props2, "transactionIsolation", hikariProps);
        HikariConfigurationUtil.copyProperty("hibernate.connection.autocommit", props2, "autoCommit", hikariProps);
        HikariConfigurationUtil.copyProperty("hibernate.connection.driver_class", props2, "driverClassName", hikariProps);
        HikariConfigurationUtil.copyProperty("hibernate.connection.url", props2, "jdbcUrl", hikariProps);
        HikariConfigurationUtil.copyProperty("hibernate.connection.username", props2, "username", hikariProps);
        HikariConfigurationUtil.copyProperty("hibernate.connection.password", props2, "password", hikariProps);
        for (Object keyo : props2.keySet()) {
            String key = (String)keyo;
            if (!key.startsWith(CONFIG_PREFIX)) continue;
            hikariProps.setProperty(key.substring(CONFIG_PREFIX.length()), (String)props2.get(key));
        }
        return new HikariConfig(hikariProps);
    }

    private static void copyProperty(String srcKey, Map src, String dstKey, Properties dst) {
        if (src.containsKey(srcKey)) {
            dst.setProperty(dstKey, (String)src.get(srcKey));
        }
    }
}

