/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.hsf.hessian.io;

import com.alibaba.schedulerx.shade.hsf.hessian.io.Hessian2Input;
import com.alibaba.schedulerx.shade.hsf.hessian.io.Hessian2Output;
import com.alibaba.schedulerx.shade.hsf.hessian.io.Hessian2StreamingInput;
import com.alibaba.schedulerx.shade.hsf.hessian.io.Hessian2StreamingOutput;
import com.alibaba.schedulerx.shade.hsf.hessian.io.HessianDebugOutputStream;
import com.alibaba.schedulerx.shade.hsf.hessian.io.HessianInput;
import com.alibaba.schedulerx.shade.hsf.hessian.io.HessianOutput;
import com.alibaba.schedulerx.shade.hsf.hessian.io.SerializerFactory;
import com.alibaba.schedulerx.shade.hsf.hessian.util.HessianFreeList;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HessianFactory {
    public static final Logger log = Logger.getLogger(HessianFactory.class.getName());
    private SerializerFactory _serializerFactory;
    private SerializerFactory _defaultSerializerFactory;
    private final HessianFreeList<Hessian2Output> _freeHessian2Output = new HessianFreeList(32);
    private final HessianFreeList<HessianOutput> _freeHessianOutput = new HessianFreeList(32);
    private final HessianFreeList<Hessian2Input> _freeHessian2Input = new HessianFreeList(32);
    private final HessianFreeList<HessianInput> _freeHessianInput = new HessianFreeList(32);

    public HessianFactory() {
        this._serializerFactory = this._defaultSerializerFactory = SerializerFactory.createDefault();
    }

    public void setSerializerFactory(SerializerFactory factory) {
        this._serializerFactory = factory;
    }

    public SerializerFactory getSerializerFactory() {
        if (this._serializerFactory == this._defaultSerializerFactory) {
            this._serializerFactory = new SerializerFactory();
        }
        return this._serializerFactory;
    }

    public Hessian2Input createHessian2Input(InputStream is) {
        Hessian2Input in2 = new Hessian2Input(is);
        in2.setSerializerFactory(this._serializerFactory);
        return in2;
    }

    public void freeHessian2Input(Hessian2Input in2) {
    }

    public Hessian2StreamingInput createHessian2StreamingInput(InputStream is) {
        Hessian2StreamingInput in2 = new Hessian2StreamingInput(is);
        in2.setSerializerFactory(this._serializerFactory);
        return in2;
    }

    public void freeHessian2StreamingInput(Hessian2StreamingInput in2) {
    }

    public HessianInput createHessianInput(InputStream is) {
        return new HessianInput(is);
    }

    public Hessian2Output createHessian2Output(OutputStream os) {
        Hessian2Output out = this._freeHessian2Output.allocate();
        if (out != null) {
            out.init(os);
        } else {
            out = new Hessian2Output(os);
        }
        out.setSerializerFactory(this._serializerFactory);
        return out;
    }

    public void freeHessian2Output(Hessian2Output out) {
        if (out == null) {
            return;
        }
        out.free();
        this._freeHessian2Output.free(out);
    }

    public Hessian2StreamingOutput createHessian2StreamingOutput(OutputStream os) {
        Hessian2Output out = this.createHessian2Output(os);
        return new Hessian2StreamingOutput(out);
    }

    public void freeHessian2StreamingOutput(Hessian2StreamingOutput out) {
        if (out == null) {
            return;
        }
        this.freeHessian2Output(out.getHessian2Output());
    }

    public HessianOutput createHessianOutput(OutputStream os) {
        return new HessianOutput(os);
    }

    public OutputStream createHessian2DebugOutput(OutputStream os, Logger log2, Level level) {
        HessianDebugOutputStream out = new HessianDebugOutputStream(os, log2, level);
        out.startTop2();
        return out;
    }
}

