/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.hsf.hessian.io;

import com.alibaba.schedulerx.shade.hsf.hessian.HessianException;
import com.alibaba.schedulerx.shade.hsf.hessian.io.AbstractDeserializer;
import com.alibaba.schedulerx.shade.hsf.hessian.io.AbstractHessianInput;
import com.alibaba.schedulerx.shade.hsf.hessian.io.IOExceptionWrapper;
import java.io.IOException;
import java.lang.reflect.Constructor;

public class SqlDateDeserializer
extends AbstractDeserializer {
    private Class _cl;
    private Constructor _constructor;

    public SqlDateDeserializer(Class cl) {
        try {
            this._cl = cl;
            this._constructor = cl.getConstructor(Long.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new HessianException(e);
        }
    }

    public Class getType() {
        return this._cl;
    }

    @Override
    public Object readMap(AbstractHessianInput in2) throws IOException {
        int ref = in2.addRef(null);
        long initValue = Long.MIN_VALUE;
        while (!in2.isEnd()) {
            String key = in2.readString();
            if (key.equals("value")) {
                initValue = in2.readUTCDate();
                continue;
            }
            in2.readString();
        }
        in2.readMapEnd();
        Object value2 = this.create(initValue);
        in2.setRef(ref, value2);
        return value2;
    }

    @Override
    public Object readObject(AbstractHessianInput in2, Object[] fields) throws IOException {
        String[] fieldNames = (String[])fields;
        int ref = in2.addRef(null);
        long initValue = Long.MIN_VALUE;
        for (int i = 0; i < fieldNames.length; ++i) {
            String key = fieldNames[i];
            if (key.equals("value")) {
                initValue = in2.readUTCDate();
                continue;
            }
            in2.readObject();
        }
        Object value2 = this.create(initValue);
        in2.setRef(ref, value2);
        return value2;
    }

    private Object create(long initValue) throws IOException {
        if (initValue == Long.MIN_VALUE) {
            throw new IOException(this._cl.getName() + " expects name.");
        }
        try {
            return this._constructor.newInstance(new Long(initValue));
        }
        catch (Exception e) {
            throw new IOExceptionWrapper(e);
        }
    }
}

