/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.hsf.hessian.io;

import com.alibaba.schedulerx.shade.hsf.hessian.io.AbstractHessianOutput;
import com.alibaba.schedulerx.shade.hsf.hessian.io.AbstractSerializer;
import com.alibaba.schedulerx.shade.hsf.hessian.io.IOExceptionWrapper;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.misc.Unsafe;

public class UnsafeSerializer
extends AbstractSerializer {
    private static final Logger log = Logger.getLogger(UnsafeSerializer.class.getName());
    private static boolean _isEnabled;
    private static Unsafe _unsafe;
    private static final WeakHashMap<Class<?>, SoftReference<UnsafeSerializer>> _serializerMap;
    private static Object[] NULL_ARGS;
    private Field[] _fields;
    private FieldSerializer[] _fieldSerializers;

    public static boolean isEnabled() {
        return _isEnabled;
    }

    public UnsafeSerializer(Class<?> cl) {
        this.introspect(cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UnsafeSerializer create(Class<?> cl) {
        ClassLoader loader = cl.getClassLoader();
        WeakHashMap<Class<?>, SoftReference<UnsafeSerializer>> weakHashMap = _serializerMap;
        synchronized (weakHashMap) {
            UnsafeSerializer base;
            SoftReference<UnsafeSerializer> baseRef = _serializerMap.get(cl);
            UnsafeSerializer unsafeSerializer = base = baseRef != null ? baseRef.get() : null;
            if (base == null) {
                base = new UnsafeSerializer(cl);
                baseRef = new SoftReference<UnsafeSerializer>(base);
                _serializerMap.put(cl, baseRef);
            }
            return base;
        }
    }

    protected void introspect(Class<?> cl) {
        int i;
        Object fields;
        ArrayList<Object> primitiveFields = new ArrayList<Object>();
        ArrayList<Object> compoundFields = new ArrayList<Object>();
        while (cl != null) {
            fields = cl.getDeclaredFields();
            for (i = 0; i < ((Object)fields).length; ++i) {
                Object field2 = fields[i];
                if (Modifier.isTransient(((Field)field2).getModifiers()) || Modifier.isStatic(((Field)field2).getModifiers())) continue;
                ((Field)field2).setAccessible(true);
                if (((Field)field2).getType().isPrimitive() || ((Field)field2).getType().getName().startsWith("java.lang.") && !((Field)field2).getType().equals(Object.class)) {
                    primitiveFields.add(field2);
                    continue;
                }
                compoundFields.add(field2);
            }
            cl = cl.getSuperclass();
        }
        fields = new ArrayList();
        ((ArrayList)fields).addAll(primitiveFields);
        ((ArrayList)fields).addAll(compoundFields);
        this._fields = new Field[((ArrayList)fields).size()];
        ((ArrayList)fields).toArray(this._fields);
        this._fieldSerializers = new FieldSerializer[this._fields.length];
        for (i = 0; i < this._fields.length; ++i) {
            this._fieldSerializers[i] = UnsafeSerializer.getFieldSerializer(this._fields[i]);
        }
    }

    @Override
    public void writeObject(Object obj, AbstractHessianOutput out) throws IOException {
        if (out.addRef(obj)) {
            return;
        }
        Class<?> cl = obj.getClass();
        int ref = out.writeObjectBegin(cl.getName());
        if (ref >= 0) {
            this.writeInstance(obj, out);
        } else if (ref == -1) {
            this.writeDefinition20(out);
            out.writeObjectBegin(cl.getName());
            this.writeInstance(obj, out);
        } else {
            this.writeObject10(obj, out);
        }
    }

    @Override
    protected void writeObject10(Object obj, AbstractHessianOutput out) throws IOException {
        for (int i = 0; i < this._fields.length; ++i) {
            Field field2 = this._fields[i];
            out.writeString(field2.getName());
            this._fieldSerializers[i].serialize(out, obj);
        }
        out.writeMapEnd();
    }

    private void writeDefinition20(AbstractHessianOutput out) throws IOException {
        out.writeClassFieldLength(this._fields.length);
        for (int i = 0; i < this._fields.length; ++i) {
            Field field2 = this._fields[i];
            out.writeString(field2.getName());
        }
    }

    @Override
    public final void writeInstance(Object obj, AbstractHessianOutput out) throws IOException {
        try {
            FieldSerializer[] fieldSerializers = this._fieldSerializers;
            int length = fieldSerializers.length;
            for (int i = 0; i < length; ++i) {
                fieldSerializers[i].serialize(out, obj);
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage() + "\n class: " + obj.getClass().getName() + " (object=" + obj + ")", e);
        }
        catch (IOException e) {
            throw new IOExceptionWrapper(e.getMessage() + "\n class: " + obj.getClass().getName() + " (object=" + obj + ")", e);
        }
    }

    private static FieldSerializer getFieldSerializer(Field field2) {
        Class<?> type = field2.getType();
        if (Boolean.TYPE.equals(type)) {
            return new BooleanFieldSerializer(field2);
        }
        if (Byte.TYPE.equals(type)) {
            return new ByteFieldSerializer(field2);
        }
        if (Character.TYPE.equals(type)) {
            return new CharFieldSerializer(field2);
        }
        if (Short.TYPE.equals(type)) {
            return new ShortFieldSerializer(field2);
        }
        if (Integer.TYPE.equals(type)) {
            return new IntFieldSerializer(field2);
        }
        if (Long.TYPE.equals(type)) {
            return new LongFieldSerializer(field2);
        }
        if (Double.TYPE.equals(type)) {
            return new DoubleFieldSerializer(field2);
        }
        if (Float.TYPE.equals(type)) {
            return new FloatFieldSerializer(field2);
        }
        if (String.class.equals(type)) {
            return new StringFieldSerializer(field2);
        }
        if (java.util.Date.class.equals(type) || Date.class.equals(type) || Timestamp.class.equals(type) || Time.class.equals(type)) {
            return new DateFieldSerializer(field2);
        }
        return new ObjectFieldSerializer(field2);
    }

    static {
        _serializerMap = new WeakHashMap();
        NULL_ARGS = new Object[0];
        boolean isEnabled = false;
        try {
            Class<?> unsafe = Class.forName("sun.misc.Unsafe");
            Field theUnsafe = null;
            for (Field field2 : unsafe.getDeclaredFields()) {
                if (!field2.getName().equals("theUnsafe")) continue;
                theUnsafe = field2;
            }
            if (theUnsafe != null) {
                theUnsafe.setAccessible(true);
                _unsafe = (Unsafe)theUnsafe.get(null);
            }
            isEnabled = _unsafe != null;
            String unsafeProp = System.getProperty("com.caucho.hessian.unsafe");
            if ("false".equals(unsafeProp)) {
                isEnabled = false;
            }
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
        _isEnabled = isEnabled;
    }

    static final class DateFieldSerializer
    extends FieldSerializer {
        private final Field _field;
        private final long _offset;

        DateFieldSerializer(Field field2) {
            this._field = field2;
            this._offset = _unsafe.objectFieldOffset(field2);
            if (this._offset == -1L) {
                throw new IllegalStateException();
            }
        }

        @Override
        void serialize(AbstractHessianOutput out, Object obj) throws IOException {
            java.util.Date value2 = (java.util.Date)_unsafe.getObject(obj, this._offset);
            if (value2 == null) {
                out.writeNull();
            } else {
                out.writeUTCDate(value2.getTime());
            }
        }
    }

    static final class StringFieldSerializer
    extends FieldSerializer {
        private final Field _field;
        private final long _offset;

        StringFieldSerializer(Field field2) {
            this._field = field2;
            this._offset = _unsafe.objectFieldOffset(field2);
            if (this._offset == -1L) {
                throw new IllegalStateException();
            }
        }

        @Override
        final void serialize(AbstractHessianOutput out, Object obj) throws IOException {
            String value2 = (String)_unsafe.getObject(obj, this._offset);
            out.writeString(value2);
        }
    }

    static final class DoubleFieldSerializer
    extends FieldSerializer {
        private final Field _field;
        private final long _offset;

        DoubleFieldSerializer(Field field2) {
            this._field = field2;
            this._offset = _unsafe.objectFieldOffset(field2);
            if (this._offset == -1L) {
                throw new IllegalStateException();
            }
        }

        @Override
        final void serialize(AbstractHessianOutput out, Object obj) throws IOException {
            double value2 = _unsafe.getDouble(obj, this._offset);
            out.writeDouble(value2);
        }
    }

    static final class FloatFieldSerializer
    extends FieldSerializer {
        private final Field _field;
        private final long _offset;

        FloatFieldSerializer(Field field2) {
            this._field = field2;
            this._offset = _unsafe.objectFieldOffset(field2);
            if (this._offset == -1L) {
                throw new IllegalStateException();
            }
        }

        @Override
        final void serialize(AbstractHessianOutput out, Object obj) throws IOException {
            double value2 = _unsafe.getFloat(obj, this._offset);
            out.writeDouble(value2);
        }
    }

    static final class LongFieldSerializer
    extends FieldSerializer {
        private final Field _field;
        private final long _offset;

        LongFieldSerializer(Field field2) {
            this._field = field2;
            this._offset = _unsafe.objectFieldOffset(field2);
            if (this._offset == -1L) {
                throw new IllegalStateException();
            }
        }

        @Override
        final void serialize(AbstractHessianOutput out, Object obj) throws IOException {
            long value2 = _unsafe.getLong(obj, this._offset);
            out.writeLong(value2);
        }
    }

    static final class IntFieldSerializer
    extends FieldSerializer {
        private final Field _field;
        private final long _offset;

        IntFieldSerializer(Field field2) {
            this._field = field2;
            this._offset = _unsafe.objectFieldOffset(field2);
            if (this._offset == -1L) {
                throw new IllegalStateException();
            }
        }

        @Override
        final void serialize(AbstractHessianOutput out, Object obj) throws IOException {
            int value2 = _unsafe.getInt(obj, this._offset);
            out.writeInt(value2);
        }
    }

    static final class ShortFieldSerializer
    extends FieldSerializer {
        private final Field _field;
        private final long _offset;

        ShortFieldSerializer(Field field2) {
            this._field = field2;
            this._offset = _unsafe.objectFieldOffset(field2);
            if (this._offset == -1L) {
                throw new IllegalStateException();
            }
        }

        @Override
        final void serialize(AbstractHessianOutput out, Object obj) throws IOException {
            short value2 = _unsafe.getShort(obj, this._offset);
            out.writeInt(value2);
        }
    }

    static final class CharFieldSerializer
    extends FieldSerializer {
        private final Field _field;
        private final long _offset;

        CharFieldSerializer(Field field2) {
            this._field = field2;
            this._offset = _unsafe.objectFieldOffset(field2);
            if (this._offset == -1L) {
                throw new IllegalStateException();
            }
        }

        @Override
        final void serialize(AbstractHessianOutput out, Object obj) throws IOException {
            char value2 = _unsafe.getChar(obj, this._offset);
            out.writeString(String.valueOf(value2));
        }
    }

    static final class ByteFieldSerializer
    extends FieldSerializer {
        private final Field _field;
        private final long _offset;

        ByteFieldSerializer(Field field2) {
            this._field = field2;
            this._offset = _unsafe.objectFieldOffset(field2);
            if (this._offset == -1L) {
                throw new IllegalStateException();
            }
        }

        @Override
        final void serialize(AbstractHessianOutput out, Object obj) throws IOException {
            byte value2 = _unsafe.getByte(obj, this._offset);
            out.writeInt(value2);
        }
    }

    static final class BooleanFieldSerializer
    extends FieldSerializer {
        private final Field _field;
        private final long _offset;

        BooleanFieldSerializer(Field field2) {
            this._field = field2;
            this._offset = _unsafe.objectFieldOffset(field2);
            if (this._offset == -1L) {
                throw new IllegalStateException();
            }
        }

        @Override
        void serialize(AbstractHessianOutput out, Object obj) throws IOException {
            boolean value2 = _unsafe.getBoolean(obj, this._offset);
            out.writeBoolean(value2);
        }
    }

    static final class ObjectFieldSerializer
    extends FieldSerializer {
        private final Field _field;
        private final long _offset;

        ObjectFieldSerializer(Field field2) {
            this._field = field2;
            this._offset = _unsafe.objectFieldOffset(field2);
            if (this._offset == -1L) {
                throw new IllegalStateException();
            }
        }

        @Override
        final void serialize(AbstractHessianOutput out, Object obj) throws IOException {
            try {
                Object value2 = _unsafe.getObject(obj, this._offset);
                out.writeObject(value2);
            }
            catch (RuntimeException e) {
                throw new RuntimeException(e.getMessage() + "\n field: " + this._field.getDeclaringClass().getName() + '.' + this._field.getName(), e);
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e.getMessage() + "\n field: " + this._field.getDeclaringClass().getName() + '.' + this._field.getName(), e);
            }
        }
    }

    static abstract class FieldSerializer {
        FieldSerializer() {
        }

        abstract void serialize(AbstractHessianOutput var1, Object var2) throws IOException;
    }
}

