/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.hsf.services.server;

import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;

public class ServiceContext {
    private static final ThreadLocal _localContext = new ThreadLocal();
    private ServletRequest _request;
    private String _serviceName;
    private String _objectId;
    private int _count;
    private HashMap _headers = new HashMap();

    private ServiceContext() {
    }

    public static void begin(ServletRequest request2, String serviceName, String objectId) throws ServletException {
        ServiceContext context = (ServiceContext)_localContext.get();
        if (context == null) {
            context = new ServiceContext();
            _localContext.set(context);
        }
        context._request = request2;
        context._serviceName = serviceName;
        context._objectId = objectId;
        ++context._count;
    }

    public static ServiceContext getContext() {
        return (ServiceContext)_localContext.get();
    }

    public void addHeader(String header, Object value2) {
        this._headers.put(header, value2);
    }

    public Object getHeader(String header) {
        return this._headers.get(header);
    }

    public static Object getContextHeader(String header) {
        ServiceContext context = (ServiceContext)_localContext.get();
        if (context != null) {
            return context.getHeader(header);
        }
        return null;
    }

    public static ServletRequest getContextRequest() {
        ServiceContext context = (ServiceContext)_localContext.get();
        if (context != null) {
            return context._request;
        }
        return null;
    }

    public static String getContextServiceName() {
        ServiceContext context = (ServiceContext)_localContext.get();
        if (context != null) {
            return context._serviceName;
        }
        return null;
    }

    public static String getContextObjectId() {
        ServiceContext context = (ServiceContext)_localContext.get();
        if (context != null) {
            return context._objectId;
        }
        return null;
    }

    public static void end() {
        ServiceContext context = (ServiceContext)_localContext.get();
        if (context != null && --context._count == 0) {
            context._request = null;
            context._headers.clear();
        }
    }

    public static ServletRequest getRequest() {
        ServiceContext context = (ServiceContext)_localContext.get();
        if (context != null) {
            return context._request;
        }
        return null;
    }

    public static String getServiceName() {
        ServiceContext context = (ServiceContext)_localContext.get();
        if (context != null) {
            return context._serviceName;
        }
        return null;
    }

    public static String getObjectId() {
        ServiceContext context = (ServiceContext)_localContext.get();
        if (context != null) {
            return context._objectId;
        }
        return null;
    }
}

