/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.javassist.bytecode;

import com.alibaba.schedulerx.shade.javassist.CtClass;
import com.alibaba.schedulerx.shade.javassist.bytecode.ClassInfo;
import com.alibaba.schedulerx.shade.javassist.bytecode.ConstInfo;
import com.alibaba.schedulerx.shade.javassist.bytecode.ConstInfoPadding;
import com.alibaba.schedulerx.shade.javassist.bytecode.Descriptor;
import com.alibaba.schedulerx.shade.javassist.bytecode.DoubleInfo;
import com.alibaba.schedulerx.shade.javassist.bytecode.FieldrefInfo;
import com.alibaba.schedulerx.shade.javassist.bytecode.FloatInfo;
import com.alibaba.schedulerx.shade.javassist.bytecode.IntegerInfo;
import com.alibaba.schedulerx.shade.javassist.bytecode.InterfaceMethodrefInfo;
import com.alibaba.schedulerx.shade.javassist.bytecode.InvokeDynamicInfo;
import com.alibaba.schedulerx.shade.javassist.bytecode.LongInfo;
import com.alibaba.schedulerx.shade.javassist.bytecode.LongVector;
import com.alibaba.schedulerx.shade.javassist.bytecode.MemberrefInfo;
import com.alibaba.schedulerx.shade.javassist.bytecode.MethodHandleInfo;
import com.alibaba.schedulerx.shade.javassist.bytecode.MethodTypeInfo;
import com.alibaba.schedulerx.shade.javassist.bytecode.MethodrefInfo;
import com.alibaba.schedulerx.shade.javassist.bytecode.NameAndTypeInfo;
import com.alibaba.schedulerx.shade.javassist.bytecode.StringInfo;
import com.alibaba.schedulerx.shade.javassist.bytecode.Utf8Info;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class ConstPool {
    LongVector items;
    int numOfItems;
    int thisClassInfo;
    HashMap itemsCache;
    public static final int CONST_Class = 7;
    public static final int CONST_Fieldref = 9;
    public static final int CONST_Methodref = 10;
    public static final int CONST_InterfaceMethodref = 11;
    public static final int CONST_String = 8;
    public static final int CONST_Integer = 3;
    public static final int CONST_Float = 4;
    public static final int CONST_Long = 5;
    public static final int CONST_Double = 6;
    public static final int CONST_NameAndType = 12;
    public static final int CONST_Utf8 = 1;
    public static final int CONST_MethodHandle = 15;
    public static final CtClass THIS = null;
    public static final int REF_getField = 1;
    public static final int REF_getStatic = 2;
    public static final int REF_putField = 3;
    public static final int REF_putStatic = 4;
    public static final int REF_invokeVirtual = 5;
    public static final int REF_invokeStatic = 6;
    public static final int REF_invokeSpecial = 7;
    public static final int REF_newInvokeSpecial = 8;
    public static final int REF_invokeInterface = 9;

    public ConstPool(String thisclass) {
        this.items = new LongVector();
        this.itemsCache = null;
        this.numOfItems = 0;
        this.addItem0(null);
        this.thisClassInfo = this.addClassInfo(thisclass);
    }

    public ConstPool(DataInputStream in2) throws IOException {
        this.itemsCache = null;
        this.thisClassInfo = 0;
        this.read(in2);
    }

    void prune() {
        this.itemsCache = null;
    }

    public int getSize() {
        return this.numOfItems;
    }

    public String getClassName() {
        return this.getClassInfo(this.thisClassInfo);
    }

    public int getThisClassInfo() {
        return this.thisClassInfo;
    }

    void setThisClassInfo(int i) {
        this.thisClassInfo = i;
    }

    ConstInfo getItem(int n) {
        return this.items.elementAt(n);
    }

    public int getTag(int index2) {
        return this.getItem(index2).getTag();
    }

    public String getClassInfo(int index2) {
        ClassInfo c = (ClassInfo)this.getItem(index2);
        if (c == null) {
            return null;
        }
        return Descriptor.toJavaName(this.getUtf8Info(c.name));
    }

    public String getClassInfoByDescriptor(int index2) {
        ClassInfo c = (ClassInfo)this.getItem(index2);
        if (c == null) {
            return null;
        }
        String className = this.getUtf8Info(c.name);
        if (className.charAt(0) == '[') {
            return className;
        }
        return Descriptor.of(className);
    }

    public int getNameAndTypeName(int index2) {
        NameAndTypeInfo ntinfo = (NameAndTypeInfo)this.getItem(index2);
        return ntinfo.memberName;
    }

    public int getNameAndTypeDescriptor(int index2) {
        NameAndTypeInfo ntinfo = (NameAndTypeInfo)this.getItem(index2);
        return ntinfo.typeDescriptor;
    }

    public int getMemberClass(int index2) {
        MemberrefInfo minfo = (MemberrefInfo)this.getItem(index2);
        return minfo.classIndex;
    }

    public int getMemberNameAndType(int index2) {
        MemberrefInfo minfo = (MemberrefInfo)this.getItem(index2);
        return minfo.nameAndTypeIndex;
    }

    public int getFieldrefClass(int index2) {
        FieldrefInfo finfo = (FieldrefInfo)this.getItem(index2);
        return finfo.classIndex;
    }

    public String getFieldrefClassName(int index2) {
        FieldrefInfo f = (FieldrefInfo)this.getItem(index2);
        if (f == null) {
            return null;
        }
        return this.getClassInfo(f.classIndex);
    }

    public int getFieldrefNameAndType(int index2) {
        FieldrefInfo finfo = (FieldrefInfo)this.getItem(index2);
        return finfo.nameAndTypeIndex;
    }

    public String getFieldrefName(int index2) {
        FieldrefInfo f = (FieldrefInfo)this.getItem(index2);
        if (f == null) {
            return null;
        }
        NameAndTypeInfo n = (NameAndTypeInfo)this.getItem(f.nameAndTypeIndex);
        if (n == null) {
            return null;
        }
        return this.getUtf8Info(n.memberName);
    }

    public String getFieldrefType(int index2) {
        FieldrefInfo f = (FieldrefInfo)this.getItem(index2);
        if (f == null) {
            return null;
        }
        NameAndTypeInfo n = (NameAndTypeInfo)this.getItem(f.nameAndTypeIndex);
        if (n == null) {
            return null;
        }
        return this.getUtf8Info(n.typeDescriptor);
    }

    public int getMethodrefClass(int index2) {
        MethodrefInfo minfo = (MethodrefInfo)this.getItem(index2);
        return minfo.classIndex;
    }

    public String getMethodrefClassName(int index2) {
        MethodrefInfo minfo = (MethodrefInfo)this.getItem(index2);
        if (minfo == null) {
            return null;
        }
        return this.getClassInfo(minfo.classIndex);
    }

    public int getMethodrefNameAndType(int index2) {
        MethodrefInfo minfo = (MethodrefInfo)this.getItem(index2);
        return minfo.nameAndTypeIndex;
    }

    public String getMethodrefName(int index2) {
        MethodrefInfo minfo = (MethodrefInfo)this.getItem(index2);
        if (minfo == null) {
            return null;
        }
        NameAndTypeInfo n = (NameAndTypeInfo)this.getItem(minfo.nameAndTypeIndex);
        if (n == null) {
            return null;
        }
        return this.getUtf8Info(n.memberName);
    }

    public String getMethodrefType(int index2) {
        MethodrefInfo minfo = (MethodrefInfo)this.getItem(index2);
        if (minfo == null) {
            return null;
        }
        NameAndTypeInfo n = (NameAndTypeInfo)this.getItem(minfo.nameAndTypeIndex);
        if (n == null) {
            return null;
        }
        return this.getUtf8Info(n.typeDescriptor);
    }

    public int getInterfaceMethodrefClass(int index2) {
        InterfaceMethodrefInfo minfo = (InterfaceMethodrefInfo)this.getItem(index2);
        return minfo.classIndex;
    }

    public String getInterfaceMethodrefClassName(int index2) {
        InterfaceMethodrefInfo minfo = (InterfaceMethodrefInfo)this.getItem(index2);
        return this.getClassInfo(minfo.classIndex);
    }

    public int getInterfaceMethodrefNameAndType(int index2) {
        InterfaceMethodrefInfo minfo = (InterfaceMethodrefInfo)this.getItem(index2);
        return minfo.nameAndTypeIndex;
    }

    public String getInterfaceMethodrefName(int index2) {
        InterfaceMethodrefInfo minfo = (InterfaceMethodrefInfo)this.getItem(index2);
        if (minfo == null) {
            return null;
        }
        NameAndTypeInfo n = (NameAndTypeInfo)this.getItem(minfo.nameAndTypeIndex);
        if (n == null) {
            return null;
        }
        return this.getUtf8Info(n.memberName);
    }

    public String getInterfaceMethodrefType(int index2) {
        InterfaceMethodrefInfo minfo = (InterfaceMethodrefInfo)this.getItem(index2);
        if (minfo == null) {
            return null;
        }
        NameAndTypeInfo n = (NameAndTypeInfo)this.getItem(minfo.nameAndTypeIndex);
        if (n == null) {
            return null;
        }
        return this.getUtf8Info(n.typeDescriptor);
    }

    public Object getLdcValue(int index2) {
        ConstInfo constInfo = this.getItem(index2);
        Object value2 = null;
        value2 = constInfo instanceof StringInfo ? this.getStringInfo(index2) : (constInfo instanceof FloatInfo ? (Number)new Float(this.getFloatInfo(index2)) : (Number)(constInfo instanceof IntegerInfo ? (Number)new Integer(this.getIntegerInfo(index2)) : (Number)(constInfo instanceof LongInfo ? (Number)new Long(this.getLongInfo(index2)) : (Number)(constInfo instanceof DoubleInfo ? new Double(this.getDoubleInfo(index2)) : null))));
        return value2;
    }

    public int getIntegerInfo(int index2) {
        IntegerInfo i = (IntegerInfo)this.getItem(index2);
        return i.value;
    }

    public float getFloatInfo(int index2) {
        FloatInfo i = (FloatInfo)this.getItem(index2);
        return i.value;
    }

    public long getLongInfo(int index2) {
        LongInfo i = (LongInfo)this.getItem(index2);
        return i.value;
    }

    public double getDoubleInfo(int index2) {
        DoubleInfo i = (DoubleInfo)this.getItem(index2);
        return i.value;
    }

    public String getStringInfo(int index2) {
        StringInfo si = (StringInfo)this.getItem(index2);
        return this.getUtf8Info(si.string);
    }

    public String getUtf8Info(int index2) {
        Utf8Info utf = (Utf8Info)this.getItem(index2);
        return utf.string;
    }

    public int getMethodHandleKind(int index2) {
        MethodHandleInfo mhinfo = (MethodHandleInfo)this.getItem(index2);
        return mhinfo.refKind;
    }

    public int getMethodHandleIndex(int index2) {
        MethodHandleInfo mhinfo = (MethodHandleInfo)this.getItem(index2);
        return mhinfo.refIndex;
    }

    public int getMethodTypeInfo(int index2) {
        MethodTypeInfo mtinfo = (MethodTypeInfo)this.getItem(index2);
        return mtinfo.descriptor;
    }

    public int getInvokeDynamicBootstrap(int index2) {
        InvokeDynamicInfo iv = (InvokeDynamicInfo)this.getItem(index2);
        return iv.bootstrap;
    }

    public int getInvokeDynamicNameAndType(int index2) {
        InvokeDynamicInfo iv = (InvokeDynamicInfo)this.getItem(index2);
        return iv.nameAndType;
    }

    public String getInvokeDynamicType(int index2) {
        InvokeDynamicInfo iv = (InvokeDynamicInfo)this.getItem(index2);
        if (iv == null) {
            return null;
        }
        NameAndTypeInfo n = (NameAndTypeInfo)this.getItem(iv.nameAndType);
        if (n == null) {
            return null;
        }
        return this.getUtf8Info(n.typeDescriptor);
    }

    public int isConstructor(String classname, int index2) {
        return this.isMember(classname, "<init>", index2);
    }

    public int isMember(String classname, String membername, int index2) {
        MemberrefInfo minfo = (MemberrefInfo)this.getItem(index2);
        if (this.getClassInfo(minfo.classIndex).equals(classname)) {
            NameAndTypeInfo ntinfo = (NameAndTypeInfo)this.getItem(minfo.nameAndTypeIndex);
            if (this.getUtf8Info(ntinfo.memberName).equals(membername)) {
                return ntinfo.typeDescriptor;
            }
        }
        return 0;
    }

    public String eqMember(String membername, String desc, int index2) {
        MemberrefInfo minfo = (MemberrefInfo)this.getItem(index2);
        NameAndTypeInfo ntinfo = (NameAndTypeInfo)this.getItem(minfo.nameAndTypeIndex);
        if (this.getUtf8Info(ntinfo.memberName).equals(membername) && this.getUtf8Info(ntinfo.typeDescriptor).equals(desc)) {
            return this.getClassInfo(minfo.classIndex);
        }
        return null;
    }

    private int addItem0(ConstInfo info) {
        this.items.addElement(info);
        return this.numOfItems++;
    }

    private int addItem(ConstInfo info) {
        ConstInfo found;
        if (this.itemsCache == null) {
            this.itemsCache = ConstPool.makeItemsCache(this.items);
        }
        if ((found = (ConstInfo)this.itemsCache.get(info)) != null) {
            return found.index;
        }
        this.items.addElement(info);
        this.itemsCache.put(info, info);
        return this.numOfItems++;
    }

    public int copy(int n, ConstPool dest, Map classnames) {
        if (n == 0) {
            return 0;
        }
        ConstInfo info = this.getItem(n);
        return info.copy(this, dest, classnames);
    }

    int addConstInfoPadding() {
        return this.addItem0(new ConstInfoPadding(this.numOfItems));
    }

    public int addClassInfo(CtClass c) {
        if (c == THIS) {
            return this.thisClassInfo;
        }
        if (!c.isArray()) {
            return this.addClassInfo(c.getName());
        }
        return this.addClassInfo(Descriptor.toJvmName(c));
    }

    public int addClassInfo(String qname) {
        int utf8 = this.addUtf8Info(Descriptor.toJvmName(qname));
        return this.addItem(new ClassInfo(utf8, this.numOfItems));
    }

    public int addNameAndTypeInfo(String name, String type) {
        return this.addNameAndTypeInfo(this.addUtf8Info(name), this.addUtf8Info(type));
    }

    public int addNameAndTypeInfo(int name, int type) {
        return this.addItem(new NameAndTypeInfo(name, type, this.numOfItems));
    }

    public int addFieldrefInfo(int classInfo, String name, String type) {
        int nt = this.addNameAndTypeInfo(name, type);
        return this.addFieldrefInfo(classInfo, nt);
    }

    public int addFieldrefInfo(int classInfo, int nameAndTypeInfo) {
        return this.addItem(new FieldrefInfo(classInfo, nameAndTypeInfo, this.numOfItems));
    }

    public int addMethodrefInfo(int classInfo, String name, String type) {
        int nt = this.addNameAndTypeInfo(name, type);
        return this.addMethodrefInfo(classInfo, nt);
    }

    public int addMethodrefInfo(int classInfo, int nameAndTypeInfo) {
        return this.addItem(new MethodrefInfo(classInfo, nameAndTypeInfo, this.numOfItems));
    }

    public int addInterfaceMethodrefInfo(int classInfo, String name, String type) {
        int nt = this.addNameAndTypeInfo(name, type);
        return this.addInterfaceMethodrefInfo(classInfo, nt);
    }

    public int addInterfaceMethodrefInfo(int classInfo, int nameAndTypeInfo) {
        return this.addItem(new InterfaceMethodrefInfo(classInfo, nameAndTypeInfo, this.numOfItems));
    }

    public int addStringInfo(String str) {
        int utf = this.addUtf8Info(str);
        return this.addItem(new StringInfo(utf, this.numOfItems));
    }

    public int addIntegerInfo(int i) {
        return this.addItem(new IntegerInfo(i, this.numOfItems));
    }

    public int addFloatInfo(float f) {
        return this.addItem(new FloatInfo(f, this.numOfItems));
    }

    public int addLongInfo(long l) {
        int i = this.addItem(new LongInfo(l, this.numOfItems));
        if (i == this.numOfItems - 1) {
            this.addConstInfoPadding();
        }
        return i;
    }

    public int addDoubleInfo(double d) {
        int i = this.addItem(new DoubleInfo(d, this.numOfItems));
        if (i == this.numOfItems - 1) {
            this.addConstInfoPadding();
        }
        return i;
    }

    public int addUtf8Info(String utf8) {
        return this.addItem(new Utf8Info(utf8, this.numOfItems));
    }

    public int addMethodHandleInfo(int kind, int index2) {
        return this.addItem(new MethodHandleInfo(kind, index2, this.numOfItems));
    }

    public int addMethodTypeInfo(int desc) {
        return this.addItem(new MethodTypeInfo(desc, this.numOfItems));
    }

    public int addInvokeDynamicInfo(int bootstrap, int nameAndType) {
        return this.addItem(new InvokeDynamicInfo(bootstrap, nameAndType, this.numOfItems));
    }

    public Set getClassNames() {
        HashSet<String> result2 = new HashSet<String>();
        LongVector v = this.items;
        int size2 = this.numOfItems;
        for (int i = 1; i < size2; ++i) {
            String className = v.elementAt(i).getClassName(this);
            if (className == null) continue;
            result2.add(className);
        }
        return result2;
    }

    public void renameClass(String oldName, String newName) {
        LongVector v = this.items;
        int size2 = this.numOfItems;
        for (int i = 1; i < size2; ++i) {
            ConstInfo ci = v.elementAt(i);
            ci.renameClass(this, oldName, newName, this.itemsCache);
        }
    }

    public void renameClass(Map classnames) {
        LongVector v = this.items;
        int size2 = this.numOfItems;
        for (int i = 1; i < size2; ++i) {
            ConstInfo ci = v.elementAt(i);
            ci.renameClass(this, classnames, this.itemsCache);
        }
    }

    private void read(DataInputStream in2) throws IOException {
        int n = in2.readUnsignedShort();
        this.items = new LongVector(n);
        this.numOfItems = 0;
        this.addItem0(null);
        while (--n > 0) {
            int tag = this.readOne(in2);
            if (tag != 5 && tag != 6) continue;
            this.addConstInfoPadding();
            --n;
        }
    }

    private static HashMap makeItemsCache(LongVector items) {
        ConstInfo info;
        HashMap<ConstInfo, ConstInfo> cache = new HashMap<ConstInfo, ConstInfo>();
        int i = 1;
        while ((info = items.elementAt(i++)) != null) {
            cache.put(info, info);
        }
        return cache;
    }

    private int readOne(DataInputStream in2) throws IOException {
        ConstInfo info;
        int tag = in2.readUnsignedByte();
        switch (tag) {
            case 1: {
                info = new Utf8Info(in2, this.numOfItems);
                break;
            }
            case 3: {
                info = new IntegerInfo(in2, this.numOfItems);
                break;
            }
            case 4: {
                info = new FloatInfo(in2, this.numOfItems);
                break;
            }
            case 5: {
                info = new LongInfo(in2, this.numOfItems);
                break;
            }
            case 6: {
                info = new DoubleInfo(in2, this.numOfItems);
                break;
            }
            case 7: {
                info = new ClassInfo(in2, this.numOfItems);
                break;
            }
            case 8: {
                info = new StringInfo(in2, this.numOfItems);
                break;
            }
            case 9: {
                info = new FieldrefInfo(in2, this.numOfItems);
                break;
            }
            case 10: {
                info = new MethodrefInfo(in2, this.numOfItems);
                break;
            }
            case 11: {
                info = new InterfaceMethodrefInfo(in2, this.numOfItems);
                break;
            }
            case 12: {
                info = new NameAndTypeInfo(in2, this.numOfItems);
                break;
            }
            case 15: {
                info = new MethodHandleInfo(in2, this.numOfItems);
                break;
            }
            case 16: {
                info = new MethodTypeInfo(in2, this.numOfItems);
                break;
            }
            case 18: {
                info = new InvokeDynamicInfo(in2, this.numOfItems);
                break;
            }
            default: {
                throw new IOException("invalid constant type: " + tag + " at " + this.numOfItems);
            }
        }
        this.addItem0(info);
        return tag;
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeShort(this.numOfItems);
        LongVector v = this.items;
        int size2 = this.numOfItems;
        for (int i = 1; i < size2; ++i) {
            v.elementAt(i).write(out);
        }
    }

    public void print() {
        this.print(new PrintWriter(System.out, true));
    }

    public void print(PrintWriter out) {
        int size2 = this.numOfItems;
        for (int i = 1; i < size2; ++i) {
            out.print(i);
            out.print(" ");
            this.items.elementAt(i).print(out);
        }
    }
}

