/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.javassist.bytecode.analysis;

import com.alibaba.schedulerx.shade.javassist.bytecode.BadBytecode;
import com.alibaba.schedulerx.shade.javassist.bytecode.CodeAttribute;
import com.alibaba.schedulerx.shade.javassist.bytecode.CodeIterator;
import com.alibaba.schedulerx.shade.javassist.bytecode.ExceptionTable;
import com.alibaba.schedulerx.shade.javassist.bytecode.MethodInfo;
import com.alibaba.schedulerx.shade.javassist.bytecode.Opcode;
import com.alibaba.schedulerx.shade.javassist.bytecode.analysis.Subroutine;
import com.alibaba.schedulerx.shade.javassist.bytecode.analysis.Util;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SubroutineScanner
implements Opcode {
    private Subroutine[] subroutines;
    Map subTable = new HashMap();
    Set done = new HashSet();

    public Subroutine[] scan(MethodInfo method) throws BadBytecode {
        CodeAttribute code = method.getCodeAttribute();
        CodeIterator iter2 = code.iterator();
        this.subroutines = new Subroutine[code.getCodeLength()];
        this.subTable.clear();
        this.done.clear();
        this.scan(0, iter2, null);
        ExceptionTable exceptions = code.getExceptionTable();
        for (int i = 0; i < exceptions.size(); ++i) {
            int handler = exceptions.handlerPc(i);
            this.scan(handler, iter2, this.subroutines[exceptions.startPc(i)]);
        }
        return this.subroutines;
    }

    private void scan(int pos, CodeIterator iter2, Subroutine sub) throws BadBytecode {
        boolean next2;
        if (this.done.contains(new Integer(pos))) {
            return;
        }
        this.done.add(new Integer(pos));
        int old = iter2.lookAhead();
        iter2.move(pos);
        while (next2 = this.scanOp(pos = iter2.next(), iter2, sub) && iter2.hasNext()) {
        }
        iter2.move(old);
    }

    private boolean scanOp(int pos, CodeIterator iter2, Subroutine sub) throws BadBytecode {
        this.subroutines[pos] = sub;
        int opcode = iter2.byteAt(pos);
        if (opcode == 170) {
            this.scanTableSwitch(pos, iter2, sub);
            return false;
        }
        if (opcode == 171) {
            this.scanLookupSwitch(pos, iter2, sub);
            return false;
        }
        if (Util.isReturn(opcode) || opcode == 169 || opcode == 191) {
            return false;
        }
        if (Util.isJumpInstruction(opcode)) {
            int target = Util.getJumpTarget(pos, iter2);
            if (opcode == 168 || opcode == 201) {
                Subroutine s2 = (Subroutine)this.subTable.get(new Integer(target));
                if (s2 == null) {
                    s2 = new Subroutine(target, pos);
                    this.subTable.put(new Integer(target), s2);
                    this.scan(target, iter2, s2);
                } else {
                    s2.addCaller(pos);
                }
            } else {
                this.scan(target, iter2, sub);
                if (Util.isGoto(opcode)) {
                    return false;
                }
            }
        }
        return true;
    }

    private void scanLookupSwitch(int pos, CodeIterator iter2, Subroutine sub) throws BadBytecode {
        int index2 = (pos & 0xFFFFFFFC) + 4;
        this.scan(pos + iter2.s32bitAt(index2), iter2, sub);
        int npairs = iter2.s32bitAt(index2 += 4);
        int end = npairs * 8 + (index2 += 4);
        index2 += 4;
        while (index2 < end) {
            int target = iter2.s32bitAt(index2) + pos;
            this.scan(target, iter2, sub);
            index2 += 8;
        }
    }

    private void scanTableSwitch(int pos, CodeIterator iter2, Subroutine sub) throws BadBytecode {
        int index2 = (pos & 0xFFFFFFFC) + 4;
        this.scan(pos + iter2.s32bitAt(index2), iter2, sub);
        int low = iter2.s32bitAt(index2 += 4);
        int high = iter2.s32bitAt(index2 += 4);
        int end = (high - low + 1) * 4 + (index2 += 4);
        while (index2 < end) {
            int target = iter2.s32bitAt(index2) + pos;
            this.scan(target, iter2, sub);
            index2 += 4;
        }
    }
}

