/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.javassist.bytecode.annotation;

import com.alibaba.schedulerx.shade.javassist.ClassPool;
import com.alibaba.schedulerx.shade.javassist.bytecode.ConstPool;
import com.alibaba.schedulerx.shade.javassist.bytecode.annotation.AnnotationsWriter;
import com.alibaba.schedulerx.shade.javassist.bytecode.annotation.MemberValue;
import com.alibaba.schedulerx.shade.javassist.bytecode.annotation.MemberValueVisitor;
import java.io.IOException;
import java.lang.reflect.Method;

public class IntegerMemberValue
extends MemberValue {
    int valueIndex;

    public IntegerMemberValue(int index2, ConstPool cp) {
        super('I', cp);
        this.valueIndex = index2;
    }

    public IntegerMemberValue(ConstPool cp, int value2) {
        super('I', cp);
        this.setValue(value2);
    }

    public IntegerMemberValue(ConstPool cp) {
        super('I', cp);
        this.setValue(0);
    }

    @Override
    Object getValue(ClassLoader cl, ClassPool cp, Method m) {
        return new Integer(this.getValue());
    }

    @Override
    Class getType(ClassLoader cl) {
        return Integer.TYPE;
    }

    public int getValue() {
        return this.cp.getIntegerInfo(this.valueIndex);
    }

    public void setValue(int newValue) {
        this.valueIndex = this.cp.addIntegerInfo(newValue);
    }

    public String toString() {
        return Integer.toString(this.getValue());
    }

    @Override
    public void write(AnnotationsWriter writer) throws IOException {
        writer.constValueIndex(this.getValue());
    }

    @Override
    public void accept(MemberValueVisitor visitor) {
        visitor.visitIntegerMemberValue(this);
    }
}

