/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.javassist.convert;

import com.alibaba.schedulerx.shade.javassist.CtClass;
import com.alibaba.schedulerx.shade.javassist.CtMethod;
import com.alibaba.schedulerx.shade.javassist.NotFoundException;
import com.alibaba.schedulerx.shade.javassist.bytecode.BadBytecode;
import com.alibaba.schedulerx.shade.javassist.bytecode.Bytecode;
import com.alibaba.schedulerx.shade.javassist.bytecode.CodeAttribute;
import com.alibaba.schedulerx.shade.javassist.bytecode.CodeIterator;
import com.alibaba.schedulerx.shade.javassist.bytecode.ConstPool;
import com.alibaba.schedulerx.shade.javassist.bytecode.Descriptor;
import com.alibaba.schedulerx.shade.javassist.convert.TransformCall;
import com.alibaba.schedulerx.shade.javassist.convert.Transformer;

public class TransformBefore
extends TransformCall {
    protected CtClass[] parameterTypes;
    protected int locals;
    protected int maxLocals;
    protected byte[] saveCode;
    protected byte[] loadCode;

    public TransformBefore(Transformer next2, CtMethod origMethod, CtMethod beforeMethod) throws NotFoundException {
        super(next2, origMethod, beforeMethod);
        this.methodDescriptor = origMethod.getMethodInfo2().getDescriptor();
        this.parameterTypes = origMethod.getParameterTypes();
        this.locals = 0;
        this.maxLocals = 0;
        this.loadCode = null;
        this.saveCode = null;
    }

    @Override
    public void initialize(ConstPool cp, CodeAttribute attr) {
        super.initialize(cp, attr);
        this.locals = 0;
        this.maxLocals = attr.getMaxLocals();
        this.loadCode = null;
        this.saveCode = null;
    }

    @Override
    protected int match(int c, int pos, CodeIterator iterator2, int typedesc, ConstPool cp) throws BadBytecode {
        if (this.newIndex == 0) {
            String desc = Descriptor.ofParameters(this.parameterTypes) + 'V';
            desc = Descriptor.insertParameter(this.classname, desc);
            int nt = cp.addNameAndTypeInfo(this.newMethodname, desc);
            int ci = cp.addClassInfo(this.newClassname);
            this.newIndex = cp.addMethodrefInfo(ci, nt);
            this.constPool = cp;
        }
        if (this.saveCode == null) {
            this.makeCode(this.parameterTypes, cp);
        }
        return this.match2(pos, iterator2);
    }

    protected int match2(int pos, CodeIterator iterator2) throws BadBytecode {
        iterator2.move(pos);
        iterator2.insert(this.saveCode);
        iterator2.insert(this.loadCode);
        int p = iterator2.insertGap(3);
        iterator2.writeByte(184, p);
        iterator2.write16bit(this.newIndex, p + 1);
        iterator2.insert(this.loadCode);
        return iterator2.next();
    }

    @Override
    public int extraLocals() {
        return this.locals;
    }

    protected void makeCode(CtClass[] paramTypes, ConstPool cp) {
        Bytecode save = new Bytecode(cp, 0, 0);
        Bytecode load2 = new Bytecode(cp, 0, 0);
        int var = this.maxLocals;
        int len2 = paramTypes == null ? 0 : paramTypes.length;
        load2.addAload(var);
        this.makeCode2(save, load2, 0, len2, paramTypes, var + 1);
        save.addAstore(var);
        this.saveCode = save.get();
        this.loadCode = load2.get();
    }

    private void makeCode2(Bytecode save, Bytecode load2, int i, int n, CtClass[] paramTypes, int var) {
        if (i < n) {
            int size2 = load2.addLoad(var, paramTypes[i]);
            this.makeCode2(save, load2, i + 1, n, paramTypes, var + size2);
            save.addStore(var, paramTypes[i]);
        } else {
            this.locals = var - this.maxLocals;
        }
    }
}

