/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.javassist.convert;

import com.alibaba.schedulerx.shade.javassist.CannotCompileException;
import com.alibaba.schedulerx.shade.javassist.CtClass;
import com.alibaba.schedulerx.shade.javassist.bytecode.CodeAttribute;
import com.alibaba.schedulerx.shade.javassist.bytecode.CodeIterator;
import com.alibaba.schedulerx.shade.javassist.bytecode.ConstPool;
import com.alibaba.schedulerx.shade.javassist.convert.Transformer;

public final class TransformNewClass
extends Transformer {
    private int nested;
    private String classname;
    private String newClassName;
    private int newClassIndex;
    private int newMethodNTIndex;
    private int newMethodIndex;

    public TransformNewClass(Transformer next2, String classname, String newClassName) {
        super(next2);
        this.classname = classname;
        this.newClassName = newClassName;
    }

    @Override
    public void initialize(ConstPool cp, CodeAttribute attr) {
        this.nested = 0;
        this.newMethodIndex = 0;
        this.newMethodNTIndex = 0;
        this.newClassIndex = 0;
    }

    @Override
    public int transform(CtClass clazz, int pos, CodeIterator iterator2, ConstPool cp) throws CannotCompileException {
        int index2;
        int typedesc;
        int c = iterator2.byteAt(pos);
        if (c == 187) {
            int index3 = iterator2.u16bitAt(pos + 1);
            if (cp.getClassInfo(index3).equals(this.classname)) {
                if (iterator2.byteAt(pos + 3) != 89) {
                    throw new CannotCompileException("NEW followed by no DUP was found");
                }
                if (this.newClassIndex == 0) {
                    this.newClassIndex = cp.addClassInfo(this.newClassName);
                }
                iterator2.write16bit(this.newClassIndex, pos + 1);
                ++this.nested;
            }
        } else if (c == 183 && (typedesc = cp.isConstructor(this.classname, index2 = iterator2.u16bitAt(pos + 1))) != 0 && this.nested > 0) {
            int nt = cp.getMethodrefNameAndType(index2);
            if (this.newMethodNTIndex != nt) {
                this.newMethodNTIndex = nt;
                this.newMethodIndex = cp.addMethodrefInfo(this.newClassIndex, nt);
            }
            iterator2.write16bit(this.newMethodIndex, pos + 1);
            --this.nested;
        }
        return pos;
    }
}

